/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.SubscriptionItemCreateRequest;

@ApiModel(description="Subscription plan information.")
public class SubscriptionPlanCreateRequest {
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private String planId;
    public static final String SERIALIZED_NAME_PLAN_NUMBER = "plan_number";
    @SerializedName(value="plan_number")
    private String planNumber;
    public static final String SERIALIZED_NAME_PRICES = "prices";
    @SerializedName(value="prices")
    private List<SubscriptionItemCreateRequest> prices = null;
    public static final String SERIALIZED_NAME_UNIQUE_TOKEN = "unique_token";
    @SerializedName(value="unique_token")
    private String uniqueToken;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;

    public SubscriptionPlanCreateRequest planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the plan associated with this subscription plan.")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public SubscriptionPlanCreateRequest planNumber(String planNumber) {
        this.planNumber = planNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the plan associated with this subscription plan.")
    public String getPlanNumber() {
        return this.planNumber;
    }

    public void setPlanNumber(String planNumber) {
        this.planNumber = planNumber;
    }

    public SubscriptionPlanCreateRequest prices(List<SubscriptionItemCreateRequest> prices) {
        this.prices = prices;
        return this;
    }

    public SubscriptionPlanCreateRequest addPricesItem(SubscriptionItemCreateRequest pricesItem) {
        if (this.prices == null) {
            this.prices = new ArrayList<SubscriptionItemCreateRequest>();
        }
        this.prices.add(pricesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Price information within the subscription plan.")
    public List<SubscriptionItemCreateRequest> getPrices() {
        return this.prices;
    }

    public void setPrices(List<SubscriptionItemCreateRequest> prices) {
        this.prices = prices;
    }

    public SubscriptionPlanCreateRequest uniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the subscription plan. This identifier enables you to refer to the subscription plan before the subscription plan has an internal identifier in Zuora.")
    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    public SubscriptionPlanCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionPlanCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPlanCreateRequest subscriptionPlanCreateRequest = (SubscriptionPlanCreateRequest)o;
        return Objects.equals(this.planId, subscriptionPlanCreateRequest.planId) && Objects.equals(this.planNumber, subscriptionPlanCreateRequest.planNumber) && Objects.equals(this.prices, subscriptionPlanCreateRequest.prices) && Objects.equals(this.uniqueToken, subscriptionPlanCreateRequest.uniqueToken) && Objects.equals(this.customFields, subscriptionPlanCreateRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.planId, this.planNumber, this.prices, this.uniqueToken, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPlanCreateRequest {\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    planNumber: ").append(this.toIndentedString(this.planNumber)).append("\n");
        sb.append("    prices: ").append(this.toIndentedString(this.prices)).append("\n");
        sb.append("    uniqueToken: ").append(this.toIndentedString(this.uniqueToken)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

