/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.FulfillmentItemCreateRequestForFulfillmentPost;
import org.openapitools.client.model.Revenue;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

public class FulfillmentRequest {
    public static final String SERIALIZED_NAME_ORDER_LINE_ITEM_ID = "order_line_item_id";
    @SerializedName(value="order_line_item_id")
    private String orderLineItemId;
    public static final String SERIALIZED_NAME_CARRIER = "carrier";
    @SerializedName(value="carrier")
    private String carrier;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private Revenue revenue;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "external_id";
    @SerializedName(value="external_id")
    private String externalId;
    public static final String SERIALIZED_NAME_FULFILLMENT_DATE = "fulfillment_date";
    @SerializedName(value="fulfillment_date")
    private LocalDate fulfillmentDate;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private String location;
    public static final String SERIALIZED_NAME_FULFILLMENT_SYSTEM = "fulfillment_system";
    @SerializedName(value="fulfillment_system")
    private String fulfillmentSystem;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TRACKING_NUMBER = "tracking_number";
    @SerializedName(value="tracking_number")
    private String trackingNumber;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<FulfillmentItemCreateRequestForFulfillmentPost> items = null;

    public FulfillmentRequest orderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique identifier of the associated order line item.")
    public String getOrderLineItemId() {
        return this.orderLineItemId;
    }

    public void setOrderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
    }

    public FulfillmentRequest carrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the shipping carrier for this fulfillment.")
    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public FulfillmentRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public FulfillmentRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public FulfillmentRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FulfillmentRequest revenue(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Revenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Revenue revenue) {
        this.revenue = revenue;
    }

    public FulfillmentRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An external identifier for the fulfillment")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public FulfillmentRequest fulfillmentDate(LocalDate fulfillmentDate) {
        this.fulfillmentDate = fulfillmentDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", required=true, value="The date of the fulfillment.")
    public LocalDate getFulfillmentDate() {
        return this.fulfillmentDate;
    }

    public void setFulfillmentDate(LocalDate fulfillmentDate) {
        this.fulfillmentDate = fulfillmentDate;
    }

    public FulfillmentRequest location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fulfillment location of the fulfillment.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public FulfillmentRequest fulfillmentSystem(String fulfillmentSystem) {
        this.fulfillmentSystem = fulfillmentSystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fulfillment system for the fulfillment.")
    public String getFulfillmentSystem() {
        return this.fulfillmentSystem;
    }

    public void setFulfillmentSystem(String fulfillmentSystem) {
        this.fulfillmentSystem = fulfillmentSystem;
    }

    public FulfillmentRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of fulfillment.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FulfillmentRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of units of this item.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public FulfillmentRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the invoice.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public FulfillmentRequest trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tracking number of the fulfillment.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public FulfillmentRequest items(List<FulfillmentItemCreateRequestForFulfillmentPost> items) {
        this.items = items;
        return this;
    }

    public FulfillmentRequest addItemsItem(FulfillmentItemCreateRequestForFulfillmentPost itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<FulfillmentItemCreateRequestForFulfillmentPost>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all fulfillment items.")
    public List<FulfillmentItemCreateRequestForFulfillmentPost> getItems() {
        return this.items;
    }

    public void setItems(List<FulfillmentItemCreateRequestForFulfillmentPost> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentRequest fulfillmentRequest = (FulfillmentRequest)o;
        return Objects.equals(this.orderLineItemId, fulfillmentRequest.orderLineItemId) && Objects.equals(this.carrier, fulfillmentRequest.carrier) && Objects.equals(this.customFields, fulfillmentRequest.customFields) && Objects.equals(this.description, fulfillmentRequest.description) && Objects.equals(this.revenue, fulfillmentRequest.revenue) && Objects.equals(this.externalId, fulfillmentRequest.externalId) && Objects.equals(this.fulfillmentDate, fulfillmentRequest.fulfillmentDate) && Objects.equals(this.location, fulfillmentRequest.location) && Objects.equals(this.fulfillmentSystem, fulfillmentRequest.fulfillmentSystem) && Objects.equals((Object)this.type, (Object)fulfillmentRequest.type) && Objects.equals(this.quantity, fulfillmentRequest.quantity) && Objects.equals((Object)this.state, (Object)fulfillmentRequest.state) && Objects.equals(this.trackingNumber, fulfillmentRequest.trackingNumber) && Objects.equals(this.items, fulfillmentRequest.items);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderLineItemId, this.carrier, this.customFields, this.description, this.revenue, this.externalId, this.fulfillmentDate, this.location, this.fulfillmentSystem, this.type, this.quantity, this.state, this.trackingNumber, this.items});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentRequest {\n");
        sb.append("    orderLineItemId: ").append(this.toIndentedString(this.orderLineItemId)).append("\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    fulfillmentDate: ").append(this.toIndentedString(this.fulfillmentDate)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    fulfillmentSystem: ").append(this.toIndentedString(this.fulfillmentSystem)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACCEPTED("accepted"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DELIVERY("delivery"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

