/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ChargeType {
    ONETIME("OneTime"),
    RECURRING("Recurring"),
    USAGE("Usage");

    private String value;

    private ChargeType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChargeType fromValue(String value) {
        for (ChargeType b : ChargeType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ChargeType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ChargeType> {
        public void write(JsonWriter jsonWriter, ChargeType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ChargeType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ChargeType.fromValue(value);
        }
    }
}

