/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CancelOrderRequest;
import com.zuora.model.CancelOrderResponse;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateOrderAsyncRequest;
import com.zuora.model.CreateOrderAsyncResponse;
import com.zuora.model.CreateOrderRequest;
import com.zuora.model.CreateOrderResponse;
import com.zuora.model.CreateOrderResponseOrderAction;
import com.zuora.model.CreateOrderResponseOrderMetric;
import com.zuora.model.GetAsyncOrderJobResponse;
import com.zuora.model.GetOrderResponse;
import com.zuora.model.GetOrdersResponse;
import com.zuora.model.OrderStatus;
import com.zuora.model.PreviewOrderAsyncRequest;
import com.zuora.model.PreviewOrderAsyncResponse;
import com.zuora.model.PreviewOrderRequest;
import com.zuora.model.PreviewOrderResponse;
import com.zuora.model.RevertOrderRequest;
import com.zuora.model.RevertOrderResponse;
import com.zuora.model.UpdateOrderCustomFieldsRequest;
import com.zuora.model.UpdateOrderRequest;
import com.zuora.model.UpdateOrderTriggerDatesRequest;
import com.zuora.model.UpdateOrderTriggerDatesResponse;
import com.zuora.model.UpdateSubscriptionCustomFieldsRequest;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class OrdersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call activateOrderCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/{orderNumber}/activate".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call activateOrderValidateBeforeCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling activateOrder(Async)");
        }
        return this.activateOrderCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateOrderResponse activateOrder(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateOrderResponse> localVarResp = this.activateOrderWithHttpInfo(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateOrderResponse> activateOrderWithHttpInfo(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.activateOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call activateOrderAsync(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.activateOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActivateOrderApi activateOrderApi(String orderNumber) {
        return new ActivateOrderApi(orderNumber);
    }

    private Call cancelOrderCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, CancelOrderRequest body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancelOrderRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/{orderNumber}/cancel".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrderValidateBeforeCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, CancelOrderRequest body, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling cancelOrder(Async)");
        }
        return this.cancelOrderCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, body, _callback);
    }

    protected CancelOrderResponse cancelOrder(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, CancelOrderRequest body) throws ApiException {
        ApiResponse<CancelOrderResponse> localVarResp = this.cancelOrderWithHttpInfo(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, body);
        return localVarResp.getData();
    }

    private ApiResponse<CancelOrderResponse> cancelOrderWithHttpInfo(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, CancelOrderRequest body) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, body, null);
        try {
            Type localVarReturnType = new TypeToken<CancelOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelOrderAsync(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, CancelOrderRequest body, ApiCallback<CancelOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, body, _callback);
        Type localVarReturnType = new TypeToken<CancelOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelOrderApi cancelOrderApi(String orderNumber) {
        return new CancelOrderApi(orderNumber);
    }

    private Call createOrderCall(CreateOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrderRequest localVarPostBody = body;
        String localVarPath = "/v1/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (returnIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("returnIds", returnIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderValidateBeforeCall(CreateOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createOrder(Async)");
        }
        return this.createOrderCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateOrderResponse createOrder(CreateOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateOrderResponse> localVarResp = this.createOrderWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateOrderResponse> createOrderWithHttpInfo(CreateOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createOrderAsync(CreateOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOrderApi createOrderApi(CreateOrderRequest body) {
        return new CreateOrderApi(body);
    }

    private Call createOrderAsynchronouslyCall(CreateOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOrderAsyncRequest localVarPostBody = body;
        String localVarPath = "/v1/async/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (returnIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("returnIds", returnIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderAsynchronouslyValidateBeforeCall(CreateOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createOrderAsynchronously(Async)");
        }
        return this.createOrderAsynchronouslyCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateOrderAsyncResponse createOrderAsynchronously(CreateOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateOrderAsyncResponse> localVarResp = this.createOrderAsynchronouslyWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateOrderAsyncResponse> createOrderAsynchronouslyWithHttpInfo(CreateOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createOrderAsynchronouslyValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateOrderAsyncResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createOrderAsynchronouslyAsync(CreateOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean returnIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateOrderAsyncResponse> _callback) throws ApiException {
        Call localVarCall = this.createOrderAsynchronouslyValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, returnIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateOrderAsyncResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOrderAsynchronouslyApi createOrderAsynchronouslyApi(CreateOrderAsyncRequest body) {
        return new CreateOrderAsynchronouslyApi(body);
    }

    private Call deleteOrderCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/{orderNumber}".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOrderValidateBeforeCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling deleteOrder(Async)");
        }
        return this.deleteOrderCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deleteOrder(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deleteOrderWithHttpInfo(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deleteOrderWithHttpInfo(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deleteOrderAsync(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteOrderApi deleteOrderApi(String orderNumber) {
        return new DeleteOrderApi(orderNumber);
    }

    private Call getJobStatusAndResponseCall(String jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/async-jobs/{jobId}".replace("{jobId}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobStatusAndResponseValidateBeforeCall(String jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getJobStatusAndResponse(Async)");
        }
        return this.getJobStatusAndResponseCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetAsyncOrderJobResponse getJobStatusAndResponse(String jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetAsyncOrderJobResponse> localVarResp = this.getJobStatusAndResponseWithHttpInfo(jobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetAsyncOrderJobResponse> getJobStatusAndResponseWithHttpInfo(String jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getJobStatusAndResponseValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetAsyncOrderJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getJobStatusAndResponseAsync(String jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetAsyncOrderJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getJobStatusAndResponseValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetAsyncOrderJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetJobStatusAndResponseApi getJobStatusAndResponseApi(String jobId) {
        return new GetJobStatusAndResponseApi(jobId);
    }

    private Call getOrderCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/{orderNumber}".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (getAccountDetails != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getAccountDetails", getAccountDetails));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderValidateBeforeCall(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling getOrder(Async)");
        }
        return this.getOrderCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrderResponse getOrder(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrderResponse> localVarResp = this.getOrderWithHttpInfo(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrderResponse> getOrderWithHttpInfo(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrderAsync(String orderNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrderApi getOrderApi(String orderNumber) {
        return new GetOrderApi(orderNumber);
    }

    private Call getOrdersCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateFilterOption != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dateFilterOption", dateFilterOption));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrdersValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getOrdersCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrdersResponse getOrders(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrdersResponse> localVarResp = this.getOrdersWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrdersResponse> getOrdersWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrdersValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrdersAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrdersResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrdersValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrdersApi getOrdersApi() {
        return new GetOrdersApi();
    }

    private Call getOrdersByInvoiceOwnerCall(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/invoiceOwner/{accountNumber}".replace("{accountNumber}", this.localVarApiClient.escapeString(accountNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateFilterOption != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dateFilterOption", dateFilterOption));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrdersByInvoiceOwnerValidateBeforeCall(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountNumber == null) {
            throw new ApiException("Missing the required parameter 'accountNumber' when calling getOrdersByInvoiceOwner(Async)");
        }
        return this.getOrdersByInvoiceOwnerCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrdersResponse getOrdersByInvoiceOwner(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrdersResponse> localVarResp = this.getOrdersByInvoiceOwnerWithHttpInfo(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrdersResponse> getOrdersByInvoiceOwnerWithHttpInfo(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrdersByInvoiceOwnerValidateBeforeCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrdersByInvoiceOwnerAsync(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrdersResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrdersByInvoiceOwnerValidateBeforeCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrdersByInvoiceOwnerApi getOrdersByInvoiceOwnerApi(String accountNumber) {
        return new GetOrdersByInvoiceOwnerApi(accountNumber);
    }

    private Call getOrdersBySubscriptionNumberCall(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/subscription/{subscriptionNumber}".replace("{subscriptionNumber}", this.localVarApiClient.escapeString(subscriptionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateFilterOption != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dateFilterOption", dateFilterOption));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrdersBySubscriptionNumberValidateBeforeCall(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumber == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumber' when calling getOrdersBySubscriptionNumber(Async)");
        }
        return this.getOrdersBySubscriptionNumberCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrdersResponse getOrdersBySubscriptionNumber(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrdersResponse> localVarResp = this.getOrdersBySubscriptionNumberWithHttpInfo(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrdersResponse> getOrdersBySubscriptionNumberWithHttpInfo(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrdersBySubscriptionNumberValidateBeforeCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrdersBySubscriptionNumberAsync(String subscriptionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrdersResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrdersBySubscriptionNumberValidateBeforeCall(subscriptionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrdersBySubscriptionNumberApi getOrdersBySubscriptionNumberApi(String subscriptionNumber) {
        return new GetOrdersBySubscriptionNumberApi(subscriptionNumber);
    }

    private Call getOrdersBySubscriptionOwnerCall(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/subscriptionOwner/{accountNumber}".replace("{accountNumber}", this.localVarApiClient.escapeString(accountNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateFilterOption != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dateFilterOption", dateFilterOption));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrdersBySubscriptionOwnerValidateBeforeCall(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountNumber == null) {
            throw new ApiException("Missing the required parameter 'accountNumber' when calling getOrdersBySubscriptionOwner(Async)");
        }
        return this.getOrdersBySubscriptionOwnerCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrdersResponse getOrdersBySubscriptionOwner(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrdersResponse> localVarResp = this.getOrdersBySubscriptionOwnerWithHttpInfo(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrdersResponse> getOrdersBySubscriptionOwnerWithHttpInfo(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrdersBySubscriptionOwnerValidateBeforeCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrdersBySubscriptionOwnerAsync(String accountNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String dateFilterOption, LocalDate startDate, LocalDate endDate, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrdersResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrdersBySubscriptionOwnerValidateBeforeCall(accountNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, dateFilterOption, startDate, endDate, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrdersBySubscriptionOwnerApi getOrdersBySubscriptionOwnerApi(String accountNumber) {
        return new GetOrdersBySubscriptionOwnerApi(accountNumber);
    }

    private Call getPendingOrdersBySubscriptionNumberCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/orders/subscription/{subscription-key}/pending".replace("{subscription-key}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPendingOrdersBySubscriptionNumberValidateBeforeCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling getPendingOrdersBySubscriptionNumber(Async)");
        }
        return this.getPendingOrdersBySubscriptionNumberCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrdersResponse getPendingOrdersBySubscriptionNumber(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrdersResponse> localVarResp = this.getPendingOrdersBySubscriptionNumberWithHttpInfo(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrdersResponse> getPendingOrdersBySubscriptionNumberWithHttpInfo(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPendingOrdersBySubscriptionNumberValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPendingOrdersBySubscriptionNumberAsync(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrdersResponse> _callback) throws ApiException {
        Call localVarCall = this.getPendingOrdersBySubscriptionNumberValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPendingOrdersBySubscriptionNumberApi getPendingOrdersBySubscriptionNumberApi(String subscriptionKey) {
        return new GetPendingOrdersBySubscriptionNumberApi(subscriptionKey);
    }

    private Call previewOrderCall(PreviewOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PreviewOrderRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewOrderValidateBeforeCall(PreviewOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewOrder(Async)");
        }
        return this.previewOrderCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PreviewOrderResponse previewOrder(PreviewOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PreviewOrderResponse> localVarResp = this.previewOrderWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PreviewOrderResponse> previewOrderWithHttpInfo(PreviewOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewOrderValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PreviewOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call previewOrderAsync(PreviewOrderRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PreviewOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.previewOrderValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PreviewOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewOrderApi previewOrderApi(PreviewOrderRequest body) {
        return new PreviewOrderApi(body);
    }

    private Call previewOrderAsynchronouslyCall(PreviewOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PreviewOrderAsyncRequest localVarPostBody = body;
        String localVarPath = "/v1/async/orders/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewOrderAsynchronouslyValidateBeforeCall(PreviewOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewOrderAsynchronously(Async)");
        }
        return this.previewOrderAsynchronouslyCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PreviewOrderAsyncResponse previewOrderAsynchronously(PreviewOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PreviewOrderAsyncResponse> localVarResp = this.previewOrderAsynchronouslyWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PreviewOrderAsyncResponse> previewOrderAsynchronouslyWithHttpInfo(PreviewOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewOrderAsynchronouslyValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PreviewOrderAsyncResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call previewOrderAsynchronouslyAsync(PreviewOrderAsyncRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PreviewOrderAsyncResponse> _callback) throws ApiException {
        Call localVarCall = this.previewOrderAsynchronouslyValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PreviewOrderAsyncResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewOrderAsynchronouslyApi previewOrderAsynchronouslyApi(PreviewOrderAsyncRequest body) {
        return new PreviewOrderAsynchronouslyApi(body);
    }

    private Call revertOrderCall(String orderNumber, RevertOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RevertOrderRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/{orderNumber}/revert".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revertOrderValidateBeforeCall(String orderNumber, RevertOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling revertOrder(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling revertOrder(Async)");
        }
        return this.revertOrderCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected RevertOrderResponse revertOrder(String orderNumber, RevertOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<RevertOrderResponse> localVarResp = this.revertOrderWithHttpInfo(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<RevertOrderResponse> revertOrderWithHttpInfo(String orderNumber, RevertOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.revertOrderValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<RevertOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call revertOrderAsync(String orderNumber, RevertOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<RevertOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.revertOrderValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RevertOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RevertOrderApi revertOrderApi(String orderNumber, RevertOrderRequest body) {
        return new RevertOrderApi(orderNumber, body);
    }

    private Call updateOrderCall(String orderNumber, UpdateOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/{orderNumber}".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderValidateBeforeCall(String orderNumber, UpdateOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling updateOrder(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOrder(Async)");
        }
        return this.updateOrderCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateOrderResponse updateOrder(String orderNumber, UpdateOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateOrderResponse> localVarResp = this.updateOrderWithHttpInfo(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateOrderResponse> updateOrderWithHttpInfo(String orderNumber, UpdateOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateOrderValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateOrderAsync(String orderNumber, UpdateOrderRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderApi updateOrderApi(String orderNumber, UpdateOrderRequest body) {
        return new UpdateOrderApi(orderNumber, body);
    }

    private Call updateOrderCustomFieldsCall(String orderNumber, UpdateOrderCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderCustomFieldsRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/{orderNumber}/customFields".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderCustomFieldsValidateBeforeCall(String orderNumber, UpdateOrderCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling updateOrderCustomFields(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOrderCustomFields(Async)");
        }
        return this.updateOrderCustomFieldsCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateOrderCustomFields(String orderNumber, UpdateOrderCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateOrderCustomFieldsWithHttpInfo(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateOrderCustomFieldsWithHttpInfo(String orderNumber, UpdateOrderCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateOrderCustomFieldsValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateOrderCustomFieldsAsync(String orderNumber, UpdateOrderCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderCustomFieldsValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderCustomFieldsApi updateOrderCustomFieldsApi(String orderNumber, UpdateOrderCustomFieldsRequest body) {
        return new UpdateOrderCustomFieldsApi(orderNumber, body);
    }

    private Call updateOrderTriggerDatesCall(String orderNumber, UpdateOrderTriggerDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderTriggerDatesRequest localVarPostBody = body;
        String localVarPath = "/v1/orders/{orderNumber}/triggerDates".replace("{orderNumber}", this.localVarApiClient.escapeString(orderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderTriggerDatesValidateBeforeCall(String orderNumber, UpdateOrderTriggerDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderNumber == null) {
            throw new ApiException("Missing the required parameter 'orderNumber' when calling updateOrderTriggerDates(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOrderTriggerDates(Async)");
        }
        return this.updateOrderTriggerDatesCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected UpdateOrderTriggerDatesResponse updateOrderTriggerDates(String orderNumber, UpdateOrderTriggerDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<UpdateOrderTriggerDatesResponse> localVarResp = this.updateOrderTriggerDatesWithHttpInfo(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<UpdateOrderTriggerDatesResponse> updateOrderTriggerDatesWithHttpInfo(String orderNumber, UpdateOrderTriggerDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateOrderTriggerDatesValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<UpdateOrderTriggerDatesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateOrderTriggerDatesAsync(String orderNumber, UpdateOrderTriggerDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<UpdateOrderTriggerDatesResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderTriggerDatesValidateBeforeCall(orderNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<UpdateOrderTriggerDatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderTriggerDatesApi updateOrderTriggerDatesApi(String orderNumber, UpdateOrderTriggerDatesRequest body) {
        return new UpdateOrderTriggerDatesApi(orderNumber, body);
    }

    private Call updateSubscriptionCustomFieldsCall(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateSubscriptionCustomFieldsRequest localVarPostBody = body;
        String localVarPath = "/v1/subscriptions/{subscriptionNumber}/customFields".replace("{subscriptionNumber}", this.localVarApiClient.escapeString(subscriptionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSubscriptionCustomFieldsValidateBeforeCall(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionNumber == null) {
            throw new ApiException("Missing the required parameter 'subscriptionNumber' when calling updateSubscriptionCustomFields(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateSubscriptionCustomFields(Async)");
        }
        return this.updateSubscriptionCustomFieldsCall(subscriptionNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateSubscriptionCustomFields(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateSubscriptionCustomFieldsWithHttpInfo(subscriptionNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateSubscriptionCustomFieldsWithHttpInfo(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateSubscriptionCustomFieldsValidateBeforeCall(subscriptionNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateSubscriptionCustomFieldsAsync(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateSubscriptionCustomFieldsValidateBeforeCall(subscriptionNumber, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateSubscriptionCustomFieldsApi updateSubscriptionCustomFieldsApi(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body) {
        return new UpdateSubscriptionCustomFieldsApi(subscriptionNumber, body);
    }

    public class UpdateSubscriptionCustomFieldsApi {
        private final String subscriptionNumber;
        private final UpdateSubscriptionCustomFieldsRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateSubscriptionCustomFieldsApi(String subscriptionNumber, UpdateSubscriptionCustomFieldsRequest body) {
            this.subscriptionNumber = subscriptionNumber;
            this.body = body;
        }

        public UpdateSubscriptionCustomFieldsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateSubscriptionCustomFieldsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.updateSubscriptionCustomFieldsCall(this.subscriptionNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = OrdersApi.this.updateSubscriptionCustomFieldsWithHttpInfo(this.subscriptionNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.updateSubscriptionCustomFieldsWithHttpInfo(this.subscriptionNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OrdersApi.this.updateSubscriptionCustomFieldsAsync(this.subscriptionNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateOrderTriggerDatesApi {
        private final String orderNumber;
        private final UpdateOrderTriggerDatesRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateOrderTriggerDatesApi(String orderNumber, UpdateOrderTriggerDatesRequest body) {
            this.orderNumber = orderNumber;
            this.body = body;
        }

        public UpdateOrderTriggerDatesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderTriggerDatesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderTriggerDatesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderTriggerDatesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderTriggerDatesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderTriggerDatesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateOrderTriggerDatesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.updateOrderTriggerDatesCall(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public UpdateOrderTriggerDatesResponse execute() throws ApiException {
            ApiResponse<UpdateOrderTriggerDatesResponse> localVarResp = OrdersApi.this.updateOrderTriggerDatesWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<UpdateOrderTriggerDatesResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.updateOrderTriggerDatesWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<UpdateOrderTriggerDatesResponse> _callback) throws ApiException {
            return OrdersApi.this.updateOrderTriggerDatesAsync(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateOrderCustomFieldsApi {
        private final String orderNumber;
        private final UpdateOrderCustomFieldsRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateOrderCustomFieldsApi(String orderNumber, UpdateOrderCustomFieldsRequest body) {
            this.orderNumber = orderNumber;
            this.body = body;
        }

        public UpdateOrderCustomFieldsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderCustomFieldsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderCustomFieldsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderCustomFieldsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderCustomFieldsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderCustomFieldsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateOrderCustomFieldsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.updateOrderCustomFieldsCall(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = OrdersApi.this.updateOrderCustomFieldsWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.updateOrderCustomFieldsWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OrdersApi.this.updateOrderCustomFieldsAsync(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateOrderApi {
        private final String orderNumber;
        private final UpdateOrderRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateOrderApi(String orderNumber, UpdateOrderRequest body) {
            this.orderNumber = orderNumber;
            this.body = body;
        }

        public UpdateOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.updateOrderCall(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateOrderResponse execute() throws ApiException {
            ApiResponse<CreateOrderResponse> localVarResp = OrdersApi.this.updateOrderWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.updateOrderWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.updateOrderAsync(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class RevertOrderApi {
        private final String orderNumber;
        private final RevertOrderRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private RevertOrderApi(String orderNumber, RevertOrderRequest body) {
            this.orderNumber = orderNumber;
            this.body = body;
        }

        public RevertOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RevertOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RevertOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RevertOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RevertOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RevertOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RevertOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.revertOrderCall(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public RevertOrderResponse execute() throws ApiException {
            ApiResponse<RevertOrderResponse> localVarResp = OrdersApi.this.revertOrderWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<RevertOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.revertOrderWithHttpInfo(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<RevertOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.revertOrderAsync(this.orderNumber, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PreviewOrderAsynchronouslyApi {
        private final PreviewOrderAsyncRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PreviewOrderAsynchronouslyApi(PreviewOrderAsyncRequest body) {
            this.body = body;
        }

        public PreviewOrderAsynchronouslyApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PreviewOrderAsynchronouslyApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PreviewOrderAsynchronouslyApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PreviewOrderAsynchronouslyApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PreviewOrderAsynchronouslyApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PreviewOrderAsynchronouslyApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PreviewOrderAsynchronouslyApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PreviewOrderAsynchronouslyApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.previewOrderAsynchronouslyCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PreviewOrderAsyncResponse execute() throws ApiException {
            ApiResponse<PreviewOrderAsyncResponse> localVarResp = OrdersApi.this.previewOrderAsynchronouslyWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PreviewOrderAsyncResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.previewOrderAsynchronouslyWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PreviewOrderAsyncResponse> _callback) throws ApiException {
            return OrdersApi.this.previewOrderAsynchronouslyAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PreviewOrderApi {
        private final PreviewOrderRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PreviewOrderApi(PreviewOrderRequest body) {
            this.body = body;
        }

        public PreviewOrderApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PreviewOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PreviewOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PreviewOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PreviewOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PreviewOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PreviewOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PreviewOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.previewOrderCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PreviewOrderResponse execute() throws ApiException {
            ApiResponse<PreviewOrderResponse> localVarResp = OrdersApi.this.previewOrderWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PreviewOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.previewOrderWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PreviewOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.previewOrderAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPendingOrdersBySubscriptionNumberApi {
        private final String subscriptionKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPendingOrdersBySubscriptionNumberApi(String subscriptionKey) {
            this.subscriptionKey = subscriptionKey;
        }

        public GetPendingOrdersBySubscriptionNumberApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPendingOrdersBySubscriptionNumberApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getPendingOrdersBySubscriptionNumberCall(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrdersResponse execute() throws ApiException {
            ApiResponse<GetOrdersResponse> localVarResp = OrdersApi.this.getPendingOrdersBySubscriptionNumberWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrdersResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getPendingOrdersBySubscriptionNumberWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrdersResponse> _callback) throws ApiException {
            return OrdersApi.this.getPendingOrdersBySubscriptionNumberAsync(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrdersBySubscriptionOwnerApi {
        private final String accountNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String dateFilterOption;
        private LocalDate startDate;
        private LocalDate endDate;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrdersBySubscriptionOwnerApi(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        public GetOrdersBySubscriptionOwnerApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi dateFilterOption(String dateFilterOption) {
            this.dateFilterOption = dateFilterOption;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrdersBySubscriptionOwnerApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionOwnerCall(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrdersResponse execute() throws ApiException {
            ApiResponse<GetOrdersResponse> localVarResp = OrdersApi.this.getOrdersBySubscriptionOwnerWithHttpInfo(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrdersResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionOwnerWithHttpInfo(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrdersResponse> _callback) throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionOwnerAsync(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrdersBySubscriptionNumberApi {
        private final String subscriptionNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String dateFilterOption;
        private LocalDate startDate;
        private LocalDate endDate;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrdersBySubscriptionNumberApi(String subscriptionNumber) {
            this.subscriptionNumber = subscriptionNumber;
        }

        public GetOrdersBySubscriptionNumberApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi dateFilterOption(String dateFilterOption) {
            this.dateFilterOption = dateFilterOption;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrdersBySubscriptionNumberApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionNumberCall(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrdersResponse execute() throws ApiException {
            ApiResponse<GetOrdersResponse> localVarResp = OrdersApi.this.getOrdersBySubscriptionNumberWithHttpInfo(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrdersResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionNumberWithHttpInfo(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrdersResponse> _callback) throws ApiException {
            return OrdersApi.this.getOrdersBySubscriptionNumberAsync(this.subscriptionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrdersByInvoiceOwnerApi {
        private final String accountNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String dateFilterOption;
        private LocalDate startDate;
        private LocalDate endDate;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrdersByInvoiceOwnerApi(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        public GetOrdersByInvoiceOwnerApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi dateFilterOption(String dateFilterOption) {
            this.dateFilterOption = dateFilterOption;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrdersByInvoiceOwnerApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getOrdersByInvoiceOwnerCall(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrdersResponse execute() throws ApiException {
            ApiResponse<GetOrdersResponse> localVarResp = OrdersApi.this.getOrdersByInvoiceOwnerWithHttpInfo(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrdersResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getOrdersByInvoiceOwnerWithHttpInfo(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrdersResponse> _callback) throws ApiException {
            return OrdersApi.this.getOrdersByInvoiceOwnerAsync(this.accountNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrdersApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String dateFilterOption;
        private LocalDate startDate;
        private LocalDate endDate;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrdersApi() {
        }

        public GetOrdersApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrdersApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrdersApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrdersApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrdersApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrdersApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetOrdersApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetOrdersApi dateFilterOption(String dateFilterOption) {
            this.dateFilterOption = dateFilterOption;
            return this;
        }

        public GetOrdersApi startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public GetOrdersApi endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        public GetOrdersApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrdersApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getOrdersCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrdersResponse execute() throws ApiException {
            ApiResponse<GetOrdersResponse> localVarResp = OrdersApi.this.getOrdersWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrdersResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getOrdersWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrdersResponse> _callback) throws ApiException {
            return OrdersApi.this.getOrdersAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.dateFilterOption, this.startDate, this.endDate, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetOrderApi {
        private final String orderNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean getAccountDetails;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOrderApi(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public GetOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOrderApi getAccountDetails(Boolean getAccountDetails) {
            this.getAccountDetails = getAccountDetails;
            return this;
        }

        public GetOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getOrderCall(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrderResponse execute() throws ApiException {
            ApiResponse<GetOrderResponse> localVarResp = OrdersApi.this.getOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.getOrderAsync(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetJobStatusAndResponseApi {
        private final String jobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetJobStatusAndResponseApi(String jobId) {
            this.jobId = jobId;
        }

        public GetJobStatusAndResponseApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetJobStatusAndResponseApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetJobStatusAndResponseApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetJobStatusAndResponseApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetJobStatusAndResponseApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetJobStatusAndResponseApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.getJobStatusAndResponseCall(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetAsyncOrderJobResponse execute() throws ApiException {
            ApiResponse<GetAsyncOrderJobResponse> localVarResp = OrdersApi.this.getJobStatusAndResponseWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetAsyncOrderJobResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.getJobStatusAndResponseWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetAsyncOrderJobResponse> _callback) throws ApiException {
            return OrdersApi.this.getJobStatusAndResponseAsync(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteOrderApi {
        private final String orderNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteOrderApi(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public DeleteOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.deleteOrderCall(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = OrdersApi.this.deleteOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.deleteOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OrdersApi.this.deleteOrderAsync(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateOrderAsynchronouslyApi {
        private final CreateOrderAsyncRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean returnIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateOrderAsynchronouslyApi(CreateOrderAsyncRequest body) {
            this.body = body;
        }

        public CreateOrderAsynchronouslyApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOrderAsynchronouslyApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateOrderAsynchronouslyApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateOrderAsynchronouslyApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateOrderAsynchronouslyApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateOrderAsynchronouslyApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateOrderAsynchronouslyApi returnIds(Boolean returnIds) {
            this.returnIds = returnIds;
            return this;
        }

        public CreateOrderAsynchronouslyApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateOrderAsynchronouslyApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.createOrderAsynchronouslyCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateOrderAsyncResponse execute() throws ApiException {
            ApiResponse<CreateOrderAsyncResponse> localVarResp = OrdersApi.this.createOrderAsynchronouslyWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateOrderAsyncResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.createOrderAsynchronouslyWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateOrderAsyncResponse> _callback) throws ApiException {
            return OrdersApi.this.createOrderAsynchronouslyAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateOrderApi {
        private final CreateOrderRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean returnIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateOrderApi(CreateOrderRequest body) {
            this.body = body;
        }

        public CreateOrderApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateOrderApi returnIds(Boolean returnIds) {
            this.returnIds = returnIds;
            return this;
        }

        public CreateOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.createOrderCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateOrderResponse execute() throws ApiException {
            ApiResponse<CreateOrderResponse> localVarResp = OrdersApi.this.createOrderWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.createOrderWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.createOrderAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        private String getTrackId(Map<String, List<String>> headers) {
            if (this.zuoraTrackId != null) {
                return this.zuoraTrackId;
            }
            if (headers.containsKey("zuora-request-id") && headers.get("zuora-request-id") != null && !headers.get("zuora-request-id").isEmpty()) {
                return headers.get("zuora-request-id").get(0);
            }
            return null;
        }

        private boolean isNumberVersion(String zuoraVersion) {
            try {
                Double.parseDouble(zuoraVersion);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public CreateOrderResponse executeWithOrderMetrics() throws ApiException {
            if (this.zuoraVersion != null && this.isNumberVersion(this.zuoraVersion) && Double.compare(Double.parseDouble(this.zuoraVersion), 223.0) < 0) {
                throw new ApiException("Zuora-Version must be equal to or greater than 223.0");
            }
            ApiResponse<CreateOrderResponse> localVarResp = OrdersApi.this.createOrderWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.returnIds, this.zuoraVersion, this.zuoraOrgIds);
            String trackId = this.getTrackId(localVarResp.getHeaders());
            CreateOrderResponse createOrderResponse = localVarResp.getData();
            try {
                GetOrderResponse getOrderResponse;
                if (createOrderResponse.getSuccess().booleanValue() && OrderStatus.COMPLETED.equals((Object)createOrderResponse.getStatus()) && createOrderResponse.getSubscriptions() != null && (getOrderResponse = OrdersApi.this.getOrderApi(createOrderResponse.getOrderNumber()).authorization(this.authorization).acceptEncoding(this.acceptEncoding).zuoraEntityIds(this.zuoraEntityIds).zuoraVersion(this.zuoraVersion).zuoraTrackId(trackId).contentEncoding(this.contentEncoding).zuoraOrgIds(this.zuoraOrgIds).execute()).getSuccess().booleanValue()) {
                    getOrderResponse.getOrder().getSubscriptions().forEach(sub -> {
                        ArrayList responseOrderActions = new ArrayList();
                        if (sub.getOrderActions() != null) {
                            sub.getOrderActions().forEach(orderAction -> {
                                if (orderAction.getOrderMetrics() != null) {
                                    CreateOrderResponseOrderAction responseOrderAction = new CreateOrderResponseOrderAction();
                                    responseOrderAction.setId(orderAction.getId());
                                    responseOrderAction.setType(orderAction.getType());
                                    ArrayList<CreateOrderResponseOrderMetric> orderMetrics = new ArrayList<CreateOrderResponseOrderMetric>();
                                    orderAction.getOrderMetrics().forEach(orderMetric -> {
                                        CreateOrderResponseOrderMetric createOrderResponseOrderMetric = new CreateOrderResponseOrderMetric();
                                        createOrderResponseOrderMetric.setChargeNumber(orderMetric.getChargeNumber());
                                        createOrderResponseOrderMetric.setQuantity(orderMetric.getQuantity());
                                        createOrderResponseOrderMetric.setMrr(orderMetric.getMrr());
                                        createOrderResponseOrderMetric.setTcv(orderMetric.getTcv());
                                        createOrderResponseOrderMetric.setTcb(orderMetric.getTcb());
                                        orderMetrics.add(createOrderResponseOrderMetric);
                                    });
                                    responseOrderAction.setOrderMetrics(orderMetrics);
                                    responseOrderActions.add(responseOrderAction);
                                }
                            });
                            createOrderResponse.getSubscriptions().forEach(subscription -> {
                                if (subscription.getSubscriptionNumber().equals(sub.getSubscriptionNumber())) {
                                    subscription.setOrderActions(responseOrderActions);
                                }
                            });
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return createOrderResponse;
        }
    }

    public class CancelOrderApi {
        private final String orderNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private CancelOrderRequest body;

        private CancelOrderApi(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public CancelOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CancelOrderApi body(CancelOrderRequest body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.cancelOrderCall(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.body, _callback);
        }

        public CancelOrderResponse execute() throws ApiException {
            ApiResponse<CancelOrderResponse> localVarResp = OrdersApi.this.cancelOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<CancelOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.cancelOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.body);
        }

        public Call executeAsync(ApiCallback<CancelOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.cancelOrderAsync(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.body, _callback);
        }
    }

    public class ActivateOrderApi {
        private final String orderNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ActivateOrderApi(String orderNumber) {
            this.orderNumber = orderNumber;
        }

        public ActivateOrderApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ActivateOrderApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ActivateOrderApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ActivateOrderApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ActivateOrderApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ActivateOrderApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ActivateOrderApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrdersApi.this.activateOrderCall(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateOrderResponse execute() throws ApiException {
            ApiResponse<CreateOrderResponse> localVarResp = OrdersApi.this.activateOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateOrderResponse> executeWithHttpInfo() throws ApiException {
            return OrdersApi.this.activateOrderWithHttpInfo(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateOrderResponse> _callback) throws ApiException {
            return OrdersApi.this.activateOrderAsync(this.orderNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

