/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.Order;
import org.openapitools.client.model.OrderCancelResponse;
import org.openapitools.client.model.OrderCancellationRequest;
import org.openapitools.client.model.OrderCreateRequest;
import org.openapitools.client.model.OrderListResponse;
import org.openapitools.client.model.OrderPreviewCreateRequest;
import org.openapitools.client.model.OrderPreviewResponse;

public class OrdersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call activateOrderCall(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/orders/{order_id}/activate".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (orderFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order.fields[]", orderFields));
        }
        if (orderActionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order_actions.fields[]", orderActionsFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (lineItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_items.fields[]", lineItemsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call activateOrderValidateBeforeCall(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling activateOrder(Async)");
        }
        return this.activateOrderCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Order> activateOrderWithHttpInfo(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.activateOrderValidateBeforeCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Order>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call activateOrderAsync(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.activateOrderValidateBeforeCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActivateOrderParams activateOrderParams(String orderId) {
        return new ActivateOrderParams(orderId);
    }

    public Order activateOrder(String orderId) throws ApiException {
        ActivateOrderParams params = new ActivateOrderParams(orderId);
        return this.executeActivateOrderAPICall(params).getData();
    }

    public Order activateOrder(String orderId, List<String> expand) throws ApiException {
        ActivateOrderParams params = new ActivateOrderParams(orderId);
        params.expand(expand);
        return this.executeActivateOrderAPICall(params).getData();
    }

    public Order activateOrder(String orderId, List<String> expand, Headers headers) throws ApiException {
        ActivateOrderParams params = new ActivateOrderParams(orderId).expand(expand).headers(headers);
        return this.executeActivateOrderAPICall(params).getData();
    }

    public Order activateOrder(ActivateOrderParams params) throws ApiException {
        return this.executeActivateOrderAPICall(params).getData();
    }

    public ApiResponse<Order> activateOrderWithHttpInfo(ActivateOrderParams params) throws ApiException {
        return this.executeActivateOrderAPICall(params);
    }

    ApiResponse<Order> executeActivateOrderAPICall(ActivateOrderParams params) throws ApiException {
        return this.activateOrderWithHttpInfo(params.orderId, params.fields, params.orderFields, params.orderActionsFields, params.subscriptionsFields, params.lineItemsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call cancelOrderCall(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrderCancellationRequest localVarPostBody = orderCancellationRequest;
        String localVarPath = "/orders/{order_id}/cancel".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (orderFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order.fields[]", orderFields));
        }
        if (orderActionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order_actions.fields[]", orderActionsFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (lineItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_items.fields[]", lineItemsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrderValidateBeforeCall(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrder(Async)");
        }
        if (orderCancellationRequest == null) {
            throw new ApiException("Missing the required parameter 'orderCancellationRequest' when calling cancelOrder(Async)");
        }
        return this.cancelOrderCall(orderId, orderCancellationRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<OrderCancelResponse> cancelOrderWithHttpInfo(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, orderCancellationRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<OrderCancelResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelOrderAsync(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<OrderCancelResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, orderCancellationRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<OrderCancelResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelOrderParams cancelOrderParams(String orderId, OrderCancellationRequest orderCancellationRequest) {
        return new CancelOrderParams(orderId, orderCancellationRequest);
    }

    public OrderCancelResponse cancelOrder(String orderId, OrderCancellationRequest orderCancellationRequest) throws ApiException {
        CancelOrderParams params = new CancelOrderParams(orderId, orderCancellationRequest);
        return this.executeCancelOrderAPICall(params).getData();
    }

    public OrderCancelResponse cancelOrder(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> expand) throws ApiException {
        CancelOrderParams params = new CancelOrderParams(orderId, orderCancellationRequest);
        params.expand(expand);
        return this.executeCancelOrderAPICall(params).getData();
    }

    public OrderCancelResponse cancelOrder(String orderId, OrderCancellationRequest orderCancellationRequest, List<String> expand, Headers headers) throws ApiException {
        CancelOrderParams params = new CancelOrderParams(orderId, orderCancellationRequest).expand(expand).headers(headers);
        return this.executeCancelOrderAPICall(params).getData();
    }

    public OrderCancelResponse cancelOrder(CancelOrderParams params) throws ApiException {
        return this.executeCancelOrderAPICall(params).getData();
    }

    public ApiResponse<OrderCancelResponse> cancelOrderWithHttpInfo(CancelOrderParams params) throws ApiException {
        return this.executeCancelOrderAPICall(params);
    }

    ApiResponse<OrderCancelResponse> executeCancelOrderAPICall(CancelOrderParams params) throws ApiException {
        return this.cancelOrderWithHttpInfo(params.orderId, params.orderCancellationRequest, params.fields, params.orderFields, params.orderActionsFields, params.subscriptionsFields, params.lineItemsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call createOrderCall(OrderCreateRequest orderCreateRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrderCreateRequest localVarPostBody = orderCreateRequest;
        String localVarPath = "/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (orderFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order.fields[]", orderFields));
        }
        if (orderActionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order_actions.fields[]", orderActionsFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (lineItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_items.fields[]", lineItemsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderValidateBeforeCall(OrderCreateRequest orderCreateRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'orderCreateRequest' when calling createOrder(Async)");
        }
        return this.createOrderCall(orderCreateRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Order> createOrderWithHttpInfo(OrderCreateRequest orderCreateRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(orderCreateRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Order>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createOrderAsync(OrderCreateRequest orderCreateRequest, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(orderCreateRequest, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOrderParams createOrderParams(OrderCreateRequest orderCreateRequest) {
        return new CreateOrderParams(orderCreateRequest);
    }

    public Order createOrder(OrderCreateRequest orderCreateRequest) throws ApiException {
        CreateOrderParams params = new CreateOrderParams(orderCreateRequest);
        return this.executeCreateOrderAPICall(params).getData();
    }

    public Order createOrder(OrderCreateRequest orderCreateRequest, List<String> expand) throws ApiException {
        CreateOrderParams params = new CreateOrderParams(orderCreateRequest);
        params.expand(expand);
        return this.executeCreateOrderAPICall(params).getData();
    }

    public Order createOrder(OrderCreateRequest orderCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateOrderParams params = new CreateOrderParams(orderCreateRequest).expand(expand).headers(headers);
        return this.executeCreateOrderAPICall(params).getData();
    }

    public Order create(CreateOrderParams params) throws ApiException {
        return this.executeCreateOrderAPICall(params).getData();
    }

    public ApiResponse<Order> createWithHttpInfo(CreateOrderParams params) throws ApiException {
        return this.executeCreateOrderAPICall(params);
    }

    ApiResponse<Order> executeCreateOrderAPICall(CreateOrderParams params) throws ApiException {
        return this.createOrderWithHttpInfo(params.orderCreateRequest, params.fields, params.orderFields, params.orderActionsFields, params.subscriptionsFields, params.lineItemsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call createOrderPreviewCall(OrderPreviewCreateRequest orderPreviewCreateRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OrderPreviewCreateRequest localVarPostBody = orderPreviewCreateRequest;
        String localVarPath = "/orders/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderPreviewValidateBeforeCall(OrderPreviewCreateRequest orderPreviewCreateRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderPreviewCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'orderPreviewCreateRequest' when calling createOrderPreview(Async)");
        }
        return this.createOrderPreviewCall(orderPreviewCreateRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<OrderPreviewResponse> createOrderPreviewWithHttpInfo(OrderPreviewCreateRequest orderPreviewCreateRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createOrderPreviewValidateBeforeCall(orderPreviewCreateRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<OrderPreviewResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createOrderPreviewAsync(OrderPreviewCreateRequest orderPreviewCreateRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<OrderPreviewResponse> _callback) throws ApiException {
        Call localVarCall = this.createOrderPreviewValidateBeforeCall(orderPreviewCreateRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<OrderPreviewResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOrderPreviewParams createOrderPreviewParams(OrderPreviewCreateRequest orderPreviewCreateRequest) {
        return new CreateOrderPreviewParams(orderPreviewCreateRequest);
    }

    public OrderPreviewResponse createOrderPreview(OrderPreviewCreateRequest orderPreviewCreateRequest) throws ApiException {
        CreateOrderPreviewParams params = new CreateOrderPreviewParams(orderPreviewCreateRequest);
        return this.executeCreateOrderPreviewAPICall(params).getData();
    }

    public OrderPreviewResponse createOrderPreview(OrderPreviewCreateRequest orderPreviewCreateRequest, Headers headers) throws ApiException {
        CreateOrderPreviewParams params = new CreateOrderPreviewParams(orderPreviewCreateRequest).headers(headers);
        return this.executeCreateOrderPreviewAPICall(params).getData();
    }

    public OrderPreviewResponse preview(CreateOrderPreviewParams params) throws ApiException {
        return this.executeCreateOrderPreviewAPICall(params).getData();
    }

    public ApiResponse<OrderPreviewResponse> previewWithHttpInfo(CreateOrderPreviewParams params) throws ApiException {
        return this.executeCreateOrderPreviewAPICall(params);
    }

    ApiResponse<OrderPreviewResponse> executeCreateOrderPreviewAPICall(CreateOrderPreviewParams params) throws ApiException {
        return this.createOrderPreviewWithHttpInfo(params.orderPreviewCreateRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call deleteOrderCall(String orderId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/orders/{order_id}".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOrderValidateBeforeCall(String orderId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrder(Async)");
        }
        return this.deleteOrderCall(orderId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteOrderWithHttpInfo(String orderId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteOrderValidateBeforeCall(orderId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteOrderAsync(String orderId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOrderValidateBeforeCall(orderId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteOrderParams deleteOrderParams(String orderId) {
        return new DeleteOrderParams(orderId);
    }

    public void deleteOrder(String orderId) throws ApiException {
        DeleteOrderParams params = new DeleteOrderParams(orderId);
        this.executeDeleteOrderAPICall(params);
    }

    public void deleteOrder(String orderId, Headers headers) throws ApiException {
        DeleteOrderParams params = new DeleteOrderParams(orderId).headers(headers);
        this.executeDeleteOrderAPICall(params);
    }

    public void deleteOrder(DeleteOrderParams params) throws ApiException {
        this.executeDeleteOrderAPICall(params).getData();
    }

    public ApiResponse<Void> deleteOrderWithHttpInfo(DeleteOrderParams params) throws ApiException {
        return this.executeDeleteOrderAPICall(params);
    }

    ApiResponse<Void> executeDeleteOrderAPICall(DeleteOrderParams params) throws ApiException {
        return this.deleteOrderWithHttpInfo(params.orderId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getOrderCall(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/orders/{order_id}".replace("{order_id}", this.localVarApiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (orderFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order.fields[]", orderFields));
        }
        if (orderActionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order_actions.fields[]", orderActionsFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (lineItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_items.fields[]", lineItemsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderValidateBeforeCall(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        return this.getOrderCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Order> getOrderWithHttpInfo(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Order>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrderAsync(String orderId, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrderParams getOrderParams(String orderId) {
        return new GetOrderParams(orderId);
    }

    public Order getOrder(String orderId) throws ApiException {
        GetOrderParams params = new GetOrderParams(orderId);
        return this.executeGetOrderAPICall(params).getData();
    }

    public Order getOrder(String orderId, List<String> expand) throws ApiException {
        GetOrderParams params = new GetOrderParams(orderId);
        params.expand(expand);
        return this.executeGetOrderAPICall(params).getData();
    }

    public Order getOrder(String orderId, List<String> expand, Headers headers) throws ApiException {
        GetOrderParams params = new GetOrderParams(orderId).expand(expand).headers(headers);
        return this.executeGetOrderAPICall(params).getData();
    }

    public Order get(GetOrderParams params) throws ApiException {
        return this.executeGetOrderAPICall(params).getData();
    }

    public ApiResponse<Order> getWithHttpInfo(GetOrderParams params) throws ApiException {
        return this.executeGetOrderAPICall(params);
    }

    ApiResponse<Order> executeGetOrderAPICall(GetOrderParams params) throws ApiException {
        return this.getOrderWithHttpInfo(params.orderId, params.fields, params.orderFields, params.orderActionsFields, params.subscriptionsFields, params.lineItemsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getOrdersCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (orderFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order.fields[]", orderFields));
        }
        if (orderActionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "order_actions.fields[]", orderActionsFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (lineItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_items.fields[]", lineItemsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrdersValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getOrdersCall(cursor, expand, filter, sort, pageSize, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<OrderListResponse> getOrdersWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrdersValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<OrderListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrdersAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> orderFields, List<String> orderActionsFields, List<String> subscriptionsFields, List<String> lineItemsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceItemsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<OrderListResponse> _callback) throws ApiException {
        Call localVarCall = this.getOrdersValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, orderFields, orderActionsFields, subscriptionsFields, lineItemsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceItemsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<OrderListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrdersParams getOrdersParams() {
        return new GetOrdersParams();
    }

    public OrderListResponse getOrders() throws ApiException {
        GetOrdersParams params = new GetOrdersParams();
        return this.executeGetOrdersAPICall(params).getData();
    }

    public OrderListResponse getOrders(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetOrdersParams params = new GetOrdersParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetOrdersAPICall(params).getData();
    }

    public OrderListResponse getOrders(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetOrdersParams params = new GetOrdersParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetOrdersAPICall(params).getData();
    }

    public OrderListResponse list(GetOrdersParams params) throws ApiException {
        return this.executeGetOrdersAPICall(params).getData();
    }

    public ApiResponse<OrderListResponse> listWithHttpInfo(GetOrdersParams params) throws ApiException {
        return this.executeGetOrdersAPICall(params);
    }

    ApiResponse<OrderListResponse> executeGetOrdersAPICall(GetOrdersParams params) throws ApiException {
        return this.getOrdersWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.orderFields, params.orderActionsFields, params.subscriptionsFields, params.lineItemsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceItemsFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class GetOrdersParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> orderFields;
        private List<String> orderActionsFields;
        private List<String> subscriptionsFields;
        private List<String> lineItemsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceItemsFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetOrdersParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetOrdersParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetOrdersParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetOrdersParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetOrdersParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetOrdersParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetOrdersParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetOrdersParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetOrdersParams orderFields(List<String> orderFields) {
            this.orderFields = orderFields;
            return this;
        }

        public GetOrdersParams orderActionsFields(List<String> orderActionsFields) {
            this.orderActionsFields = orderActionsFields;
            return this;
        }

        public GetOrdersParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public GetOrdersParams lineItemsFields(List<String> lineItemsFields) {
            this.lineItemsFields = lineItemsFields;
            return this;
        }

        public GetOrdersParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetOrdersParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetOrdersParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }
    }

    public static class GetOrderParams {
        private final String orderId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> orderFields;
        private List<String> orderActionsFields;
        private List<String> subscriptionsFields;
        private List<String> lineItemsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetOrderParams(String orderId) {
            this.orderId = orderId;
        }

        public GetOrderParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetOrderParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetOrderParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetOrderParams orderFields(List<String> orderFields) {
            this.orderFields = orderFields;
            return this;
        }

        public GetOrderParams orderActionsFields(List<String> orderActionsFields) {
            this.orderActionsFields = orderActionsFields;
            return this;
        }

        public GetOrderParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public GetOrderParams lineItemsFields(List<String> lineItemsFields) {
            this.lineItemsFields = lineItemsFields;
            return this;
        }

        public GetOrderParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetOrderParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetOrderParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public GetOrderParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetOrderParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetOrderParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteOrderParams {
        private final String orderId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public DeleteOrderParams(String orderId) {
            this.orderId = orderId;
        }

        public DeleteOrderParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateOrderPreviewParams {
        private final OrderPreviewCreateRequest orderPreviewCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreateOrderPreviewParams(OrderPreviewCreateRequest orderPreviewCreateRequest) {
            this.orderPreviewCreateRequest = orderPreviewCreateRequest;
        }

        public CreateOrderPreviewParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateOrderParams {
        private final OrderCreateRequest orderCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> orderFields;
        private List<String> orderActionsFields;
        private List<String> subscriptionsFields;
        private List<String> lineItemsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreateOrderParams(OrderCreateRequest orderCreateRequest) {
            this.orderCreateRequest = orderCreateRequest;
        }

        public CreateOrderParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateOrderParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateOrderParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateOrderParams orderFields(List<String> orderFields) {
            this.orderFields = orderFields;
            return this;
        }

        public CreateOrderParams orderActionsFields(List<String> orderActionsFields) {
            this.orderActionsFields = orderActionsFields;
            return this;
        }

        public CreateOrderParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public CreateOrderParams lineItemsFields(List<String> lineItemsFields) {
            this.lineItemsFields = lineItemsFields;
            return this;
        }

        public CreateOrderParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public CreateOrderParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public CreateOrderParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public CreateOrderParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateOrderParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateOrderParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelOrderParams {
        private final String orderId;
        private final OrderCancellationRequest orderCancellationRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> orderFields;
        private List<String> orderActionsFields;
        private List<String> subscriptionsFields;
        private List<String> lineItemsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CancelOrderParams(String orderId, OrderCancellationRequest orderCancellationRequest) {
            this.orderId = orderId;
            this.orderCancellationRequest = orderCancellationRequest;
        }

        public CancelOrderParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelOrderParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelOrderParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelOrderParams orderFields(List<String> orderFields) {
            this.orderFields = orderFields;
            return this;
        }

        public CancelOrderParams orderActionsFields(List<String> orderActionsFields) {
            this.orderActionsFields = orderActionsFields;
            return this;
        }

        public CancelOrderParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public CancelOrderParams lineItemsFields(List<String> lineItemsFields) {
            this.lineItemsFields = lineItemsFields;
            return this;
        }

        public CancelOrderParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public CancelOrderParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public CancelOrderParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public CancelOrderParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelOrderParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelOrderParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ActivateOrderParams {
        private final String orderId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> orderFields;
        private List<String> orderActionsFields;
        private List<String> subscriptionsFields;
        private List<String> lineItemsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public ActivateOrderParams(String orderId) {
            this.orderId = orderId;
        }

        public ActivateOrderParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ActivateOrderParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ActivateOrderParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ActivateOrderParams orderFields(List<String> orderFields) {
            this.orderFields = orderFields;
            return this;
        }

        public ActivateOrderParams orderActionsFields(List<String> orderActionsFields) {
            this.orderActionsFields = orderActionsFields;
            return this;
        }

        public ActivateOrderParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public ActivateOrderParams lineItemsFields(List<String> lineItemsFields) {
            this.lineItemsFields = lineItemsFields;
            return this;
        }

        public ActivateOrderParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public ActivateOrderParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public ActivateOrderParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public ActivateOrderParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ActivateOrderParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ActivateOrderParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

