/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.StartOn;
import org.openapitools.client.model.SubscriptionPlanCreateRequest;

public class SubscriptionReplacePlanPatchRequest {
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN_ID = "subscription_plan_id";
    @SerializedName(value="subscription_plan_id")
    private String subscriptionPlanId;
    public static final String SERIALIZED_NAME_PREVIOUS_PLAN_ID = "previous_plan_id";
    @SerializedName(value="previous_plan_id")
    private String previousPlanId;
    public static final String SERIALIZED_NAME_REPLACE_AT = "replace_at";
    @SerializedName(value="replace_at")
    private ReplaceAtEnum replaceAt;
    public static final String SERIALIZED_NAME_REPLACEMENT_TYPE = "replacement_type";
    @SerializedName(value="replacement_type")
    private ReplacementTypeEnum replacementType;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN = "subscription_plan";
    @SerializedName(value="subscription_plan")
    private SubscriptionPlanCreateRequest subscriptionPlan;
    public static final String SERIALIZED_NAME_START_ON = "start_on";
    @SerializedName(value="start_on")
    private StartOn startOn;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public SubscriptionReplacePlanPatchRequest subscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription plan. Only provide one of `previous_plan_id` or `subscription_plan_id` in your request, not both.")
    public String getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    public void setSubscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
    }

    public SubscriptionReplacePlanPatchRequest previousPlanId(String previousPlanId) {
        this.previousPlanId = previousPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the plan to be removed. Only provide one of `previous_plan_id` or `subscription_plan_id` in your request, not both.")
    public String getPreviousPlanId() {
        return this.previousPlanId;
    }

    public void setPreviousPlanId(String previousPlanId) {
        this.previousPlanId = previousPlanId;
    }

    public SubscriptionReplacePlanPatchRequest replaceAt(ReplaceAtEnum replaceAt) {
        this.replaceAt = replaceAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default value for the\u00a0`replace_at`\u00a0field is as follows:       <ul>         <li>If the subscription plan change (from old to new) is an upgrade, the `replace_at` is\u00a0`now`\u00a0by default. </li>         <li>If the subscription change (from old to new) is a downgrade, the `replace_at` is\u00a0`end_of_billing_period`\u00a0by default. </li>       </ul>       Otherwise, the `replace_at` is\u00a0`specific_date`\u00a0by default.            **Notes**:      <br />       When setting this field to\u00a0`end_of_billing_period`, you cannot set the\u00a0billing start dates\u00a0for the subscription as the system will automatically set the start dates to the end of billing period, and you cannot set the following billing trigger date settings to\u00a0`Yes`:      <ul>         <li> <a href=\"https://knowledgecenter.zuora.com/Zuora_Billing/Configure_billing_settings/Subscription_and_order_settings/A_Define_Default_Subscription_and_Order_Settings#Require_Customer_Acceptance_of_Orders.3F\" target=\"_blank\">Require Customer Acceptance of Orders</a> </li>         <li> <a href=\"https://knowledgecenter.zuora.com/Zuora_Billing/Billing_and_Invoicing/Billing_Settings/Define_Default_Subscription_and_Order_Settings#Require_Service_Activation_of_Orders.3F\" target=\"_blank\">Require Service Activation of Orders</a> </li>       </ul>       When setting this field to\u00a0`specific_date`, you must also specify a date for the `contract_effective` date in the\u00a0`start_on`\u00a0field.     ")
    public ReplaceAtEnum getReplaceAt() {
        return this.replaceAt;
    }

    public void setReplaceAt(ReplaceAtEnum replaceAt) {
        this.replaceAt = replaceAt;
    }

    public SubscriptionReplacePlanPatchRequest replacementType(ReplacementTypeEnum replacementType) {
        this.replacementType = replacementType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReplacementTypeEnum getReplacementType() {
        return this.replacementType;
    }

    public void setReplacementType(ReplacementTypeEnum replacementType) {
        this.replacementType = replacementType;
    }

    public SubscriptionReplacePlanPatchRequest subscriptionPlan(SubscriptionPlanCreateRequest subscriptionPlan) {
        this.subscriptionPlan = subscriptionPlan;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public SubscriptionPlanCreateRequest getSubscriptionPlan() {
        return this.subscriptionPlan;
    }

    public void setSubscriptionPlan(SubscriptionPlanCreateRequest subscriptionPlan) {
        this.subscriptionPlan = subscriptionPlan;
    }

    public SubscriptionReplacePlanPatchRequest startOn(StartOn startOn) {
        this.startOn = startOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StartOn getStartOn() {
        return this.startOn;
    }

    public void setStartOn(StartOn startOn) {
        this.startOn = startOn;
    }

    public SubscriptionReplacePlanPatchRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public SubscriptionReplacePlanPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionReplacePlanPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionReplacePlanPatchRequest subscriptionReplacePlanPatchRequest = (SubscriptionReplacePlanPatchRequest)o;
        return Objects.equals(this.subscriptionPlanId, subscriptionReplacePlanPatchRequest.subscriptionPlanId) && Objects.equals(this.previousPlanId, subscriptionReplacePlanPatchRequest.previousPlanId) && Objects.equals((Object)this.replaceAt, (Object)subscriptionReplacePlanPatchRequest.replaceAt) && Objects.equals((Object)this.replacementType, (Object)subscriptionReplacePlanPatchRequest.replacementType) && Objects.equals(this.subscriptionPlan, subscriptionReplacePlanPatchRequest.subscriptionPlan) && Objects.equals(this.startOn, subscriptionReplacePlanPatchRequest.startOn) && Objects.equals(this.changeReason, subscriptionReplacePlanPatchRequest.changeReason) && Objects.equals(this.customFields, subscriptionReplacePlanPatchRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subscriptionPlanId, this.previousPlanId, this.replaceAt, this.replacementType, this.subscriptionPlan, this.startOn, this.changeReason, this.customFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionReplacePlanPatchRequest {\n");
        sb.append("    subscriptionPlanId: ").append(this.toIndentedString(this.subscriptionPlanId)).append("\n");
        sb.append("    previousPlanId: ").append(this.toIndentedString(this.previousPlanId)).append("\n");
        sb.append("    replaceAt: ").append(this.toIndentedString((Object)this.replaceAt)).append("\n");
        sb.append("    replacementType: ").append(this.toIndentedString((Object)this.replacementType)).append("\n");
        sb.append("    subscriptionPlan: ").append(this.toIndentedString(this.subscriptionPlan)).append("\n");
        sb.append("    startOn: ").append(this.toIndentedString(this.startOn)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplacementTypeEnum {
        UPGRADE("upgrade"),
        DOWNGRADE("downgrade"),
        CROSSGRADE("crossgrade"),
        OTHER("other"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ReplacementTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplacementTypeEnum fromValue(String value) {
            for (ReplacementTypeEnum b : ReplacementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplacementTypeEnum> {
            public void write(JsonWriter jsonWriter, ReplacementTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplacementTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplacementTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplaceAtEnum {
        NOW("now"),
        END_OF_BILLING_PERIOD("end_of_billing_period"),
        SPECIFIC_DATE("specific_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ReplaceAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplaceAtEnum fromValue(String value) {
            for (ReplaceAtEnum b : ReplaceAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplaceAtEnum> {
            public void write(JsonWriter jsonWriter, ReplaceAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplaceAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplaceAtEnum.fromValue(value);
            }
        }
    }
}

