/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.PaymentRun;
import org.openapitools.client.model.PaymentRunCreateRequest;
import org.openapitools.client.model.PaymentRunListResponse;
import org.openapitools.client.model.PaymentRunPatchRequest;

public class PaymentRunsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentRunsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentRunsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createPaymentRunsCall(PaymentRunCreateRequest paymentRunCreateRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentRunCreateRequest localVarPostBody = paymentRunCreateRequest;
        String localVarPath = "/payment_runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_run.fields[]", paymentRunFields));
        }
        if (summaryFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "summary.fields[]", summaryFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentRunsValidateBeforeCall(PaymentRunCreateRequest paymentRunCreateRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentRunCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentRunCreateRequest' when calling createPaymentRuns(Async)");
        }
        return this.createPaymentRunsCall(paymentRunCreateRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentRun> createPaymentRunsWithHttpInfo(PaymentRunCreateRequest paymentRunCreateRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentRunsValidateBeforeCall(paymentRunCreateRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentRunsAsync(PaymentRunCreateRequest paymentRunCreateRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentRun> _callback) throws ApiException {
        Call localVarCall = this.createPaymentRunsValidateBeforeCall(paymentRunCreateRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentRunsParams createPaymentRunsParams(PaymentRunCreateRequest paymentRunCreateRequest) {
        return new CreatePaymentRunsParams(paymentRunCreateRequest);
    }

    public PaymentRun createPaymentRuns(PaymentRunCreateRequest paymentRunCreateRequest) throws ApiException {
        CreatePaymentRunsParams params = new CreatePaymentRunsParams(paymentRunCreateRequest);
        return this.executeCreatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun createPaymentRuns(PaymentRunCreateRequest paymentRunCreateRequest, List<String> expand) throws ApiException {
        CreatePaymentRunsParams params = new CreatePaymentRunsParams(paymentRunCreateRequest);
        params.expand(expand);
        return this.executeCreatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun createPaymentRuns(PaymentRunCreateRequest paymentRunCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreatePaymentRunsParams params = new CreatePaymentRunsParams(paymentRunCreateRequest).expand(expand).headers(headers);
        return this.executeCreatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun create(CreatePaymentRunsParams params) throws ApiException {
        return this.executeCreatePaymentRunsAPICall(params).getData();
    }

    public ApiResponse<PaymentRun> createWithHttpInfo(CreatePaymentRunsParams params) throws ApiException {
        return this.executeCreatePaymentRunsAPICall(params);
    }

    ApiResponse<PaymentRun> executeCreatePaymentRunsAPICall(CreatePaymentRunsParams params) throws ApiException {
        return this.createPaymentRunsWithHttpInfo(params.paymentRunCreateRequest, params.fields, params.paymentRunFields, params.summaryFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call deletePaymentRunsCall(String paymentRunId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_runs/{payment_run_id}".replace("{payment_run_id}", this.localVarApiClient.escapeString(paymentRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePaymentRunsValidateBeforeCall(String paymentRunId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentRunId == null) {
            throw new ApiException("Missing the required parameter 'paymentRunId' when calling deletePaymentRuns(Async)");
        }
        return this.deletePaymentRunsCall(paymentRunId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deletePaymentRunsWithHttpInfo(String paymentRunId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deletePaymentRunsValidateBeforeCall(paymentRunId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deletePaymentRunsAsync(String paymentRunId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deletePaymentRunsValidateBeforeCall(paymentRunId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeletePaymentRunsParams deletePaymentRunsParams(String paymentRunId) {
        return new DeletePaymentRunsParams(paymentRunId);
    }

    public void deletePaymentRuns(String paymentRunId) throws ApiException {
        DeletePaymentRunsParams params = new DeletePaymentRunsParams(paymentRunId);
        this.executeDeletePaymentRunsAPICall(params);
    }

    public void deletePaymentRuns(String paymentRunId, Headers headers) throws ApiException {
        DeletePaymentRunsParams params = new DeletePaymentRunsParams(paymentRunId).headers(headers);
        this.executeDeletePaymentRunsAPICall(params);
    }

    public void delete(DeletePaymentRunsParams params) throws ApiException {
        this.executeDeletePaymentRunsAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeletePaymentRunsParams params) throws ApiException {
        return this.executeDeletePaymentRunsAPICall(params);
    }

    ApiResponse<Void> executeDeletePaymentRunsAPICall(DeletePaymentRunsParams params) throws ApiException {
        return this.deletePaymentRunsWithHttpInfo(params.paymentRunId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getPaymentRunCall(String paymentRunId, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_runs/{payment_run_id}".replace("{payment_run_id}", this.localVarApiClient.escapeString(paymentRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_run.fields[]", paymentRunFields));
        }
        if (summaryFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "summary.fields[]", summaryFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunValidateBeforeCall(String paymentRunId, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentRunId == null) {
            throw new ApiException("Missing the required parameter 'paymentRunId' when calling getPaymentRun(Async)");
        }
        return this.getPaymentRunCall(paymentRunId, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentRun> getPaymentRunWithHttpInfo(String paymentRunId, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentRunValidateBeforeCall(paymentRunId, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentRunAsync(String paymentRunId, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentRun> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunValidateBeforeCall(paymentRunId, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunParams getPaymentRunParams(String paymentRunId) {
        return new GetPaymentRunParams(paymentRunId);
    }

    public PaymentRun getPaymentRun(String paymentRunId) throws ApiException {
        GetPaymentRunParams params = new GetPaymentRunParams(paymentRunId);
        return this.executeGetPaymentRunAPICall(params).getData();
    }

    public PaymentRun getPaymentRun(String paymentRunId, List<String> expand) throws ApiException {
        GetPaymentRunParams params = new GetPaymentRunParams(paymentRunId);
        params.expand(expand);
        return this.executeGetPaymentRunAPICall(params).getData();
    }

    public PaymentRun getPaymentRun(String paymentRunId, List<String> expand, Headers headers) throws ApiException {
        GetPaymentRunParams params = new GetPaymentRunParams(paymentRunId).expand(expand).headers(headers);
        return this.executeGetPaymentRunAPICall(params).getData();
    }

    public PaymentRun get(GetPaymentRunParams params) throws ApiException {
        return this.executeGetPaymentRunAPICall(params).getData();
    }

    public ApiResponse<PaymentRun> getWithHttpInfo(GetPaymentRunParams params) throws ApiException {
        return this.executeGetPaymentRunAPICall(params);
    }

    ApiResponse<PaymentRun> executeGetPaymentRunAPICall(GetPaymentRunParams params) throws ApiException {
        return this.getPaymentRunWithHttpInfo(params.paymentRunId, params.fields, params.paymentRunFields, params.summaryFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getPaymentRunsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_run.fields[]", paymentRunFields));
        }
        if (summaryFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "summary.fields[]", summaryFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getPaymentRunsCall(cursor, expand, filter, sort, pageSize, fields, paymentRunFields, summaryFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentRunListResponse> getPaymentRunsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentRunsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentRunFields, summaryFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentRunListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentRunsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentRunListResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentRunFields, summaryFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentRunListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunsParams getPaymentRunsParams() {
        return new GetPaymentRunsParams();
    }

    public PaymentRunListResponse getPaymentRuns() throws ApiException {
        GetPaymentRunsParams params = new GetPaymentRunsParams();
        return this.executeGetPaymentRunsAPICall(params).getData();
    }

    public PaymentRunListResponse getPaymentRuns(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetPaymentRunsParams params = new GetPaymentRunsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetPaymentRunsAPICall(params).getData();
    }

    public PaymentRunListResponse getPaymentRuns(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetPaymentRunsParams params = new GetPaymentRunsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetPaymentRunsAPICall(params).getData();
    }

    public PaymentRunListResponse list(GetPaymentRunsParams params) throws ApiException {
        return this.executeGetPaymentRunsAPICall(params).getData();
    }

    public ApiResponse<PaymentRunListResponse> listWithHttpInfo(GetPaymentRunsParams params) throws ApiException {
        return this.executeGetPaymentRunsAPICall(params);
    }

    ApiResponse<PaymentRunListResponse> executeGetPaymentRunsAPICall(GetPaymentRunsParams params) throws ApiException {
        return this.getPaymentRunsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.paymentRunFields, params.summaryFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call updatePaymentRunsCall(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentRunPatchRequest localVarPostBody = paymentRunPatchRequest;
        String localVarPath = "/payment_runs/{payment_run_id}".replace("{payment_run_id}", this.localVarApiClient.escapeString(paymentRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_run.fields[]", paymentRunFields));
        }
        if (summaryFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "summary.fields[]", summaryFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentRunsValidateBeforeCall(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentRunId == null) {
            throw new ApiException("Missing the required parameter 'paymentRunId' when calling updatePaymentRuns(Async)");
        }
        if (paymentRunPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentRunPatchRequest' when calling updatePaymentRuns(Async)");
        }
        return this.updatePaymentRunsCall(paymentRunId, paymentRunPatchRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentRun> updatePaymentRunsWithHttpInfo(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentRunsValidateBeforeCall(paymentRunId, paymentRunPatchRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentRunsAsync(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> fields, List<String> paymentRunFields, List<String> summaryFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentRun> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentRunsValidateBeforeCall(paymentRunId, paymentRunPatchRequest, fields, paymentRunFields, summaryFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentRunsParams updatePaymentRunsParams(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest) {
        return new UpdatePaymentRunsParams(paymentRunId, paymentRunPatchRequest);
    }

    public PaymentRun updatePaymentRuns(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest) throws ApiException {
        UpdatePaymentRunsParams params = new UpdatePaymentRunsParams(paymentRunId, paymentRunPatchRequest);
        return this.executeUpdatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun updatePaymentRuns(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> expand) throws ApiException {
        UpdatePaymentRunsParams params = new UpdatePaymentRunsParams(paymentRunId, paymentRunPatchRequest);
        params.expand(expand);
        return this.executeUpdatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun updatePaymentRuns(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdatePaymentRunsParams params = new UpdatePaymentRunsParams(paymentRunId, paymentRunPatchRequest).expand(expand).headers(headers);
        return this.executeUpdatePaymentRunsAPICall(params).getData();
    }

    public PaymentRun update(UpdatePaymentRunsParams params) throws ApiException {
        return this.executeUpdatePaymentRunsAPICall(params).getData();
    }

    public ApiResponse<PaymentRun> updateWithHttpInfo(UpdatePaymentRunsParams params) throws ApiException {
        return this.executeUpdatePaymentRunsAPICall(params);
    }

    ApiResponse<PaymentRun> executeUpdatePaymentRunsAPICall(UpdatePaymentRunsParams params) throws ApiException {
        return this.updatePaymentRunsWithHttpInfo(params.paymentRunId, params.paymentRunPatchRequest, params.fields, params.paymentRunFields, params.summaryFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class UpdatePaymentRunsParams {
        private final String paymentRunId;
        private final PaymentRunPatchRequest paymentRunPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentRunFields;
        private List<String> summaryFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public UpdatePaymentRunsParams(String paymentRunId, PaymentRunPatchRequest paymentRunPatchRequest) {
            this.paymentRunId = paymentRunId;
            this.paymentRunPatchRequest = paymentRunPatchRequest;
        }

        public UpdatePaymentRunsParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdatePaymentRunsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdatePaymentRunsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdatePaymentRunsParams paymentRunFields(List<String> paymentRunFields) {
            this.paymentRunFields = paymentRunFields;
            return this;
        }

        public UpdatePaymentRunsParams summaryFields(List<String> summaryFields) {
            this.summaryFields = summaryFields;
            return this;
        }

        public UpdatePaymentRunsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdatePaymentRunsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdatePaymentRunsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetPaymentRunsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> paymentRunFields;
        private List<String> summaryFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetPaymentRunsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentRunsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentRunsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetPaymentRunsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentRunsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentRunsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetPaymentRunsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentRunsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentRunsParams paymentRunFields(List<String> paymentRunFields) {
            this.paymentRunFields = paymentRunFields;
            return this;
        }

        public GetPaymentRunsParams summaryFields(List<String> summaryFields) {
            this.summaryFields = summaryFields;
            return this;
        }
    }

    public static class GetPaymentRunParams {
        private final String paymentRunId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentRunFields;
        private List<String> summaryFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetPaymentRunParams(String paymentRunId) {
            this.paymentRunId = paymentRunId;
        }

        public GetPaymentRunParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentRunParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentRunParams paymentRunFields(List<String> paymentRunFields) {
            this.paymentRunFields = paymentRunFields;
            return this;
        }

        public GetPaymentRunParams summaryFields(List<String> summaryFields) {
            this.summaryFields = summaryFields;
            return this;
        }

        public GetPaymentRunParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentRunParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentRunParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeletePaymentRunsParams {
        private final String paymentRunId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public DeletePaymentRunsParams(String paymentRunId) {
            this.paymentRunId = paymentRunId;
        }

        public DeletePaymentRunsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreatePaymentRunsParams {
        private final PaymentRunCreateRequest paymentRunCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentRunFields;
        private List<String> summaryFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreatePaymentRunsParams(PaymentRunCreateRequest paymentRunCreateRequest) {
            this.paymentRunCreateRequest = paymentRunCreateRequest;
        }

        public CreatePaymentRunsParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreatePaymentRunsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreatePaymentRunsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreatePaymentRunsParams paymentRunFields(List<String> paymentRunFields) {
            this.paymentRunFields = paymentRunFields;
            return this;
        }

        public CreatePaymentRunsParams summaryFields(List<String> summaryFields) {
            this.summaryFields = summaryFields;
            return this;
        }

        public CreatePaymentRunsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreatePaymentRunsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreatePaymentRunsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

