/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;

public class PayInvoiceRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_ACCOUNT = "bank_account_account";
    @SerializedName(value="bank_account_account")
    private String bankAccountAccount;
    public static final String SERIALIZED_NAME_PAYMENT_DATE = "payment_date";
    @SerializedName(value="payment_date")
    private LocalDate paymentDate;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_GATEWAY_ORDER_ID = "gateway_order_id";
    @SerializedName(value="gateway_order_id")
    private String gatewayOrderId;
    public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
    @SerializedName(value="reference_id")
    private String referenceId;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @SerializedName(value="statement_descriptor")
    private String statementDescriptor;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR_PHONE = "statement_descriptor_phone";
    @SerializedName(value="statement_descriptor_phone")
    private String statementDescriptorPhone;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private Boolean external;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public PayInvoiceRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the payment.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PayInvoiceRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice. Either `account_id` or `account_number` is required.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PayInvoiceRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the account that owns the invoice. Either `account_number` or `account_id` is required.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PayInvoiceRequest authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the authorization transaction from the payment gateway.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public PayInvoiceRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PayInvoiceRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="3-letter ISO 4217 currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PayInvoiceRequest bankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getBankAccountAccount() {
        return this.bankAccountAccount;
    }

    public void setBankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
    }

    public PayInvoiceRequest paymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the payment takes effect.")
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public PayInvoiceRequest paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment method used to create this payment.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PayInvoiceRequest gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment gateway that Zuora will use to authorize this payment.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public PayInvoiceRequest gatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A merchant-specified natural key value that can be passed to the payment gateway when a payment is created. If not specified, the payment number will be passed in instead.")
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    public PayInvoiceRequest referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A second transaction identifier returned by the payment gateway if there is an additional transaction for the refunds. You may use this field to reconcile payments between your payment gateway and Zuora Payments.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public PayInvoiceRequest gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public PayInvoiceRequest putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public PayInvoiceRequest statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public PayInvoiceRequest statementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptorPhone() {
        return this.statementDescriptorPhone;
    }

    public void setStatementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
    }

    public PayInvoiceRequest external(Boolean external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, indicates that this payment is not handled by Zuora.")
    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public PayInvoiceRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PayInvoiceRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayInvoiceRequest payInvoiceRequest = (PayInvoiceRequest)o;
        return Objects.equals(this.amount, payInvoiceRequest.amount) && Objects.equals(this.accountId, payInvoiceRequest.accountId) && Objects.equals(this.accountNumber, payInvoiceRequest.accountNumber) && Objects.equals(this.authorizationId, payInvoiceRequest.authorizationId) && Objects.equals(this.description, payInvoiceRequest.description) && Objects.equals(this.currency, payInvoiceRequest.currency) && Objects.equals(this.bankAccountAccount, payInvoiceRequest.bankAccountAccount) && Objects.equals(this.paymentDate, payInvoiceRequest.paymentDate) && Objects.equals(this.paymentMethodId, payInvoiceRequest.paymentMethodId) && Objects.equals(this.gatewayId, payInvoiceRequest.gatewayId) && Objects.equals(this.gatewayOrderId, payInvoiceRequest.gatewayOrderId) && Objects.equals(this.referenceId, payInvoiceRequest.referenceId) && Objects.equals(this.gatewayOptions, payInvoiceRequest.gatewayOptions) && Objects.equals(this.statementDescriptor, payInvoiceRequest.statementDescriptor) && Objects.equals(this.statementDescriptorPhone, payInvoiceRequest.statementDescriptorPhone) && Objects.equals(this.external, payInvoiceRequest.external) && Objects.equals(this.customFields, payInvoiceRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.accountId, this.accountNumber, this.authorizationId, this.description, this.currency, this.bankAccountAccount, this.paymentDate, this.paymentMethodId, this.gatewayId, this.gatewayOrderId, this.referenceId, this.gatewayOptions, this.statementDescriptor, this.statementDescriptorPhone, this.external, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayInvoiceRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    bankAccountAccount: ").append(this.toIndentedString(this.bankAccountAccount)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    gatewayOrderId: ").append(this.toIndentedString(this.gatewayOrderId)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    statementDescriptorPhone: ").append(this.toIndentedString(this.statementDescriptorPhone)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

