/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.BillRunPreviewFile;
import org.openapitools.client.model.BillRunPreviewStateTransitions;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BillRunPreview {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ASSUME_RENEWAL = "assume_renewal";
    @SerializedName(value="assume_renewal")
    private AssumeRenewalEnum assumeRenewal;
    public static final String SERIALIZED_NAME_BATCHES = "batches";
    @SerializedName(value="batches")
    private List<String> batches = null;
    public static final String SERIALIZED_NAME_CHARGES_EXCLUDED = "charges_excluded";
    @SerializedName(value="charges_excluded")
    private List<ChargesExcludedEnum> chargesExcluded = null;
    public static final String SERIALIZED_NAME_INCLUDE_DRAFT_ITEMS = "include_draft_items";
    @SerializedName(value="include_draft_items")
    private Boolean includeDraftItems;
    public static final String SERIALIZED_NAME_INCLUDE_EVERGREEN_SUBSCRIPTIONS = "include_evergreen_subscriptions";
    @SerializedName(value="include_evergreen_subscriptions")
    private Boolean includeEvergreenSubscriptions;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_STATE_TRANSITIONS = "state_transitions";
    @SerializedName(value="state_transitions")
    private BillRunPreviewStateTransitions stateTransitions;
    public static final String SERIALIZED_NAME_FILE = "file";
    @SerializedName(value="file")
    private BillRunPreviewFile _file;
    public static final String SERIALIZED_NAME_BILLING_PREVIEW_RUN_NUMBER = "billing_preview_run_number";
    @SerializedName(value="billing_preview_run_number")
    private String billingPreviewRunNumber;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_NUMBER_OF_ACCOUNTS_SUCCEEDED = "number_of_accounts_succeeded";
    @SerializedName(value="number_of_accounts_succeeded")
    private BigDecimal numberOfAccountsSucceeded;
    public static final String SERIALIZED_NAME_NUMBER_OF_ACCOUNTS = "number_of_accounts";
    @SerializedName(value="number_of_accounts")
    private BigDecimal numberOfAccounts;

    public BillRunPreview() {
    }

    public BillRunPreview(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public BillRunPreview customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BillRunPreview putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public BillRunPreview assumeRenewal(AssumeRenewalEnum assumeRenewal) {
        this.assumeRenewal = assumeRenewal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to generate a preview of future invoice items and credit memo items with the assumption that the subscriptions are renewed. **all**: The assumption is applied to all the subscriptions. Zuora generates preview invoice item data and credit memo item data from the first day of the customer's next billing period to the target date. **auto_renew_only**: The assumption is applied to the subscriptions that have auto_renew enabled. Zuora generates preview invoice item data and credit memo item data from the first day of the customer's next billing period to the target date.")
    public AssumeRenewalEnum getAssumeRenewal() {
        return this.assumeRenewal;
    }

    public void setAssumeRenewal(AssumeRenewalEnum assumeRenewal) {
        this.assumeRenewal = assumeRenewal;
    }

    public BillRunPreview batches(List<String> batches) {
        this.batches = batches;
        return this;
    }

    public BillRunPreview addBatchesItem(String batchesItem) {
        if (this.batches == null) {
            this.batches = new ArrayList<String>();
        }
        this.batches.add(batchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifiers of the customer account batches to be included in this bill run preview.")
    public List<String> getBatches() {
        return this.batches;
    }

    public void setBatches(List<String> batches) {
        this.batches = batches;
    }

    public BillRunPreview chargesExcluded(List<ChargesExcludedEnum> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
        return this;
    }

    public BillRunPreview addChargesExcludedItem(ChargesExcludedEnum chargesExcludedItem) {
        if (this.chargesExcluded == null) {
            this.chargesExcluded = new ArrayList<ChargesExcludedEnum>();
        }
        this.chargesExcluded.add(chargesExcludedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Charge type or types to be excluded from this bill run preview.")
    public List<ChargesExcludedEnum> getChargesExcluded() {
        return this.chargesExcluded;
    }

    public void setChargesExcluded(List<ChargesExcludedEnum> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
    }

    public BillRunPreview includeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, draft items will be included in this bill run preview.")
    public Boolean getIncludeDraftItems() {
        return this.includeDraftItems;
    }

    public void setIncludeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
    }

    public BillRunPreview includeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, evergreen subscriptions will be included in this bill run preview.")
    public Boolean getIncludeEvergreenSubscriptions() {
        return this.includeEvergreenSubscriptions;
    }

    public void setIncludeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
    }

    public BillRunPreview targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="All unbilled items on or before this date are included in this bill run.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public BillRunPreview stateTransitions(BillRunPreviewStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillRunPreviewStateTransitions getStateTransitions() {
        return this.stateTransitions;
    }

    public void setStateTransitions(BillRunPreviewStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    public BillRunPreview _file(BillRunPreviewFile _file) {
        this._file = _file;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillRunPreviewFile getFile() {
        return this._file;
    }

    public void setFile(BillRunPreviewFile _file) {
        this._file = _file;
    }

    public BillRunPreview billingPreviewRunNumber(String billingPreviewRunNumber) {
        this.billingPreviewRunNumber = billingPreviewRunNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for this object.")
    public String getBillingPreviewRunNumber() {
        return this.billingPreviewRunNumber;
    }

    public void setBillingPreviewRunNumber(String billingPreviewRunNumber) {
        this.billingPreviewRunNumber = billingPreviewRunNumber;
    }

    public BillRunPreview state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the bill run preview.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BillRunPreview numberOfAccountsSucceeded(BigDecimal numberOfAccountsSucceeded) {
        this.numberOfAccountsSucceeded = numberOfAccountsSucceeded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the customer accounts whose bill run preview job succeeded.")
    public BigDecimal getNumberOfAccountsSucceeded() {
        return this.numberOfAccountsSucceeded;
    }

    public void setNumberOfAccountsSucceeded(BigDecimal numberOfAccountsSucceeded) {
        this.numberOfAccountsSucceeded = numberOfAccountsSucceeded;
    }

    public BillRunPreview numberOfAccounts(BigDecimal numberOfAccounts) {
        this.numberOfAccounts = numberOfAccounts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the customer accounts included in the bill run preview job.")
    public BigDecimal getNumberOfAccounts() {
        return this.numberOfAccounts;
    }

    public void setNumberOfAccounts(BigDecimal numberOfAccounts) {
        this.numberOfAccounts = numberOfAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillRunPreview billRunPreview = (BillRunPreview)o;
        return Objects.equals(this.id, billRunPreview.id) && Objects.equals(this.updatedById, billRunPreview.updatedById) && Objects.equals(this.updatedTime, billRunPreview.updatedTime) && Objects.equals(this.createdById, billRunPreview.createdById) && Objects.equals(this.createdTime, billRunPreview.createdTime) && Objects.equals(this.customFields, billRunPreview.customFields) && Objects.equals(this.customObjects, billRunPreview.customObjects) && Objects.equals((Object)this.assumeRenewal, (Object)billRunPreview.assumeRenewal) && Objects.equals(this.batches, billRunPreview.batches) && Objects.equals(this.chargesExcluded, billRunPreview.chargesExcluded) && Objects.equals(this.includeDraftItems, billRunPreview.includeDraftItems) && Objects.equals(this.includeEvergreenSubscriptions, billRunPreview.includeEvergreenSubscriptions) && Objects.equals(this.targetDate, billRunPreview.targetDate) && Objects.equals(this.stateTransitions, billRunPreview.stateTransitions) && Objects.equals(this._file, billRunPreview._file) && Objects.equals(this.billingPreviewRunNumber, billRunPreview.billingPreviewRunNumber) && Objects.equals((Object)this.state, (Object)billRunPreview.state) && Objects.equals(this.numberOfAccountsSucceeded, billRunPreview.numberOfAccountsSucceeded) && Objects.equals(this.numberOfAccounts, billRunPreview.numberOfAccounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.assumeRenewal, this.batches, this.chargesExcluded, this.includeDraftItems, this.includeEvergreenSubscriptions, this.targetDate, this.stateTransitions, this._file, this.billingPreviewRunNumber, this.state, this.numberOfAccountsSucceeded, this.numberOfAccounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillRunPreview {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    assumeRenewal: ").append(this.toIndentedString((Object)this.assumeRenewal)).append("\n");
        sb.append("    batches: ").append(this.toIndentedString(this.batches)).append("\n");
        sb.append("    chargesExcluded: ").append(this.toIndentedString(this.chargesExcluded)).append("\n");
        sb.append("    includeDraftItems: ").append(this.toIndentedString(this.includeDraftItems)).append("\n");
        sb.append("    includeEvergreenSubscriptions: ").append(this.toIndentedString(this.includeEvergreenSubscriptions)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    stateTransitions: ").append(this.toIndentedString(this.stateTransitions)).append("\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("    billingPreviewRunNumber: ").append(this.toIndentedString(this.billingPreviewRunNumber)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    numberOfAccountsSucceeded: ").append(this.toIndentedString(this.numberOfAccountsSucceeded)).append("\n");
        sb.append("    numberOfAccounts: ").append(this.toIndentedString(this.numberOfAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChargesExcludedEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ChargesExcludedEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChargesExcludedEnum fromValue(String value) {
            for (ChargesExcludedEnum b : ChargesExcludedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChargesExcludedEnum> {
            public void write(JsonWriter jsonWriter, ChargesExcludedEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChargesExcludedEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChargesExcludedEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssumeRenewalEnum {
        ALL("all"),
        AUTO_RENEW_ONLY("auto_renew_only"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private AssumeRenewalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssumeRenewalEnum fromValue(String value) {
            for (AssumeRenewalEnum b : AssumeRenewalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AssumeRenewalEnum> {
            public void write(JsonWriter jsonWriter, AssumeRenewalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AssumeRenewalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssumeRenewalEnum.fromValue(value);
            }
        }
    }
}

