/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentScheduleItemLink;
import org.openapitools.client.model.PaymentScheduleItemPaymentOption;
import org.openapitools.client.model.PaymentScheduleItemUnlink;
import org.threeten.bp.LocalDate;

public class PaymentScheduleItemPatch {
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_ID = "payment_schedule_id";
    @SerializedName(value="payment_schedule_id")
    private String paymentScheduleId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_NUMBER = "payment_schedule_number";
    @SerializedName(value="payment_schedule_number")
    private String paymentScheduleNumber;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_SCHEDULED_DATE = "scheduled_date";
    @SerializedName(value="scheduled_date")
    private LocalDate scheduledDate;
    public static final String SERIALIZED_NAME_RUN_HOUR = "run_hour";
    @SerializedName(value="run_hour")
    private Integer runHour;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_PAYMENT_OPTIONS = "payment_options";
    @SerializedName(value="payment_options")
    private List<PaymentScheduleItemPaymentOption> paymentOptions = null;
    public static final String SERIALIZED_NAME_LINK = "link";
    @SerializedName(value="link")
    private List<PaymentScheduleItemLink> link = null;
    public static final String SERIALIZED_NAME_UNLINK = "unlink";
    @SerializedName(value="unlink")
    private List<PaymentScheduleItemUnlink> unlink = null;

    public PaymentScheduleItemPatch paymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the payment schedule.")
    public String getPaymentScheduleId() {
        return this.paymentScheduleId;
    }

    public void setPaymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
    }

    public PaymentScheduleItemPatch paymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule.")
    public String getPaymentScheduleNumber() {
        return this.paymentScheduleNumber;
    }

    public void setPaymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
    }

    public PaymentScheduleItemPatch amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be collected by this payment schedule item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentScheduleItemPatch currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentScheduleItemPatch description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of payment schedule item", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentScheduleItemPatch paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when `items` is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentScheduleItemPatch paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. The default value is the account's default payment method ID. This field will be ignored when `items` is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentScheduleItemPatch scheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The scheduled date of collection.")
    public LocalDate getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public PaymentScheduleItemPatch runHour(Integer runHour) {
        this.runHour = runHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="At which hour in the day in the tenant's timezone this payment will be collected. Available values:[0,1,2,~,22,23]. If the time difference between your tenant\u2019s timezone and the timezone where Zuora servers are located is not in full hours, for example, 2.5 hours, the payment schedule items will be triggered half an hour later than your scheduled time. The default value is 0. If the payment run_hour and scheduled_date are backdated, the system will collect the payment when the next run_hour occurs.")
    public Integer getRunHour() {
        return this.runHour;
    }

    public void setRunHour(Integer runHour) {
        this.runHour = runHour;
    }

    public PaymentScheduleItemPatch customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentScheduleItemPatch putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public PaymentScheduleItemPatch paymentOptions(List<PaymentScheduleItemPaymentOption> paymentOptions) {
        this.paymentOptions = paymentOptions;
        return this;
    }

    public PaymentScheduleItemPatch addPaymentOptionsItem(PaymentScheduleItemPaymentOption paymentOptionsItem) {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentScheduleItemPaymentOption>();
        }
        this.paymentOptions.add(paymentOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for the payment options, which describe the transactional level rules for processing payments. Currently, only the `gateway_options` type is supported. Payment schedule `payment_options` take precedence over payment schedule item `payment_options`.")
    public List<PaymentScheduleItemPaymentOption> getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(List<PaymentScheduleItemPaymentOption> paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public PaymentScheduleItemPatch link(List<PaymentScheduleItemLink> link) {
        this.link = link;
        return this;
    }

    public PaymentScheduleItemPatch addLinkItem(PaymentScheduleItemLink linkItem) {
        if (this.link == null) {
            this.link = new ArrayList<PaymentScheduleItemLink>();
        }
        this.link.add(linkItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentScheduleItemLink> getLink() {
        return this.link;
    }

    public void setLink(List<PaymentScheduleItemLink> link) {
        this.link = link;
    }

    public PaymentScheduleItemPatch unlink(List<PaymentScheduleItemUnlink> unlink) {
        this.unlink = unlink;
        return this;
    }

    public PaymentScheduleItemPatch addUnlinkItem(PaymentScheduleItemUnlink unlinkItem) {
        if (this.unlink == null) {
            this.unlink = new ArrayList<PaymentScheduleItemUnlink>();
        }
        this.unlink.add(unlinkItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentScheduleItemUnlink> getUnlink() {
        return this.unlink;
    }

    public void setUnlink(List<PaymentScheduleItemUnlink> unlink) {
        this.unlink = unlink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentScheduleItemPatch paymentScheduleItemPatch = (PaymentScheduleItemPatch)o;
        return Objects.equals(this.paymentScheduleId, paymentScheduleItemPatch.paymentScheduleId) && Objects.equals(this.paymentScheduleNumber, paymentScheduleItemPatch.paymentScheduleNumber) && Objects.equals(this.amount, paymentScheduleItemPatch.amount) && Objects.equals(this.currency, paymentScheduleItemPatch.currency) && Objects.equals(this.description, paymentScheduleItemPatch.description) && Objects.equals(this.paymentGatewayId, paymentScheduleItemPatch.paymentGatewayId) && Objects.equals(this.paymentMethodId, paymentScheduleItemPatch.paymentMethodId) && Objects.equals(this.scheduledDate, paymentScheduleItemPatch.scheduledDate) && Objects.equals(this.runHour, paymentScheduleItemPatch.runHour) && Objects.equals(this.customFields, paymentScheduleItemPatch.customFields) && Objects.equals(this.paymentOptions, paymentScheduleItemPatch.paymentOptions) && Objects.equals(this.link, paymentScheduleItemPatch.link) && Objects.equals(this.unlink, paymentScheduleItemPatch.unlink);
    }

    public int hashCode() {
        return Objects.hash(this.paymentScheduleId, this.paymentScheduleNumber, this.amount, this.currency, this.description, this.paymentGatewayId, this.paymentMethodId, this.scheduledDate, this.runHour, this.customFields, this.paymentOptions, this.link, this.unlink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentScheduleItemPatch {\n");
        sb.append("    paymentScheduleId: ").append(this.toIndentedString(this.paymentScheduleId)).append("\n");
        sb.append("    paymentScheduleNumber: ").append(this.toIndentedString(this.paymentScheduleNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    scheduledDate: ").append(this.toIndentedString(this.scheduledDate)).append("\n");
        sb.append("    runHour: ").append(this.toIndentedString(this.runHour)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    paymentOptions: ").append(this.toIndentedString(this.paymentOptions)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    unlink: ").append(this.toIndentedString(this.unlink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

