/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `autogiro_debit`, this hash contains details about the Autogiro bank account.")
public class AutogiroDebit {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_IDENTITY_NUMBER = "identity_number";
    @SerializedName(value="identity_number")
    private String identityNumber;
    public static final String SERIALIZED_NAME_BRANCH_CODE = "branch_code";
    @SerializedName(value="branch_code")
    private String branchCode;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;

    public AutogiroDebit accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank account number of the account holder.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public AutogiroDebit identityNumber(String identityNumber) {
        this.identityNumber = identityNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The identity number used for Autogiro (Direct Debit SE).")
    public String getIdentityNumber() {
        return this.identityNumber;
    }

    public void setIdentityNumber(String identityNumber) {
        this.identityNumber = identityNumber;
    }

    public AutogiroDebit branchCode(String branchCode) {
        this.branchCode = branchCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the bank branch associated with this bank account.")
    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public AutogiroDebit mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutogiroDebit autogiroDebit = (AutogiroDebit)o;
        return Objects.equals(this.accountNumber, autogiroDebit.accountNumber) && Objects.equals(this.identityNumber, autogiroDebit.identityNumber) && Objects.equals(this.branchCode, autogiroDebit.branchCode) && Objects.equals(this.mandate, autogiroDebit.mandate);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.identityNumber, this.branchCode, this.mandate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutogiroDebit {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    identityNumber: ").append(this.toIndentedString(this.identityNumber)).append("\n");
        sb.append("    branchCode: ").append(this.toIndentedString(this.branchCode)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

