/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.ApplyPaymentRequest;
import com.zuora.model.BulkPaymentProfileRequest;
import com.zuora.model.BulkPaymentProfileResponse;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreatePaymentRequest;
import com.zuora.model.CreateRefundRequest;
import com.zuora.model.CreateRefundwithAutoUnapply;
import com.zuora.model.GetPaymentItemPartResponse;
import com.zuora.model.GetPaymentItemPartsResponse;
import com.zuora.model.GetPaymentPartResponse;
import com.zuora.model.GetPaymentPartsResponse;
import com.zuora.model.GetPaymentsResponse;
import com.zuora.model.PaymentResponse;
import com.zuora.model.RefundResponse;
import com.zuora.model.TransferPayment;
import com.zuora.model.UnapplyPaymentRequest;
import com.zuora.model.UpdatePaymentRequest;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call applyPaymentCall(String paymentKey, ApplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApplyPaymentRequest localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentKey}/apply".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyPaymentValidateBeforeCall(String paymentKey, ApplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling applyPayment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applyPayment(Async)");
        }
        return this.applyPaymentCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse applyPayment(String paymentKey, ApplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.applyPaymentWithHttpInfo(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> applyPaymentWithHttpInfo(String paymentKey, ApplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.applyPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call applyPaymentAsync(String paymentKey, ApplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.applyPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApplyPaymentApi applyPaymentApi(String paymentKey, ApplyPaymentRequest body) {
        return new ApplyPaymentApi(paymentKey, body);
    }

    private Call bulkUpsertPaymentProfilesCall(BulkPaymentProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkPaymentProfileRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-profile";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkUpsertPaymentProfilesValidateBeforeCall(BulkPaymentProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling bulkUpsertPaymentProfiles(Async)");
        }
        return this.bulkUpsertPaymentProfilesCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected BulkPaymentProfileResponse bulkUpsertPaymentProfiles(BulkPaymentProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<BulkPaymentProfileResponse> localVarResp = this.bulkUpsertPaymentProfilesWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<BulkPaymentProfileResponse> bulkUpsertPaymentProfilesWithHttpInfo(BulkPaymentProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.bulkUpsertPaymentProfilesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BulkPaymentProfileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call bulkUpsertPaymentProfilesAsync(BulkPaymentProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback<BulkPaymentProfileResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkUpsertPaymentProfilesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BulkPaymentProfileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkUpsertPaymentProfilesApi bulkUpsertPaymentProfilesApi(BulkPaymentProfileRequest request) {
        return new BulkUpsertPaymentProfilesApi(request);
    }

    private Call cancelPaymentCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}/cancel".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentValidateBeforeCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling cancelPayment(Async)");
        }
        return this.cancelPaymentCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse cancelPayment(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.cancelPaymentWithHttpInfo(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> cancelPaymentWithHttpInfo(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelPaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelPaymentAsync(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentApi cancelPaymentApi(String paymentKey) {
        return new CancelPaymentApi(paymentKey);
    }

    private Call createPaymentCall(CreatePaymentRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentRequest localVarPostBody = body;
        String localVarPath = "/v1/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentValidateBeforeCall(CreatePaymentRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createPayment(Async)");
        }
        return this.createPaymentCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse createPayment(CreatePaymentRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.createPaymentWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> createPaymentWithHttpInfo(CreatePaymentRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentAsync(CreatePaymentRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentApi createPaymentApi(CreatePaymentRequest body) {
        return new CreatePaymentApi(body);
    }

    private Call createRefundPaymentCall(String paymentKey, CreateRefundRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateRefundRequest localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentKey}/refunds".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRefundPaymentValidateBeforeCall(String paymentKey, CreateRefundRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling createRefundPayment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createRefundPayment(Async)");
        }
        return this.createRefundPaymentCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected RefundResponse createRefundPayment(String paymentKey, CreateRefundRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<RefundResponse> localVarResp = this.createRefundPaymentWithHttpInfo(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<RefundResponse> createRefundPaymentWithHttpInfo(String paymentKey, CreateRefundRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createRefundPaymentValidateBeforeCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<RefundResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createRefundPaymentAsync(String paymentKey, CreateRefundRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<RefundResponse> _callback) throws ApiException {
        Call localVarCall = this.createRefundPaymentValidateBeforeCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RefundResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateRefundPaymentApi createRefundPaymentApi(String paymentKey, CreateRefundRequest body) {
        return new CreateRefundPaymentApi(paymentKey, body);
    }

    private Call deletePaymentCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePaymentValidateBeforeCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling deletePayment(Async)");
        }
        return this.deletePaymentCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deletePayment(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deletePaymentWithHttpInfo(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deletePaymentWithHttpInfo(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deletePaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deletePaymentAsync(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deletePaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeletePaymentApi deletePaymentApi(String paymentKey) {
        return new DeletePaymentApi(paymentKey);
    }

    private Call getPaymentCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentValidateBeforeCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling getPayment(Async)");
        }
        return this.getPaymentCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse getPayment(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.getPaymentWithHttpInfo(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> getPaymentWithHttpInfo(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentAsync(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentApi getPaymentApi(String paymentKey) {
        return new GetPaymentApi(paymentKey);
    }

    private Call getPaymentItemPartCall(String partId, String itemPartId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}/parts/{partId}/item-parts/{itemPartId}".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{itemPartId}", this.localVarApiClient.escapeString(itemPartId.toString())).replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentItemPartValidateBeforeCall(String partId, String itemPartId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getPaymentItemPart(Async)");
        }
        if (itemPartId == null) {
            throw new ApiException("Missing the required parameter 'itemPartId' when calling getPaymentItemPart(Async)");
        }
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling getPaymentItemPart(Async)");
        }
        return this.getPaymentItemPartCall(partId, itemPartId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetPaymentItemPartResponse getPaymentItemPart(String partId, String itemPartId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetPaymentItemPartResponse> localVarResp = this.getPaymentItemPartWithHttpInfo(partId, itemPartId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentItemPartResponse> getPaymentItemPartWithHttpInfo(String partId, String itemPartId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentItemPartValidateBeforeCall(partId, itemPartId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetPaymentItemPartResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentItemPartAsync(String partId, String itemPartId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetPaymentItemPartResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentItemPartValidateBeforeCall(partId, itemPartId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentItemPartResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentItemPartApi getPaymentItemPartApi(String partId, String itemPartId, String paymentKey) {
        return new GetPaymentItemPartApi(partId, itemPartId, paymentKey);
    }

    private Call getPaymentItemPartsCall(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}/parts/{partId}/item-parts".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentItemPartsValidateBeforeCall(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getPaymentItemParts(Async)");
        }
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling getPaymentItemParts(Async)");
        }
        return this.getPaymentItemPartsCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetPaymentItemPartsResponse getPaymentItemParts(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetPaymentItemPartsResponse> localVarResp = this.getPaymentItemPartsWithHttpInfo(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentItemPartsResponse> getPaymentItemPartsWithHttpInfo(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentItemPartsValidateBeforeCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetPaymentItemPartsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentItemPartsAsync(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetPaymentItemPartsResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentItemPartsValidateBeforeCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentItemPartsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentItemPartsApi getPaymentItemPartsApi(String partId, String paymentKey) {
        return new GetPaymentItemPartsApi(partId, paymentKey);
    }

    private Call getPaymentPartCall(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}/parts/{partId}".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentPartValidateBeforeCall(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getPaymentPart(Async)");
        }
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling getPaymentPart(Async)");
        }
        return this.getPaymentPartCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetPaymentPartResponse getPaymentPart(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetPaymentPartResponse> localVarResp = this.getPaymentPartWithHttpInfo(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentPartResponse> getPaymentPartWithHttpInfo(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentPartValidateBeforeCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetPaymentPartResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentPartAsync(String partId, String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetPaymentPartResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentPartValidateBeforeCall(partId, paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentPartResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentPartApi getPaymentPartApi(String partId, String paymentKey) {
        return new GetPaymentPartApi(partId, paymentKey);
    }

    private Call getPaymentPartsCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments/{paymentKey}/parts".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentPartsValidateBeforeCall(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling getPaymentParts(Async)");
        }
        return this.getPaymentPartsCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetPaymentPartsResponse getPaymentParts(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetPaymentPartsResponse> localVarResp = this.getPaymentPartsWithHttpInfo(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentPartsResponse> getPaymentPartsWithHttpInfo(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentPartsValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetPaymentPartsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentPartsAsync(String paymentKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetPaymentPartsResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentPartsValidateBeforeCall(paymentKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentPartsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentPartsApi getPaymentPartsApi(String paymentKey) {
        return new GetPaymentPartsApi(paymentKey);
    }

    private Call getRetrieveAllPaymentsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String accountId, Double amount, Double appliedAmount, String createdById, OffsetDateTime createdDate, Double creditBalanceAmount, String currency, OffsetDateTime effectiveDate, String number, Double refundAmount, String status, String type, Double unappliedAmount, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountId", accountId));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (appliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appliedAmount", appliedAmount));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (creditBalanceAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("creditBalanceAmount", creditBalanceAmount));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (effectiveDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("effectiveDate", effectiveDate));
        }
        if (number != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("number", number));
        }
        if (refundAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("refundAmount", refundAmount));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (unappliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unappliedAmount", unappliedAmount));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRetrieveAllPaymentsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String accountId, Double amount, Double appliedAmount, String createdById, OffsetDateTime createdDate, Double creditBalanceAmount, String currency, OffsetDateTime effectiveDate, String number, Double refundAmount, String status, String type, Double unappliedAmount, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getRetrieveAllPaymentsCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, accountId, amount, appliedAmount, createdById, createdDate, creditBalanceAmount, currency, effectiveDate, number, refundAmount, status, type, unappliedAmount, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
    }

    protected GetPaymentsResponse getRetrieveAllPayments(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String accountId, Double amount, Double appliedAmount, String createdById, OffsetDateTime createdDate, Double creditBalanceAmount, String currency, OffsetDateTime effectiveDate, String number, Double refundAmount, String status, String type, Double unappliedAmount, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetPaymentsResponse> localVarResp = this.getRetrieveAllPaymentsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, accountId, amount, appliedAmount, createdById, createdDate, creditBalanceAmount, currency, effectiveDate, number, refundAmount, status, type, unappliedAmount, updatedById, updatedDate, sort, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentsResponse> getRetrieveAllPaymentsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String accountId, Double amount, Double appliedAmount, String createdById, OffsetDateTime createdDate, Double creditBalanceAmount, String currency, OffsetDateTime effectiveDate, String number, Double refundAmount, String status, String type, Double unappliedAmount, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getRetrieveAllPaymentsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, accountId, amount, appliedAmount, createdById, createdDate, creditBalanceAmount, currency, effectiveDate, number, refundAmount, status, type, unappliedAmount, updatedById, updatedDate, sort, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetPaymentsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getRetrieveAllPaymentsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String accountId, Double amount, Double appliedAmount, String createdById, OffsetDateTime createdDate, Double creditBalanceAmount, String currency, OffsetDateTime effectiveDate, String number, Double refundAmount, String status, String type, Double unappliedAmount, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback<GetPaymentsResponse> _callback) throws ApiException {
        Call localVarCall = this.getRetrieveAllPaymentsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, accountId, amount, appliedAmount, createdById, createdDate, creditBalanceAmount, currency, effectiveDate, number, refundAmount, status, type, unappliedAmount, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetRetrieveAllPaymentsApi getRetrieveAllPaymentsApi() {
        return new GetRetrieveAllPaymentsApi();
    }

    private Call refundPaymentwithAutoUnapplyCall(String paymentKey, CreateRefundwithAutoUnapply body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateRefundwithAutoUnapply localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentKey}/refunds/unapply".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call refundPaymentwithAutoUnapplyValidateBeforeCall(String paymentKey, CreateRefundwithAutoUnapply body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling refundPaymentwithAutoUnapply(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling refundPaymentwithAutoUnapply(Async)");
        }
        return this.refundPaymentwithAutoUnapplyCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected RefundResponse refundPaymentwithAutoUnapply(String paymentKey, CreateRefundwithAutoUnapply body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<RefundResponse> localVarResp = this.refundPaymentwithAutoUnapplyWithHttpInfo(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<RefundResponse> refundPaymentwithAutoUnapplyWithHttpInfo(String paymentKey, CreateRefundwithAutoUnapply body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.refundPaymentwithAutoUnapplyValidateBeforeCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<RefundResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call refundPaymentwithAutoUnapplyAsync(String paymentKey, CreateRefundwithAutoUnapply body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<RefundResponse> _callback) throws ApiException {
        Call localVarCall = this.refundPaymentwithAutoUnapplyValidateBeforeCall(paymentKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RefundResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RefundPaymentwithAutoUnapplyApi refundPaymentwithAutoUnapplyApi(String paymentKey, CreateRefundwithAutoUnapply body) {
        return new RefundPaymentwithAutoUnapplyApi(paymentKey, body);
    }

    private Call transferPaymentCall(String paymentKey, TransferPayment body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TransferPayment localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentKey}/transfer".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferPaymentValidateBeforeCall(String paymentKey, TransferPayment body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling transferPayment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling transferPayment(Async)");
        }
        return this.transferPaymentCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse transferPayment(String paymentKey, TransferPayment body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.transferPaymentWithHttpInfo(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> transferPaymentWithHttpInfo(String paymentKey, TransferPayment body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.transferPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call transferPaymentAsync(String paymentKey, TransferPayment body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.transferPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public TransferPaymentApi transferPaymentApi(String paymentKey, TransferPayment body) {
        return new TransferPaymentApi(paymentKey, body);
    }

    private Call unapplyPaymentCall(String paymentKey, UnapplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UnapplyPaymentRequest localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentKey}/unapply".replace("{paymentKey}", this.localVarApiClient.escapeString(paymentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unapplyPaymentValidateBeforeCall(String paymentKey, UnapplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentKey == null) {
            throw new ApiException("Missing the required parameter 'paymentKey' when calling unapplyPayment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unapplyPayment(Async)");
        }
        return this.unapplyPaymentCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse unapplyPayment(String paymentKey, UnapplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.unapplyPaymentWithHttpInfo(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> unapplyPaymentWithHttpInfo(String paymentKey, UnapplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unapplyPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unapplyPaymentAsync(String paymentKey, UnapplyPaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.unapplyPaymentValidateBeforeCall(paymentKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnapplyPaymentApi unapplyPaymentApi(String paymentKey, UnapplyPaymentRequest body) {
        return new UnapplyPaymentApi(paymentKey, body);
    }

    private Call updatePaymentCall(String paymentId, UpdatePaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePaymentRequest localVarPostBody = body;
        String localVarPath = "/v1/payments/{paymentId}".replace("{paymentId}", this.localVarApiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentValidateBeforeCall(String paymentId, UpdatePaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentId == null) {
            throw new ApiException("Missing the required parameter 'paymentId' when calling updatePayment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatePayment(Async)");
        }
        return this.updatePaymentCall(paymentId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentResponse updatePayment(String paymentId, UpdatePaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentResponse> localVarResp = this.updatePaymentWithHttpInfo(paymentId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentResponse> updatePaymentWithHttpInfo(String paymentId, UpdatePaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentValidateBeforeCall(paymentId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentAsync(String paymentId, UpdatePaymentRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentValidateBeforeCall(paymentId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentApi updatePaymentApi(String paymentId, UpdatePaymentRequest body) {
        return new UpdatePaymentApi(paymentId, body);
    }

    public class UpdatePaymentApi {
        private final String paymentId;
        private final UpdatePaymentRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdatePaymentApi(String paymentId, UpdatePaymentRequest body) {
            this.paymentId = paymentId;
            this.body = body;
        }

        public UpdatePaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdatePaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.updatePaymentCall(this.paymentId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.updatePaymentWithHttpInfo(this.paymentId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.updatePaymentWithHttpInfo(this.paymentId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.updatePaymentAsync(this.paymentId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UnapplyPaymentApi {
        private final String paymentKey;
        private final UnapplyPaymentRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UnapplyPaymentApi(String paymentKey, UnapplyPaymentRequest body) {
            this.paymentKey = paymentKey;
            this.body = body;
        }

        public UnapplyPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UnapplyPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UnapplyPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UnapplyPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UnapplyPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UnapplyPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UnapplyPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.unapplyPaymentCall(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.unapplyPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.unapplyPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.unapplyPaymentAsync(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class TransferPaymentApi {
        private final String paymentKey;
        private final TransferPayment body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private TransferPaymentApi(String paymentKey, TransferPayment body) {
            this.paymentKey = paymentKey;
            this.body = body;
        }

        public TransferPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public TransferPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public TransferPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public TransferPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public TransferPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public TransferPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public TransferPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.transferPaymentCall(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.transferPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.transferPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.transferPaymentAsync(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class RefundPaymentwithAutoUnapplyApi {
        private final String paymentKey;
        private final CreateRefundwithAutoUnapply body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private RefundPaymentwithAutoUnapplyApi(String paymentKey, CreateRefundwithAutoUnapply body) {
            this.paymentKey = paymentKey;
            this.body = body;
        }

        public RefundPaymentwithAutoUnapplyApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RefundPaymentwithAutoUnapplyApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.refundPaymentwithAutoUnapplyCall(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public RefundResponse execute() throws ApiException {
            ApiResponse<RefundResponse> localVarResp = PaymentsApi.this.refundPaymentwithAutoUnapplyWithHttpInfo(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<RefundResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.refundPaymentwithAutoUnapplyWithHttpInfo(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<RefundResponse> _callback) throws ApiException {
            return PaymentsApi.this.refundPaymentwithAutoUnapplyAsync(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetRetrieveAllPaymentsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String accountId;
        private Double amount;
        private Double appliedAmount;
        private String createdById;
        private OffsetDateTime createdDate;
        private Double creditBalanceAmount;
        private String currency;
        private OffsetDateTime effectiveDate;
        private String number;
        private Double refundAmount;
        private String status;
        private String type;
        private Double unappliedAmount;
        private String updatedById;
        private OffsetDateTime updatedDate;
        private String sort;
        private String zuoraOrgIds;

        private GetRetrieveAllPaymentsApi() {
        }

        public GetRetrieveAllPaymentsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetRetrieveAllPaymentsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetRetrieveAllPaymentsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetRetrieveAllPaymentsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetRetrieveAllPaymentsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetRetrieveAllPaymentsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetRetrieveAllPaymentsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetRetrieveAllPaymentsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetRetrieveAllPaymentsApi accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public GetRetrieveAllPaymentsApi amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public GetRetrieveAllPaymentsApi appliedAmount(Double appliedAmount) {
            this.appliedAmount = appliedAmount;
            return this;
        }

        public GetRetrieveAllPaymentsApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetRetrieveAllPaymentsApi createdDate(OffsetDateTime createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetRetrieveAllPaymentsApi creditBalanceAmount(Double creditBalanceAmount) {
            this.creditBalanceAmount = creditBalanceAmount;
            return this;
        }

        public GetRetrieveAllPaymentsApi currency(String currency) {
            this.currency = currency;
            return this;
        }

        public GetRetrieveAllPaymentsApi effectiveDate(OffsetDateTime effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public GetRetrieveAllPaymentsApi number(String number) {
            this.number = number;
            return this;
        }

        public GetRetrieveAllPaymentsApi refundAmount(Double refundAmount) {
            this.refundAmount = refundAmount;
            return this;
        }

        public GetRetrieveAllPaymentsApi status(String status) {
            this.status = status;
            return this;
        }

        public GetRetrieveAllPaymentsApi type(String type) {
            this.type = type;
            return this;
        }

        public GetRetrieveAllPaymentsApi unappliedAmount(Double unappliedAmount) {
            this.unappliedAmount = unappliedAmount;
            return this;
        }

        public GetRetrieveAllPaymentsApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetRetrieveAllPaymentsApi updatedDate(OffsetDateTime updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetRetrieveAllPaymentsApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetRetrieveAllPaymentsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getRetrieveAllPaymentsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.accountId, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.creditBalanceAmount, this.currency, this.effectiveDate, this.number, this.refundAmount, this.status, this.type, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }

        public GetPaymentsResponse execute() throws ApiException {
            ApiResponse<GetPaymentsResponse> localVarResp = PaymentsApi.this.getRetrieveAllPaymentsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.accountId, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.creditBalanceAmount, this.currency, this.effectiveDate, this.number, this.refundAmount, this.status, this.type, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetPaymentsResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getRetrieveAllPaymentsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.accountId, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.creditBalanceAmount, this.currency, this.effectiveDate, this.number, this.refundAmount, this.status, this.type, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetPaymentsResponse> _callback) throws ApiException {
            return PaymentsApi.this.getRetrieveAllPaymentsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.accountId, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.creditBalanceAmount, this.currency, this.effectiveDate, this.number, this.refundAmount, this.status, this.type, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentPartsApi {
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentPartsApi(String paymentKey) {
            this.paymentKey = paymentKey;
        }

        public GetPaymentPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentPartsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetPaymentPartsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentPartsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getPaymentPartsCall(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetPaymentPartsResponse execute() throws ApiException {
            ApiResponse<GetPaymentPartsResponse> localVarResp = PaymentsApi.this.getPaymentPartsWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetPaymentPartsResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getPaymentPartsWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetPaymentPartsResponse> _callback) throws ApiException {
            return PaymentsApi.this.getPaymentPartsAsync(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentPartApi {
        private final String partId;
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentPartApi(String partId, String paymentKey) {
            this.partId = partId;
            this.paymentKey = paymentKey;
        }

        public GetPaymentPartApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentPartApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentPartApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentPartApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentPartApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentPartApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentPartApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getPaymentPartCall(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetPaymentPartResponse execute() throws ApiException {
            ApiResponse<GetPaymentPartResponse> localVarResp = PaymentsApi.this.getPaymentPartWithHttpInfo(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetPaymentPartResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getPaymentPartWithHttpInfo(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetPaymentPartResponse> _callback) throws ApiException {
            return PaymentsApi.this.getPaymentPartAsync(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentItemPartsApi {
        private final String partId;
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentItemPartsApi(String partId, String paymentKey) {
            this.partId = partId;
            this.paymentKey = paymentKey;
        }

        public GetPaymentItemPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentItemPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentItemPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentItemPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentItemPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentItemPartsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetPaymentItemPartsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentItemPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentItemPartsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getPaymentItemPartsCall(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetPaymentItemPartsResponse execute() throws ApiException {
            ApiResponse<GetPaymentItemPartsResponse> localVarResp = PaymentsApi.this.getPaymentItemPartsWithHttpInfo(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetPaymentItemPartsResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getPaymentItemPartsWithHttpInfo(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetPaymentItemPartsResponse> _callback) throws ApiException {
            return PaymentsApi.this.getPaymentItemPartsAsync(this.partId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentItemPartApi {
        private final String partId;
        private final String itemPartId;
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentItemPartApi(String partId, String itemPartId, String paymentKey) {
            this.partId = partId;
            this.itemPartId = itemPartId;
            this.paymentKey = paymentKey;
        }

        public GetPaymentItemPartApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentItemPartApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentItemPartApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentItemPartApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentItemPartApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentItemPartApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentItemPartApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getPaymentItemPartCall(this.partId, this.itemPartId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetPaymentItemPartResponse execute() throws ApiException {
            ApiResponse<GetPaymentItemPartResponse> localVarResp = PaymentsApi.this.getPaymentItemPartWithHttpInfo(this.partId, this.itemPartId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetPaymentItemPartResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getPaymentItemPartWithHttpInfo(this.partId, this.itemPartId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetPaymentItemPartResponse> _callback) throws ApiException {
            return PaymentsApi.this.getPaymentItemPartAsync(this.partId, this.itemPartId, this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentApi {
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentApi(String paymentKey) {
            this.paymentKey = paymentKey;
        }

        public GetPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.getPaymentCall(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.getPaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.getPaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.getPaymentAsync(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeletePaymentApi {
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeletePaymentApi(String paymentKey) {
            this.paymentKey = paymentKey;
        }

        public DeletePaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeletePaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeletePaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeletePaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeletePaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeletePaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeletePaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.deletePaymentCall(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = PaymentsApi.this.deletePaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.deletePaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return PaymentsApi.this.deletePaymentAsync(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateRefundPaymentApi {
        private final String paymentKey;
        private final CreateRefundRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateRefundPaymentApi(String paymentKey, CreateRefundRequest body) {
            this.paymentKey = paymentKey;
            this.body = body;
        }

        public CreateRefundPaymentApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateRefundPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateRefundPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateRefundPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateRefundPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateRefundPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateRefundPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateRefundPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.createRefundPaymentCall(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public RefundResponse execute() throws ApiException {
            ApiResponse<RefundResponse> localVarResp = PaymentsApi.this.createRefundPaymentWithHttpInfo(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<RefundResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.createRefundPaymentWithHttpInfo(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<RefundResponse> _callback) throws ApiException {
            return PaymentsApi.this.createRefundPaymentAsync(this.paymentKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreatePaymentApi {
        private final CreatePaymentRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreatePaymentApi(CreatePaymentRequest body) {
            this.body = body;
        }

        public CreatePaymentApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreatePaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.createPaymentCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.createPaymentWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.createPaymentWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.createPaymentAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelPaymentApi {
        private final String paymentKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelPaymentApi(String paymentKey) {
            this.paymentKey = paymentKey;
        }

        public CancelPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.cancelPaymentCall(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.cancelPaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.cancelPaymentWithHttpInfo(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.cancelPaymentAsync(this.paymentKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class BulkUpsertPaymentProfilesApi {
        private final BulkPaymentProfileRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private BulkUpsertPaymentProfilesApi(BulkPaymentProfileRequest request) {
            this.request = request;
        }

        public BulkUpsertPaymentProfilesApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkUpsertPaymentProfilesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkUpsertPaymentProfilesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkUpsertPaymentProfilesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkUpsertPaymentProfilesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkUpsertPaymentProfilesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkUpsertPaymentProfilesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public BulkUpsertPaymentProfilesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.bulkUpsertPaymentProfilesCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public BulkPaymentProfileResponse execute() throws ApiException {
            ApiResponse<BulkPaymentProfileResponse> localVarResp = PaymentsApi.this.bulkUpsertPaymentProfilesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<BulkPaymentProfileResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.bulkUpsertPaymentProfilesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<BulkPaymentProfileResponse> _callback) throws ApiException {
            return PaymentsApi.this.bulkUpsertPaymentProfilesAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ApplyPaymentApi {
        private final String paymentKey;
        private final ApplyPaymentRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ApplyPaymentApi(String paymentKey, ApplyPaymentRequest body) {
            this.paymentKey = paymentKey;
            this.body = body;
        }

        public ApplyPaymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ApplyPaymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ApplyPaymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ApplyPaymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ApplyPaymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ApplyPaymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ApplyPaymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentsApi.this.applyPaymentCall(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentResponse execute() throws ApiException {
            ApiResponse<PaymentResponse> localVarResp = PaymentsApi.this.applyPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentResponse> executeWithHttpInfo() throws ApiException {
            return PaymentsApi.this.applyPaymentWithHttpInfo(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentResponse> _callback) throws ApiException {
            return PaymentsApi.this.applyPaymentAsync(this.paymentKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

