/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class TaxationItemCreateRequest {
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_AMOUNT_EXEMPT = "amount_exempt";
    @SerializedName(value="amount_exempt")
    private BigDecimal amountExempt;
    public static final String SERIALIZED_NAME_INVOICE_ITEM_ID = "invoice_item_id";
    @SerializedName(value="invoice_item_id")
    private String invoiceItemId;
    public static final String SERIALIZED_NAME_JURISDICTION = "jurisdiction";
    @SerializedName(value="jurisdiction")
    private String jurisdiction;
    public static final String SERIALIZED_NAME_LOCATION_CODE = "location_code";
    @SerializedName(value="location_code")
    private String locationCode;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_CODE_NAME = "tax_code_name";
    @SerializedName(value="tax_code_name")
    private String taxCodeName;
    public static final String SERIALIZED_NAME_TAX_DATE = "tax_date";
    @SerializedName(value="tax_date")
    private LocalDate taxDate;
    public static final String SERIALIZED_NAME_TAX_RATE = "tax_rate";
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate;
    public static final String SERIALIZED_NAME_TAX_RATE_NAME = "tax_rate_name";
    @SerializedName(value="tax_rate_name")
    private String taxRateName;
    public static final String SERIALIZED_NAME_TAX_RATE_TYPE = "tax_rate_type";
    @SerializedName(value="tax_rate_type")
    private TaxRateTypeEnum taxRateType;
    public static final String SERIALIZED_NAME_SOURCE_TAX_ITEM_ID = "source_tax_item_id";
    @SerializedName(value="source_tax_item_id")
    private String sourceTaxItemId;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;

    public TaxationItemCreateRequest onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public TaxationItemCreateRequest amountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The calculated tax amount excluded due to the exemption.")
    public BigDecimal getAmountExempt() {
        return this.amountExempt;
    }

    public void setAmountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
    }

    public TaxationItemCreateRequest invoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the invoice item to which the taxation item applies. **This field is required if you are creating a credit memo or debit memo from an invoice, and is not applicable if you are creating an invoice.**.     ")
    public String getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public void setInvoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
    }

    public TaxationItemCreateRequest jurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The jurisdiction that applies the tax or VAT. This value is typically a state, province, county, or city.")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public TaxationItemCreateRequest locationCode(String locationCode) {
        this.locationCode = locationCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the location based on the value of the `tax_code` field.")
    public String getLocationCode() {
        return this.locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public TaxationItemCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the taxation item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxationItemCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The amount of the tax applied to the total price.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TaxationItemCreateRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxationItemCreateRequest taxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public String getTaxCodeName() {
        return this.taxCodeName;
    }

    public void setTaxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
    }

    public TaxationItemCreateRequest taxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", required=true, value="The date on which the tax is applied.")
    public LocalDate getTaxDate() {
        return this.taxDate;
    }

    public void setTaxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
    }

    public TaxationItemCreateRequest taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The amount of the tax applied to the total price.")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxationItemCreateRequest taxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the tax rate, such as sales tax or GST. This name is displayed on billing documents.")
    public String getTaxRateName() {
        return this.taxRateName;
    }

    public void setTaxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
    }

    public TaxationItemCreateRequest taxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the tax rate is an amount or a percentage.")
    public TaxRateTypeEnum getTaxRateType() {
        return this.taxRateType;
    }

    public void setTaxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
    }

    public TaxationItemCreateRequest sourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the taxation item of the invoice, from which the credit or debit memo is created. This field is only applicable when the `type` of the billing document is `credit_memo` and `debit_memo`.")
    public String getSourceTaxItemId() {
        return this.sourceTaxItemId;
    }

    public void setSourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
    }

    public TaxationItemCreateRequest taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxationItemCreateRequest taxationItemCreateRequest = (TaxationItemCreateRequest)o;
        return Objects.equals(this.onAccountAccount, taxationItemCreateRequest.onAccountAccount) && Objects.equals(this.amountExempt, taxationItemCreateRequest.amountExempt) && Objects.equals(this.invoiceItemId, taxationItemCreateRequest.invoiceItemId) && Objects.equals(this.jurisdiction, taxationItemCreateRequest.jurisdiction) && Objects.equals(this.locationCode, taxationItemCreateRequest.locationCode) && Objects.equals(this.name, taxationItemCreateRequest.name) && Objects.equals(this.amount, taxationItemCreateRequest.amount) && Objects.equals(this.taxCode, taxationItemCreateRequest.taxCode) && Objects.equals(this.taxCodeName, taxationItemCreateRequest.taxCodeName) && Objects.equals(this.taxDate, taxationItemCreateRequest.taxDate) && Objects.equals(this.taxRate, taxationItemCreateRequest.taxRate) && Objects.equals(this.taxRateName, taxationItemCreateRequest.taxRateName) && Objects.equals((Object)this.taxRateType, (Object)taxationItemCreateRequest.taxRateType) && Objects.equals(this.sourceTaxItemId, taxationItemCreateRequest.sourceTaxItemId) && Objects.equals(this.taxInclusive, taxationItemCreateRequest.taxInclusive);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.onAccountAccount, this.amountExempt, this.invoiceItemId, this.jurisdiction, this.locationCode, this.name, this.amount, this.taxCode, this.taxCodeName, this.taxDate, this.taxRate, this.taxRateName, this.taxRateType, this.sourceTaxItemId, this.taxInclusive});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxationItemCreateRequest {\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    amountExempt: ").append(this.toIndentedString(this.amountExempt)).append("\n");
        sb.append("    invoiceItemId: ").append(this.toIndentedString(this.invoiceItemId)).append("\n");
        sb.append("    jurisdiction: ").append(this.toIndentedString(this.jurisdiction)).append("\n");
        sb.append("    locationCode: ").append(this.toIndentedString(this.locationCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxCodeName: ").append(this.toIndentedString(this.taxCodeName)).append("\n");
        sb.append("    taxDate: ").append(this.toIndentedString(this.taxDate)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateName: ").append(this.toIndentedString(this.taxRateName)).append("\n");
        sb.append("    taxRateType: ").append(this.toIndentedString((Object)this.taxRateType)).append("\n");
        sb.append("    sourceTaxItemId: ").append(this.toIndentedString(this.sourceTaxItemId)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxRateTypeEnum {
        PERCENT("percent"),
        AMOUNT("amount"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TaxRateTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxRateTypeEnum fromValue(String value) {
            for (TaxRateTypeEnum b : TaxRateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TaxRateTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxRateTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxRateTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxRateTypeEnum.fromValue(value);
            }
        }
    }
}

