/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openapitools.client.ApiClient;
import org.openapitools.client.api.AccountsApi;
import org.openapitools.client.api.BillingDocumentsApi;
import org.openapitools.client.api.ContactsApi;
import org.openapitools.client.api.PaymentMethodsApi;
import org.openapitools.client.api.PaymentsApi;
import org.openapitools.client.api.PlansApi;
import org.openapitools.client.api.PricesApi;
import org.openapitools.client.api.ProductsApi;
import org.openapitools.client.api.SubscriptionPlansApi;
import org.openapitools.client.api.SubscriptionsApi;
import org.openapitools.client.api.WorkflowsApi;

public class ZuoraClient {
    private final String clientId;
    private final String clientSecret;
    private final String env;
    private final String baseUrl;
    private final ApiClient apiClient;
    Map<String, String> baseUrls = new HashMap<String, String>(){
        {
            this.put("LOCAL", "http://localhost:3000");
            this.put("SBX", "https://rest.apisandbox.zuora.com");
            this.put("CSBX", "https://rest.test.zuora.com");
            this.put("PT1", "https://rest.pt1.zuora.com");
        }
    };

    ZuoraClient(String clientId, String clientSecret, String env) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.env = env;
        this.baseUrl = env == "LOCAL" ? this.baseUrls.get(env) : this.baseUrls.get(env) + "/v2";
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.baseUrl);
    }

    private String getBearerToken() {
        String url = this.env == "LOCAL" ? this.baseUrls.get("SBX") : this.baseUrls.get(this.env);
        OkHttpClient client = new OkHttpClient();
        FormBody formBody = new FormBody.Builder().add("client_id", this.clientId).add("client_secret", this.clientSecret).add("grant_type", "client_credentials").build();
        Request request = new Request.Builder().url(url + "/oauth/token").post((RequestBody)formBody).build();
        String token = null;
        try {
            Response response = client.newCall(request).execute();
            String body = response.body().string();
            JsonObject json = JsonParser.parseString((String)body).getAsJsonObject();
            token = json.get("access_token").getAsString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return token;
    }

    void initialize() {
        String token = this.getBearerToken();
        this.apiClient.addDefaultHeader("Authorization", "Bearer " + token);
        this.apiClient.addDefaultHeader("x-donut-auth", "Bearer " + token);
    }

    AccountsApi accounts() {
        return new AccountsApi(this.apiClient);
    }

    ContactsApi contact() {
        return new ContactsApi(this.apiClient);
    }

    ProductsApi products() {
        return new ProductsApi(this.apiClient);
    }

    PricesApi prices() {
        return new PricesApi(this.apiClient);
    }

    PlansApi plans() {
        return new PlansApi(this.apiClient);
    }

    BillingDocumentsApi billingDocuments() {
        return new BillingDocumentsApi(this.apiClient);
    }

    PaymentMethodsApi paymentMethods() {
        return new PaymentMethodsApi(this.apiClient);
    }

    SubscriptionsApi subscriptions() {
        return new SubscriptionsApi(this.apiClient);
    }

    SubscriptionPlansApi subscriptionPlans() {
        return new SubscriptionPlansApi(this.apiClient);
    }

    PaymentsApi payments() {
        return new PaymentsApi(this.apiClient);
    }

    WorkflowsApi workflows() {
        return new WorkflowsApi(this.apiClient);
    }
}

