/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.BillRun;
import org.openapitools.client.model.BillRunCreateRequest;
import org.openapitools.client.model.BillRunListResponse;
import org.openapitools.client.model.BillRunPostRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;

public class BillRunsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BillRunsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillRunsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelBillRunCall(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/bill_runs/{bill_run_id}/cancel".replace("{bill_run_id}", this.localVarApiClient.escapeString(billRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run.fields[]", billRunFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelBillRunValidateBeforeCall(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunId == null) {
            throw new ApiException("Missing the required parameter 'billRunId' when calling cancelBillRun(Async)");
        }
        return this.cancelBillRunCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRun> cancelBillRunWithHttpInfo(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelBillRunValidateBeforeCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelBillRunAsync(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillRun> _callback) throws ApiException {
        Call localVarCall = this.cancelBillRunValidateBeforeCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelBillRunParams cancelBillRunParams(String billRunId) {
        return new CancelBillRunParams(billRunId);
    }

    public BillRun cancelBillRun(String billRunId) throws ApiException {
        CancelBillRunParams params = new CancelBillRunParams(billRunId);
        return this.executeCancelBillRunAPICall(params).getData();
    }

    public BillRun cancelBillRun(String billRunId, List<String> expand) throws ApiException {
        CancelBillRunParams params = new CancelBillRunParams(billRunId);
        params.expand(expand);
        return this.executeCancelBillRunAPICall(params).getData();
    }

    public BillRun cancelBillRun(String billRunId, List<String> expand, Headers headers) throws ApiException {
        CancelBillRunParams params = new CancelBillRunParams(billRunId).expand(expand).headers(headers);
        return this.executeCancelBillRunAPICall(params).getData();
    }

    public BillRun cancel(CancelBillRunParams params) throws ApiException {
        return this.executeCancelBillRunAPICall(params).getData();
    }

    public ApiResponse<BillRun> cancelWithHttpInfo(CancelBillRunParams params) throws ApiException {
        return this.executeCancelBillRunAPICall(params);
    }

    ApiResponse<BillRun> executeCancelBillRunAPICall(CancelBillRunParams params) throws ApiException {
        return this.cancelBillRunWithHttpInfo(params.billRunId, params.fields, params.billRunFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createBillRunCall(BillRunCreateRequest billRunCreateRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillRunCreateRequest localVarPostBody = billRunCreateRequest;
        String localVarPath = "/bill_runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run.fields[]", billRunFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBillRunValidateBeforeCall(BillRunCreateRequest billRunCreateRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'billRunCreateRequest' when calling createBillRun(Async)");
        }
        return this.createBillRunCall(billRunCreateRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRun> createBillRunWithHttpInfo(BillRunCreateRequest billRunCreateRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createBillRunValidateBeforeCall(billRunCreateRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createBillRunAsync(BillRunCreateRequest billRunCreateRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillRun> _callback) throws ApiException {
        Call localVarCall = this.createBillRunValidateBeforeCall(billRunCreateRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateBillRunParams createBillRunParams(BillRunCreateRequest billRunCreateRequest) {
        return new CreateBillRunParams(billRunCreateRequest);
    }

    public BillRun createBillRun(BillRunCreateRequest billRunCreateRequest) throws ApiException {
        CreateBillRunParams params = new CreateBillRunParams(billRunCreateRequest);
        return this.executeCreateBillRunAPICall(params).getData();
    }

    public BillRun createBillRun(BillRunCreateRequest billRunCreateRequest, List<String> expand) throws ApiException {
        CreateBillRunParams params = new CreateBillRunParams(billRunCreateRequest);
        params.expand(expand);
        return this.executeCreateBillRunAPICall(params).getData();
    }

    public BillRun createBillRun(BillRunCreateRequest billRunCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateBillRunParams params = new CreateBillRunParams(billRunCreateRequest).expand(expand).headers(headers);
        return this.executeCreateBillRunAPICall(params).getData();
    }

    public BillRun create(CreateBillRunParams params) throws ApiException {
        return this.executeCreateBillRunAPICall(params).getData();
    }

    public ApiResponse<BillRun> createWithHttpInfo(CreateBillRunParams params) throws ApiException {
        return this.executeCreateBillRunAPICall(params);
    }

    ApiResponse<BillRun> executeCreateBillRunAPICall(CreateBillRunParams params) throws ApiException {
        return this.createBillRunWithHttpInfo(params.billRunCreateRequest, params.fields, params.billRunFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteBillRunCall(String billRunId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/bill_runs/{bill_run_id}".replace("{bill_run_id}", this.localVarApiClient.escapeString(billRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBillRunValidateBeforeCall(String billRunId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunId == null) {
            throw new ApiException("Missing the required parameter 'billRunId' when calling deleteBillRun(Async)");
        }
        return this.deleteBillRunCall(billRunId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteBillRunWithHttpInfo(String billRunId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteBillRunValidateBeforeCall(billRunId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteBillRunAsync(String billRunId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBillRunValidateBeforeCall(billRunId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteBillRunParams deleteBillRunParams(String billRunId) {
        return new DeleteBillRunParams(billRunId);
    }

    public void deleteBillRun(String billRunId) throws ApiException {
        DeleteBillRunParams params = new DeleteBillRunParams(billRunId);
        this.executeDeleteBillRunAPICall(params);
    }

    public void deleteBillRun(String billRunId, Headers headers) throws ApiException {
        DeleteBillRunParams params = new DeleteBillRunParams(billRunId).headers(headers);
        this.executeDeleteBillRunAPICall(params);
    }

    public void delete(DeleteBillRunParams params) throws ApiException {
        this.executeDeleteBillRunAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteBillRunParams params) throws ApiException {
        return this.executeDeleteBillRunAPICall(params);
    }

    ApiResponse<Void> executeDeleteBillRunAPICall(DeleteBillRunParams params) throws ApiException {
        return this.deleteBillRunWithHttpInfo(params.billRunId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getBillRunCall(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/bill_runs/{bill_run_id}".replace("{bill_run_id}", this.localVarApiClient.escapeString(billRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run.fields[]", billRunFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillRunValidateBeforeCall(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunId == null) {
            throw new ApiException("Missing the required parameter 'billRunId' when calling getBillRun(Async)");
        }
        return this.getBillRunCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRun> getBillRunWithHttpInfo(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getBillRunValidateBeforeCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBillRunAsync(String billRunId, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillRun> _callback) throws ApiException {
        Call localVarCall = this.getBillRunValidateBeforeCall(billRunId, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBillRunParams getBillRunParams(String billRunId) {
        return new GetBillRunParams(billRunId);
    }

    public BillRun getBillRun(String billRunId) throws ApiException {
        GetBillRunParams params = new GetBillRunParams(billRunId);
        return this.executeGetBillRunAPICall(params).getData();
    }

    public BillRun getBillRun(String billRunId, List<String> expand) throws ApiException {
        GetBillRunParams params = new GetBillRunParams(billRunId);
        params.expand(expand);
        return this.executeGetBillRunAPICall(params).getData();
    }

    public BillRun getBillRun(String billRunId, List<String> expand, Headers headers) throws ApiException {
        GetBillRunParams params = new GetBillRunParams(billRunId).expand(expand).headers(headers);
        return this.executeGetBillRunAPICall(params).getData();
    }

    public BillRun get(GetBillRunParams params) throws ApiException {
        return this.executeGetBillRunAPICall(params).getData();
    }

    public ApiResponse<BillRun> getWithHttpInfo(GetBillRunParams params) throws ApiException {
        return this.executeGetBillRunAPICall(params);
    }

    ApiResponse<BillRun> executeGetBillRunAPICall(GetBillRunParams params) throws ApiException {
        return this.getBillRunWithHttpInfo(params.billRunId, params.fields, params.billRunFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getBillRunsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billRunFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/bill_runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run.fields[]", billRunFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillRunsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billRunFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getBillRunsCall(cursor, expand, filter, sort, pageSize, fields, billRunFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRunListResponse> getBillRunsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billRunFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getBillRunsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, billRunFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRunListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBillRunsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> billRunFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillRunListResponse> _callback) throws ApiException {
        Call localVarCall = this.getBillRunsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, billRunFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRunListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBillRunsParams getBillRunsParams() {
        return new GetBillRunsParams();
    }

    public BillRunListResponse getBillRuns() throws ApiException {
        GetBillRunsParams params = new GetBillRunsParams();
        return this.executeGetBillRunsAPICall(params).getData();
    }

    public BillRunListResponse getBillRuns(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetBillRunsParams params = new GetBillRunsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetBillRunsAPICall(params).getData();
    }

    public BillRunListResponse getBillRuns(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetBillRunsParams params = new GetBillRunsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetBillRunsAPICall(params).getData();
    }

    public BillRunListResponse list(GetBillRunsParams params) throws ApiException {
        return this.executeGetBillRunsAPICall(params).getData();
    }

    public ApiResponse<BillRunListResponse> listWithHttpInfo(GetBillRunsParams params) throws ApiException {
        return this.executeGetBillRunsAPICall(params);
    }

    ApiResponse<BillRunListResponse> executeGetBillRunsAPICall(GetBillRunsParams params) throws ApiException {
        return this.getBillRunsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.billRunFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call postBillRunCall(String billRunId, BillRunPostRequest billRunPostRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillRunPostRequest localVarPostBody = billRunPostRequest;
        String localVarPath = "/bill_runs/{bill_run_id}/post".replace("{bill_run_id}", this.localVarApiClient.escapeString(billRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run.fields[]", billRunFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postBillRunValidateBeforeCall(String billRunId, BillRunPostRequest billRunPostRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunId == null) {
            throw new ApiException("Missing the required parameter 'billRunId' when calling postBillRun(Async)");
        }
        if (billRunPostRequest == null) {
            throw new ApiException("Missing the required parameter 'billRunPostRequest' when calling postBillRun(Async)");
        }
        return this.postBillRunCall(billRunId, billRunPostRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRun> postBillRunWithHttpInfo(String billRunId, BillRunPostRequest billRunPostRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postBillRunValidateBeforeCall(billRunId, billRunPostRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postBillRunAsync(String billRunId, BillRunPostRequest billRunPostRequest, List<String> fields, List<String> billRunFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<BillRun> _callback) throws ApiException {
        Call localVarCall = this.postBillRunValidateBeforeCall(billRunId, billRunPostRequest, fields, billRunFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostBillRunParams postBillRunParams(String billRunId, BillRunPostRequest billRunPostRequest) {
        return new PostBillRunParams(billRunId, billRunPostRequest);
    }

    public BillRun postBillRun(String billRunId, BillRunPostRequest billRunPostRequest) throws ApiException {
        PostBillRunParams params = new PostBillRunParams(billRunId, billRunPostRequest);
        return this.executePostBillRunAPICall(params).getData();
    }

    public BillRun postBillRun(String billRunId, BillRunPostRequest billRunPostRequest, List<String> expand) throws ApiException {
        PostBillRunParams params = new PostBillRunParams(billRunId, billRunPostRequest);
        params.expand(expand);
        return this.executePostBillRunAPICall(params).getData();
    }

    public BillRun postBillRun(String billRunId, BillRunPostRequest billRunPostRequest, List<String> expand, Headers headers) throws ApiException {
        PostBillRunParams params = new PostBillRunParams(billRunId, billRunPostRequest).expand(expand).headers(headers);
        return this.executePostBillRunAPICall(params).getData();
    }

    public BillRun post(PostBillRunParams params) throws ApiException {
        return this.executePostBillRunAPICall(params).getData();
    }

    public ApiResponse<BillRun> postWithHttpInfo(PostBillRunParams params) throws ApiException {
        return this.executePostBillRunAPICall(params);
    }

    ApiResponse<BillRun> executePostBillRunAPICall(PostBillRunParams params) throws ApiException {
        return this.postBillRunWithHttpInfo(params.billRunId, params.billRunPostRequest, params.fields, params.billRunFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class PostBillRunParams {
        private final String billRunId;
        private final BillRunPostRequest billRunPostRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PostBillRunParams(String billRunId, BillRunPostRequest billRunPostRequest) {
            this.billRunId = billRunId;
            this.billRunPostRequest = billRunPostRequest;
        }

        public PostBillRunParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PostBillRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PostBillRunParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PostBillRunParams billRunFields(List<String> billRunFields) {
            this.billRunFields = billRunFields;
            return this;
        }

        public PostBillRunParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PostBillRunParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PostBillRunParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetBillRunsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> billRunFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetBillRunsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetBillRunsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetBillRunsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetBillRunsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetBillRunsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetBillRunsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetBillRunsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetBillRunsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetBillRunsParams billRunFields(List<String> billRunFields) {
            this.billRunFields = billRunFields;
            return this;
        }
    }

    public static class GetBillRunParams {
        private final String billRunId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetBillRunParams(String billRunId) {
            this.billRunId = billRunId;
        }

        public GetBillRunParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetBillRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetBillRunParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetBillRunParams billRunFields(List<String> billRunFields) {
            this.billRunFields = billRunFields;
            return this;
        }

        public GetBillRunParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetBillRunParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetBillRunParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteBillRunParams {
        private final String billRunId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteBillRunParams(String billRunId) {
            this.billRunId = billRunId;
        }

        public DeleteBillRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateBillRunParams {
        private final BillRunCreateRequest billRunCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateBillRunParams(BillRunCreateRequest billRunCreateRequest) {
            this.billRunCreateRequest = billRunCreateRequest;
        }

        public CreateBillRunParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateBillRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateBillRunParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateBillRunParams billRunFields(List<String> billRunFields) {
            this.billRunFields = billRunFields;
            return this;
        }

        public CreateBillRunParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateBillRunParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateBillRunParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelBillRunParams {
        private final String billRunId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelBillRunParams(String billRunId) {
            this.billRunId = billRunId;
        }

        public CancelBillRunParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelBillRunParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelBillRunParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelBillRunParams billRunFields(List<String> billRunFields) {
            this.billRunFields = billRunFields;
            return this;
        }

        public CancelBillRunParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelBillRunParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelBillRunParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

