/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.ChargeModelRule;
import com.zuora.sdk.internal.pricing.DiscountFixedAmount;
import com.zuora.sdk.internal.pricing.DiscountPercentage;
import com.zuora.sdk.internal.pricing.FlatFee;
import com.zuora.sdk.internal.pricing.HighWaterMarkTiered;
import com.zuora.sdk.internal.pricing.HighWaterMarkVolume;
import com.zuora.sdk.internal.pricing.MultiAttribute;
import com.zuora.sdk.internal.pricing.Overage;
import com.zuora.sdk.internal.pricing.PerUnit;
import com.zuora.sdk.internal.pricing.Tiered;
import com.zuora.sdk.internal.pricing.TieredWithOverage;
import com.zuora.sdk.internal.pricing.Volume;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class RuleProcessor {
    public static List<ChargeModelRule> chargeModelRules = RuleProcessor.populateRules();
    final ChargeType chargeType;
    private final PriceCreateRequest priceCreateRequest;
    List<ChargeModelRule> evaluatedRules = new ArrayList<ChargeModelRule>();

    public RuleProcessor(PriceCreateRequest priceCreateRequest) {
        this.priceCreateRequest = priceCreateRequest;
        this.chargeType = this.getChargeType(priceCreateRequest);
    }

    static List<ChargeModelRule> populateRules() {
        ArrayList<ChargeModelRule> chargeModelRules = new ArrayList<ChargeModelRule>();
        chargeModelRules.add(new PerUnit());
        chargeModelRules.add(new Tiered());
        chargeModelRules.add(new FlatFee());
        chargeModelRules.add(new Overage());
        chargeModelRules.add(new Volume());
        chargeModelRules.add(new TieredWithOverage());
        chargeModelRules.add(new DiscountFixedAmount());
        chargeModelRules.add(new DiscountPercentage());
        chargeModelRules.add(new HighWaterMarkTiered());
        chargeModelRules.add(new HighWaterMarkVolume());
        chargeModelRules.add(new MultiAttribute());
        return chargeModelRules;
    }

    public List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTiers() {
        for (ChargeModelRule rule : chargeModelRules) {
            if (!this.priceCreateRequest.getChargeModel().equals((Object)rule.getChargeModel())) continue;
            return rule.getZTiers(this.priceCreateRequest);
        }
        return null;
    }

    public static Double getAmounts(PriceEnum.ChargeModel chargeModel, List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        for (ChargeModelRule rule : chargeModelRules) {
            if (!chargeModel.equals((Object)rule.getChargeModel())) continue;
            return rule.getAmountFromRatePlanCharge(rule.getNodeFromEdge2(zTiers));
        }
        return null;
    }

    public void process() {
        this.check().apply();
    }

    RuleProcessor check() {
        this.checkRules();
        return this;
    }

    private boolean validate() {
        if (this.evaluatedRules.size() == 1) {
            return true;
        }
        String violationMessage = "No identified Charge Models";
        if (!this.evaluatedRules.isEmpty()) {
            violationMessage = "Multiple charge models identified: " + this.evaluatedRules.stream().map(rule -> this.chargeType.name() + "-" + (Object)((Object)rule.getChargeModel())).collect(Collectors.joining(", "));
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.RuleRestriction, "ChargeModel", violationMessage).build();
    }

    void apply() {
        if (this.validate()) {
            this.priceCreateRequest.setChargeModel(this.evaluatedRules.get(0).getChargeModel());
            this.priceCreateRequest.setChargeType(this.chargeType);
        }
    }

    protected void checkRules() {
        this.validatePrice();
        ChargeType chargeType = this.getChargeType(this.priceCreateRequest);
        for (ChargeModelRule rule : chargeModelRules) {
            if (!rule.check(this.priceCreateRequest)) continue;
            PriceEnum.ChargeModel chargeModel = rule.getChargeModel();
            if (!rule.getChargeTypes().contains(chargeType)) {
                throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.RuleRestriction, "ChargeModel", (Object)((Object)chargeModel) + " is not supported for " + chargeType).build();
            }
            this.evaluatedRules.add(rule);
        }
    }

    protected ChargeType getChargeType(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest.getRecurring() == null) {
            return ChargeType.ONE_TIME;
        }
        if (priceCreateRequest.getRecurring().isUsage()) {
            return ChargeType.USAGE;
        }
        return ChargeType.RECURRING;
    }

    protected void validatePrice() {
        boolean hasUnitAmounts;
        ArrayList<InvalidRequestException.Violation> violations = new ArrayList<InvalidRequestException.Violation>();
        boolean hasTiers = !this.priceCreateRequest.getTiers().isEmpty();
        boolean hasAmounts = !this.priceCreateRequest.getAmounts().isEmpty();
        boolean bl = hasUnitAmounts = !this.priceCreateRequest.getUnitAmounts().isEmpty();
        if (hasTiers && hasAmounts) {
            violations.add(new InvalidRequestException.Violation(InvalidRequestException.Reason.RuleRestriction, "tiers", "Amounts cannot be populated if the price contains tiers"));
        }
        if (hasUnitAmounts && hasAmounts) {
            violations.add(new InvalidRequestException.Violation(InvalidRequestException.Reason.RuleRestriction, "unitAmount", "Unit Amounts cannot be populated if the price contains amount"));
            violations.add(new InvalidRequestException.Violation(InvalidRequestException.Reason.RuleRestriction, "amount", "Amounts cannot be populated if the price contains unitAmount"));
        }
        if (!violations.isEmpty()) {
            throw InvalidRequestException.builder().addViolations(violations).build();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    static List<ChargeModelRule> getChargeModelRules() {
        return chargeModelRules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    List<ChargeModelRule> getEvaluatedRules() {
        return this.evaluatedRules;
    }
}

