/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Overage;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceTier;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.enums.ApplyDiscountTo;
import com.zuora.sdk.internal.models.enums.ChargeType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class Price {
    final String createdBy;
    final ZonedDateTime createTime;
    final String updatedBy;
    final ZonedDateTime updateTime;
    private PriceEnum.ChargeModel chargeModel;
    private ChargeType chargeType;
    String plan;
    Double precision;
    String id;
    private String recognizedRevenueAccountingCode;
    private String deferredRevenueAccountingCode;
    private PriceEnum.Event startEvent;
    private String name;
    private String description;
    private String taxCode;
    private boolean taxInclusive;
    private Recurring recurring;
    private List<PriceTier> tiers;
    private PriceEnum.TiersMode tiersMode;
    private String unitOfMeasure;
    private double quantity;
    private double minQuantity;
    private double maxQuantity;
    private PriceEnum.PriceBaseInterval priceBaseInterval;
    private Overage overage;
    private Map<Currency, Double> unitAmounts;
    private Map<Currency, Double> amounts;
    private Double percentAmount;
    private EnumSet<ApplyDiscountTo> applyDiscountTo;
    private PriceEnum.DiscountLevel discountLevel;
    private Map<String, Object> customFields;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static PriceBuilder builder() {
        return new PriceBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceBuilder toBuilder() {
        PriceBuilder builder = new PriceBuilder().createdBy(this.createdBy).createTime(this.createTime).updatedBy(this.updatedBy).updateTime(this.updateTime).chargeModel(this.chargeModel).chargeType(this.chargeType).plan(this.plan).precision(this.precision).id(this.id).recognizedRevenueAccountingCode(this.recognizedRevenueAccountingCode).deferredRevenueAccountingCode(this.deferredRevenueAccountingCode).startEvent(this.startEvent).name(this.name).description(this.description).taxCode(this.taxCode).taxInclusive(this.taxInclusive).recurring(this.recurring).tiersMode(this.tiersMode).unitOfMeasure(this.unitOfMeasure).quantity(this.quantity).minQuantity(this.minQuantity).maxQuantity(this.maxQuantity).priceBaseInterval(this.priceBaseInterval).overage(this.overage).percentAmount(this.percentAmount).applyDiscountTo(this.applyDiscountTo).discountLevel(this.discountLevel);
        if (this.tiers != null) {
            builder.tiers(this.tiers);
        }
        if (this.unitAmounts != null) {
            builder.unitAmounts(this.unitAmounts);
        }
        if (this.amounts != null) {
            builder.amounts(this.amounts);
        }
        if (this.customFields != null) {
            builder.customFields(this.customFields);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.ChargeModel getChargeModel() {
        return this.chargeModel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChargeType getChargeType() {
        return this.chargeType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPlan() {
        return this.plan;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getPrecision() {
        return this.precision;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRecognizedRevenueAccountingCode() {
        return this.recognizedRevenueAccountingCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDeferredRevenueAccountingCode() {
        return this.deferredRevenueAccountingCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.Event getStartEvent() {
        return this.startEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTaxCode() {
        return this.taxCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTaxInclusive() {
        return this.taxInclusive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Recurring getRecurring() {
        return this.recurring;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<PriceTier> getTiers() {
        return this.tiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.TiersMode getTiersMode() {
        return this.tiersMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getQuantity() {
        return this.quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMinQuantity() {
        return this.minQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMaxQuantity() {
        return this.maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.PriceBaseInterval getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Overage getOverage() {
        return this.overage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getUnitAmounts() {
        return this.unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getAmounts() {
        return this.amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getPercentAmount() {
        return this.percentAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnumSet<ApplyDiscountTo> getApplyDiscountTo() {
        return this.applyDiscountTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.DiscountLevel getDiscountLevel() {
        return this.discountLevel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChargeType(ChargeType chargeType) {
        this.chargeType = chargeType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRecognizedRevenueAccountingCode(String recognizedRevenueAccountingCode2) {
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDeferredRevenueAccountingCode(String deferredRevenueAccountingCode2) {
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStartEvent(PriceEnum.Event startEvent) {
        this.startEvent = startEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTaxInclusive(boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTiers(List<PriceTier> tiers) {
        this.tiers = tiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTiersMode(PriceEnum.TiersMode tiersMode) {
        this.tiersMode = tiersMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMinQuantity(double minQuantity) {
        this.minQuantity = minQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxQuantity(double maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPriceBaseInterval(PriceEnum.PriceBaseInterval priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOverage(Overage overage) {
        this.overage = overage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUnitAmounts(Map<Currency, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmounts(Map<Currency, Double> amounts) {
        this.amounts = amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPercentAmount(Double percentAmount) {
        this.percentAmount = percentAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setApplyDiscountTo(EnumSet<ApplyDiscountTo> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDiscountLevel(PriceEnum.DiscountLevel discountLevel) {
        this.discountLevel = discountLevel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Price)) {
            return false;
        }
        Price other = (Price)o;
        if (this.isTaxInclusive() != other.isTaxInclusive()) {
            return false;
        }
        if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinQuantity(), other.getMinQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxQuantity(), other.getMaxQuantity()) != 0) {
            return false;
        }
        Double this$precision = this.getPrecision();
        Double other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Double this$percentAmount = this.getPercentAmount();
        Double other$percentAmount = other.getPercentAmount();
        if (this$percentAmount == null ? other$percentAmount != null : !((Object)this$percentAmount).equals(other$percentAmount)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$createTime = this.getCreateTime();
        ZonedDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        PriceEnum.ChargeModel this$chargeModel = this.getChargeModel();
        PriceEnum.ChargeModel other$chargeModel = other.getChargeModel();
        if (this$chargeModel == null ? other$chargeModel != null : !((Object)((Object)this$chargeModel)).equals((Object)other$chargeModel)) {
            return false;
        }
        ChargeType this$chargeType = this.getChargeType();
        ChargeType other$chargeType = other.getChargeType();
        if (this$chargeType == null ? other$chargeType != null : !this$chargeType.equals(other$chargeType)) {
            return false;
        }
        String this$plan = this.getPlan();
        String other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$recognizedRevenueAccountingCode = this.getRecognizedRevenueAccountingCode();
        String other$recognizedRevenueAccountingCode = other.getRecognizedRevenueAccountingCode();
        if (this$recognizedRevenueAccountingCode == null ? other$recognizedRevenueAccountingCode != null : !this$recognizedRevenueAccountingCode.equals(other$recognizedRevenueAccountingCode)) {
            return false;
        }
        String this$deferredRevenueAccountingCode = this.getDeferredRevenueAccountingCode();
        String other$deferredRevenueAccountingCode = other.getDeferredRevenueAccountingCode();
        if (this$deferredRevenueAccountingCode == null ? other$deferredRevenueAccountingCode != null : !this$deferredRevenueAccountingCode.equals(other$deferredRevenueAccountingCode)) {
            return false;
        }
        PriceEnum.Event this$startEvent = this.getStartEvent();
        PriceEnum.Event other$startEvent = other.getStartEvent();
        if (this$startEvent == null ? other$startEvent != null : !((Object)((Object)this$startEvent)).equals((Object)other$startEvent)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$taxCode = this.getTaxCode();
        String other$taxCode = other.getTaxCode();
        if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
            return false;
        }
        Recurring this$recurring = this.getRecurring();
        Recurring other$recurring = other.getRecurring();
        if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
            return false;
        }
        List<PriceTier> this$tiers = this.getTiers();
        List<PriceTier> other$tiers = other.getTiers();
        if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
            return false;
        }
        PriceEnum.TiersMode this$tiersMode = this.getTiersMode();
        PriceEnum.TiersMode other$tiersMode = other.getTiersMode();
        if (this$tiersMode == null ? other$tiersMode != null : !((Object)((Object)this$tiersMode)).equals((Object)other$tiersMode)) {
            return false;
        }
        String this$unitOfMeasure = this.getUnitOfMeasure();
        String other$unitOfMeasure = other.getUnitOfMeasure();
        if (this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure)) {
            return false;
        }
        PriceEnum.PriceBaseInterval this$priceBaseInterval = this.getPriceBaseInterval();
        PriceEnum.PriceBaseInterval other$priceBaseInterval = other.getPriceBaseInterval();
        if (this$priceBaseInterval == null ? other$priceBaseInterval != null : !((Object)((Object)this$priceBaseInterval)).equals((Object)other$priceBaseInterval)) {
            return false;
        }
        Overage this$overage = this.getOverage();
        Overage other$overage = other.getOverage();
        if (this$overage == null ? other$overage != null : !((Object)this$overage).equals(other$overage)) {
            return false;
        }
        Map<Currency, Double> this$unitAmounts = this.getUnitAmounts();
        Map<Currency, Double> other$unitAmounts = other.getUnitAmounts();
        if (this$unitAmounts == null ? other$unitAmounts != null : !((Object)this$unitAmounts).equals(other$unitAmounts)) {
            return false;
        }
        Map<Currency, Double> this$amounts = this.getAmounts();
        Map<Currency, Double> other$amounts = other.getAmounts();
        if (this$amounts == null ? other$amounts != null : !((Object)this$amounts).equals(other$amounts)) {
            return false;
        }
        EnumSet<ApplyDiscountTo> this$applyDiscountTo = this.getApplyDiscountTo();
        EnumSet<ApplyDiscountTo> other$applyDiscountTo = other.getApplyDiscountTo();
        if (this$applyDiscountTo == null ? other$applyDiscountTo != null : !((Object)this$applyDiscountTo).equals(other$applyDiscountTo)) {
            return false;
        }
        PriceEnum.DiscountLevel this$discountLevel = this.getDiscountLevel();
        PriceEnum.DiscountLevel other$discountLevel = other.getDiscountLevel();
        if (this$discountLevel == null ? other$discountLevel != null : !((Object)((Object)this$discountLevel)).equals((Object)other$discountLevel)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTaxInclusive() ? 79 : 97);
        long $quantity = Double.doubleToLongBits(this.getQuantity());
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        long $minQuantity = Double.doubleToLongBits(this.getMinQuantity());
        result = result * 59 + (int)($minQuantity >>> 32 ^ $minQuantity);
        long $maxQuantity = Double.doubleToLongBits(this.getMaxQuantity());
        result = result * 59 + (int)($maxQuantity >>> 32 ^ $maxQuantity);
        Double $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Double $percentAmount = this.getPercentAmount();
        result = result * 59 + ($percentAmount == null ? 43 : ((Object)$percentAmount).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        PriceEnum.ChargeModel $chargeModel = this.getChargeModel();
        result = result * 59 + ($chargeModel == null ? 43 : ((Object)((Object)$chargeModel)).hashCode());
        ChargeType $chargeType = this.getChargeType();
        result = result * 59 + ($chargeType == null ? 43 : $chargeType.hashCode());
        String $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $recognizedRevenueAccountingCode = this.getRecognizedRevenueAccountingCode();
        result = result * 59 + ($recognizedRevenueAccountingCode == null ? 43 : $recognizedRevenueAccountingCode.hashCode());
        String $deferredRevenueAccountingCode = this.getDeferredRevenueAccountingCode();
        result = result * 59 + ($deferredRevenueAccountingCode == null ? 43 : $deferredRevenueAccountingCode.hashCode());
        PriceEnum.Event $startEvent = this.getStartEvent();
        result = result * 59 + ($startEvent == null ? 43 : ((Object)((Object)$startEvent)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $taxCode = this.getTaxCode();
        result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
        Recurring $recurring = this.getRecurring();
        result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
        List<PriceTier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        PriceEnum.TiersMode $tiersMode = this.getTiersMode();
        result = result * 59 + ($tiersMode == null ? 43 : ((Object)((Object)$tiersMode)).hashCode());
        String $unitOfMeasure = this.getUnitOfMeasure();
        result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
        PriceEnum.PriceBaseInterval $priceBaseInterval = this.getPriceBaseInterval();
        result = result * 59 + ($priceBaseInterval == null ? 43 : ((Object)((Object)$priceBaseInterval)).hashCode());
        Overage $overage = this.getOverage();
        result = result * 59 + ($overage == null ? 43 : ((Object)$overage).hashCode());
        Map<Currency, Double> $unitAmounts = this.getUnitAmounts();
        result = result * 59 + ($unitAmounts == null ? 43 : ((Object)$unitAmounts).hashCode());
        Map<Currency, Double> $amounts = this.getAmounts();
        result = result * 59 + ($amounts == null ? 43 : ((Object)$amounts).hashCode());
        EnumSet<ApplyDiscountTo> $applyDiscountTo = this.getApplyDiscountTo();
        result = result * 59 + ($applyDiscountTo == null ? 43 : ((Object)$applyDiscountTo).hashCode());
        PriceEnum.DiscountLevel $discountLevel = this.getDiscountLevel();
        result = result * 59 + ($discountLevel == null ? 43 : ((Object)((Object)$discountLevel)).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Price(String createdBy, ZonedDateTime createTime, String updatedBy, ZonedDateTime updateTime, PriceEnum.ChargeModel chargeModel, ChargeType chargeType, String plan, Double precision, String id, String recognizedRevenueAccountingCode2, String deferredRevenueAccountingCode2, PriceEnum.Event startEvent, String name, String description, String taxCode, boolean taxInclusive, Recurring recurring, List<PriceTier> tiers, PriceEnum.TiersMode tiersMode, String unitOfMeasure, double quantity, double minQuantity, double maxQuantity, PriceEnum.PriceBaseInterval priceBaseInterval, Overage overage, Map<Currency, Double> unitAmounts, Map<Currency, Double> amounts, Double percentAmount, EnumSet<ApplyDiscountTo> applyDiscountTo, PriceEnum.DiscountLevel discountLevel, Map<String, Object> customFields) {
        this.createdBy = createdBy;
        this.createTime = createTime;
        this.updatedBy = updatedBy;
        this.updateTime = updateTime;
        this.chargeModel = chargeModel;
        this.chargeType = chargeType;
        this.plan = plan;
        this.precision = precision;
        this.id = id;
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode2;
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode2;
        this.startEvent = startEvent;
        this.name = name;
        this.description = description;
        this.taxCode = taxCode;
        this.taxInclusive = taxInclusive;
        this.recurring = recurring;
        this.tiers = tiers;
        this.tiersMode = tiersMode;
        this.unitOfMeasure = unitOfMeasure;
        this.quantity = quantity;
        this.minQuantity = minQuantity;
        this.maxQuantity = maxQuantity;
        this.priceBaseInterval = priceBaseInterval;
        this.overage = overage;
        this.unitAmounts = unitAmounts;
        this.amounts = amounts;
        this.percentAmount = percentAmount;
        this.applyDiscountTo = applyDiscountTo;
        this.discountLevel = discountLevel;
        this.customFields = customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Price(createdBy=" + this.getCreatedBy() + ", createTime=" + this.getCreateTime() + ", updatedBy=" + this.getUpdatedBy() + ", updateTime=" + this.getUpdateTime() + ", chargeModel=" + (Object)((Object)this.getChargeModel()) + ", chargeType=" + this.getChargeType() + ", precision=" + this.getPrecision() + ", id=" + this.getId() + ", recognizedRevenueAccountingCode=" + this.getRecognizedRevenueAccountingCode() + ", deferredRevenueAccountingCode=" + this.getDeferredRevenueAccountingCode() + ", startEvent=" + (Object)((Object)this.getStartEvent()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", taxCode=" + this.getTaxCode() + ", taxInclusive=" + this.isTaxInclusive() + ", recurring=" + this.getRecurring() + ", tiers=" + this.getTiers() + ", tiersMode=" + (Object)((Object)this.getTiersMode()) + ", unitOfMeasure=" + this.getUnitOfMeasure() + ", quantity=" + this.getQuantity() + ", minQuantity=" + this.getMinQuantity() + ", maxQuantity=" + this.getMaxQuantity() + ", priceBaseInterval=" + (Object)((Object)this.getPriceBaseInterval()) + ", overage=" + this.getOverage() + ", unitAmounts=" + this.getUnitAmounts() + ", amounts=" + this.getAmounts() + ", percentAmount=" + this.getPercentAmount() + ", applyDiscountTo=" + this.getApplyDiscountTo() + ", discountLevel=" + (Object)((Object)this.getDiscountLevel()) + ", customFields=" + this.getCustomFields() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    void setChargeModel(PriceEnum.ChargeModel chargeModel) {
        this.chargeModel = chargeModel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Price setPlan(String plan) {
        this.plan = plan;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Price setId(String id) {
        this.id = id;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class PriceBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String createdBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime createTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String updatedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime updateTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.ChargeModel chargeModel;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChargeType chargeType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String plan;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double precision;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String recognizedRevenueAccountingCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String deferredRevenueAccountingCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.Event startEvent;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String taxCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean taxInclusive;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Recurring recurring;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<PriceTier> tiers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.TiersMode tiersMode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String unitOfMeasure;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double quantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double minQuantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double maxQuantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.PriceBaseInterval priceBaseInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Overage overage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> unitAmounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> unitAmounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> amounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> amounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double percentAmount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private EnumSet<ApplyDiscountTo> applyDiscountTo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.DiscountLevel discountLevel;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<String> customFields$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Object> customFields$value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PriceBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder createTime(ZonedDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder chargeModel(PriceEnum.ChargeModel chargeModel) {
            this.chargeModel = chargeModel;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder chargeType(ChargeType chargeType) {
            this.chargeType = chargeType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder recognizedRevenueAccountingCode(String recognizedRevenueAccountingCode2) {
            this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder deferredRevenueAccountingCode(String deferredRevenueAccountingCode2) {
            this.deferredRevenueAccountingCode = deferredRevenueAccountingCode2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder startEvent(PriceEnum.Event startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder taxInclusive(boolean taxInclusive) {
            this.taxInclusive = taxInclusive;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder recurring(Recurring recurring) {
            this.recurring = recurring;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder tier(PriceTier tier) {
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.add(tier);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder tiers(Collection<? extends PriceTier> tiers) {
            if (tiers == null) {
                throw new NullPointerException("tiers cannot be null");
            }
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.addAll(tiers);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder clearTiers() {
            if (this.tiers != null) {
                this.tiers.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder tiersMode(PriceEnum.TiersMode tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder minQuantity(double minQuantity) {
            this.minQuantity = minQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder maxQuantity(double maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder priceBaseInterval(PriceEnum.PriceBaseInterval priceBaseInterval) {
            this.priceBaseInterval = priceBaseInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder overage(Overage overage) {
            this.overage = overage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder unitAmount(Currency unitAmountKey, Double unitAmountValue) {
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            this.unitAmounts$key.add(unitAmountKey);
            this.unitAmounts$value.add(unitAmountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder unitAmounts(Map<? extends Currency, ? extends Double> unitAmounts) {
            if (unitAmounts == null) {
                throw new NullPointerException("unitAmounts cannot be null");
            }
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : unitAmounts.entrySet()) {
                this.unitAmounts$key.add($lombokEntry.getKey());
                this.unitAmounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder clearUnitAmounts() {
            if (this.unitAmounts$key != null) {
                this.unitAmounts$key.clear();
                this.unitAmounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder amount(Currency amountKey, Double amountValue) {
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            this.amounts$key.add(amountKey);
            this.amounts$value.add(amountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder amounts(Map<? extends Currency, ? extends Double> amounts) {
            if (amounts == null) {
                throw new NullPointerException("amounts cannot be null");
            }
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : amounts.entrySet()) {
                this.amounts$key.add($lombokEntry.getKey());
                this.amounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder clearAmounts() {
            if (this.amounts$key != null) {
                this.amounts$key.clear();
                this.amounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder percentAmount(Double percentAmount) {
            this.percentAmount = percentAmount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder applyDiscountTo(EnumSet<ApplyDiscountTo> applyDiscountTo) {
            this.applyDiscountTo = applyDiscountTo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder discountLevel(PriceEnum.DiscountLevel discountLevel) {
            this.discountLevel = discountLevel;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder customField(String customFieldKey, Object customFieldValue) {
            if (this.customFields$key == null) {
                this.customFields$key = new ArrayList();
                this.customFields$value = new ArrayList();
            }
            this.customFields$key.add(customFieldKey);
            this.customFields$value.add(customFieldValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder customFields(Map<? extends String, ? extends Object> customFields) {
            if (customFields == null) {
                throw new NullPointerException("customFields cannot be null");
            }
            if (this.customFields$key == null) {
                this.customFields$key = new ArrayList();
                this.customFields$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : customFields.entrySet()) {
                this.customFields$key.add($lombokEntry.getKey());
                this.customFields$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriceBuilder clearCustomFields() {
            if (this.customFields$key != null) {
                this.customFields$key.clear();
                this.customFields$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Price build() {
            Map<Object, Object> customFields;
            Map<Object, Object> amounts;
            Map<Object, Object> unitAmounts;
            List<PriceTier> tiers;
            switch (this.tiers == null ? 0 : this.tiers.size()) {
                case 0: {
                    tiers = Collections.emptyList();
                    break;
                }
                case 1: {
                    tiers = Collections.singletonList(this.tiers.get(0));
                    break;
                }
                default: {
                    tiers = Collections.unmodifiableList(new ArrayList<PriceTier>(this.tiers));
                }
            }
            switch (this.unitAmounts$key == null ? 0 : this.unitAmounts$key.size()) {
                case 0: {
                    unitAmounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    unitAmounts = Collections.singletonMap(this.unitAmounts$key.get(0), this.unitAmounts$value.get(0));
                    break;
                }
                default: {
                    unitAmounts = new LinkedHashMap(this.unitAmounts$key.size() < 0x40000000 ? 1 + this.unitAmounts$key.size() + (this.unitAmounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.unitAmounts$key.size(); ++$i) {
                        unitAmounts.put(this.unitAmounts$key.get($i), this.unitAmounts$value.get($i));
                    }
                    unitAmounts = Collections.unmodifiableMap(unitAmounts);
                }
            }
            switch (this.amounts$key == null ? 0 : this.amounts$key.size()) {
                case 0: {
                    amounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    amounts = Collections.singletonMap(this.amounts$key.get(0), this.amounts$value.get(0));
                    break;
                }
                default: {
                    amounts = new LinkedHashMap(this.amounts$key.size() < 0x40000000 ? 1 + this.amounts$key.size() + (this.amounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.amounts$key.size(); ++$i) {
                        amounts.put(this.amounts$key.get($i), this.amounts$value.get($i));
                    }
                    amounts = Collections.unmodifiableMap(amounts);
                }
            }
            switch (this.customFields$key == null ? 0 : this.customFields$key.size()) {
                case 0: {
                    customFields = Collections.emptyMap();
                    break;
                }
                case 1: {
                    customFields = Collections.singletonMap(this.customFields$key.get(0), this.customFields$value.get(0));
                    break;
                }
                default: {
                    customFields = new LinkedHashMap(this.customFields$key.size() < 0x40000000 ? 1 + this.customFields$key.size() + (this.customFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.customFields$key.size(); ++$i) {
                        customFields.put(this.customFields$key.get($i), this.customFields$value.get($i));
                    }
                    customFields = Collections.unmodifiableMap(customFields);
                }
            }
            return new Price(this.createdBy, this.createTime, this.updatedBy, this.updateTime, this.chargeModel, this.chargeType, this.plan, this.precision, this.id, this.recognizedRevenueAccountingCode, this.deferredRevenueAccountingCode, this.startEvent, this.name, this.description, this.taxCode, this.taxInclusive, this.recurring, tiers, this.tiersMode, this.unitOfMeasure, this.quantity, this.minQuantity, this.maxQuantity, this.priceBaseInterval, this.overage, unitAmounts, amounts, this.percentAmount, this.applyDiscountTo, this.discountLevel, customFields);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Price.PriceBuilder(createdBy=" + this.createdBy + ", createTime=" + this.createTime + ", updatedBy=" + this.updatedBy + ", updateTime=" + this.updateTime + ", chargeModel=" + (Object)((Object)this.chargeModel) + ", chargeType=" + this.chargeType + ", plan=" + this.plan + ", precision=" + this.precision + ", id=" + this.id + ", recognizedRevenueAccountingCode=" + this.recognizedRevenueAccountingCode + ", deferredRevenueAccountingCode=" + this.deferredRevenueAccountingCode + ", startEvent=" + (Object)((Object)this.startEvent) + ", name=" + this.name + ", description=" + this.description + ", taxCode=" + this.taxCode + ", taxInclusive=" + this.taxInclusive + ", recurring=" + this.recurring + ", tiers=" + this.tiers + ", tiersMode=" + (Object)((Object)this.tiersMode) + ", unitOfMeasure=" + this.unitOfMeasure + ", quantity=" + this.quantity + ", minQuantity=" + this.minQuantity + ", maxQuantity=" + this.maxQuantity + ", priceBaseInterval=" + (Object)((Object)this.priceBaseInterval) + ", overage=" + this.overage + ", unitAmounts$key=" + this.unitAmounts$key + ", unitAmounts$value=" + this.unitAmounts$value + ", amounts$key=" + this.amounts$key + ", amounts$value=" + this.amounts$value + ", percentAmount=" + this.percentAmount + ", applyDiscountTo=" + this.applyDiscountTo + ", discountLevel=" + (Object)((Object)this.discountLevel) + ", customFields$key=" + this.customFields$key + ", customFields$value=" + this.customFields$value + ")";
        }
    }
}

