/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.internal.Tools;
import com.zuora.sdk.internal.apis.data.ProxyGetProductRatePlan;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
abstract class PlanMapper {
    PlanMapper() {
    }

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    abstract ZProductRatePlan.Builder toApi(Plan var1);

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    abstract ZProductRatePlan.Builder toApi(PlanCreateRequest var1);

    Plan fromApi(ProxyGetProductRatePlan proxyGetProductRatePlan, LocalDate today) {
        LocalDate planStartDate = LocalDate.parse(proxyGetProductRatePlan.effectiveStartDate());
        LocalDate planEndDate = LocalDate.parse(proxyGetProductRatePlan.effectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(proxyGetProductRatePlan.createdDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(proxyGetProductRatePlan.updatedDate());
        boolean planActive = Tools.isDateInRangeInclusive((LocalDate)today, (LocalDate)planStartDate, (LocalDate)planEndDate);
        return Plan.builder().id(proxyGetProductRatePlan.id()).product(proxyGetProductRatePlan.productId()).active(planActive).name(proxyGetProductRatePlan.name()).updatedBy(proxyGetProductRatePlan.updatedById()).updateTime(updateTime).createdBy(proxyGetProductRatePlan.createdById()).createTime(createTime).startDate(planStartDate).endDate(planEndDate).activeCurrencies(proxyGetProductRatePlan.activeCurrencies()).customFields(proxyGetProductRatePlan.productRatePlanObjectCustomFields()).description(proxyGetProductRatePlan.description()).build();
    }
}

