/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Account;
import com.zuora.sdk.AccountCreateRequest;
import com.zuora.sdk.Address;
import com.zuora.sdk.BillingDocumentSettings;
import com.zuora.sdk.Contact;
import com.zuora.sdk.ContactCreateRequest;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.Product;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.TaxCertificate;
import com.zuora.sdk.TaxIdentifier;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.enums.TaxCertificateStatus;
import com.zuora.sdk.internal.AccountsQuery;
import com.zuora.sdk.internal.ProductRatePlanByIdQuery;
import com.zuora.sdk.internal.Tools;
import com.zuora.sdk.internal.apis.data.GETAccountTypeBillToContact;
import com.zuora.sdk.internal.apis.data.GETAccountTypeSoldToContact;
import com.zuora.sdk.internal.apis.data.GETSubscriptionTypeWithSuccess;
import com.zuora.sdk.internal.apis.data.POSTAccountTypeBillToContact;
import com.zuora.sdk.internal.apis.data.POSTAccountTypeSoldToContact;
import com.zuora.sdk.internal.models.ZAccount;
import com.zuora.sdk.internal.models.ZContact;
import com.zuora.sdk.internal.models.ZProduct;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.models.ZSubscription;
import com.zuora.sdk.internal.models.enums.AccountStatus;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
interface ApiMapper {
    public static final ApiMapper Mapper = (ApiMapper)Mappers.getMapper(ApiMapper.class);

    @Mappings(value={@Mapping(source="accountKey", target="accountNumber"), @Mapping(source="billTo", target="billToContact"), @Mapping(source="soldTo", target="soldToContact"), @Mapping(source="parentAccount", target="parentId"), @Mapping(source="paymentTerms", target="paymentTerm"), @Mapping(source="description", target="notes"), @Mapping(target="paymentMethod", ignore=true), @Mapping(source="paymentMethod", target="hpmCreditCardPaymentMethodId"), @Mapping(source="customFields", target="accountObjectCustomFields"), @Mapping(expression="java(account.getBillCycleDay().getValue())", target="billCycleDay")})
    public ZAccount.Builder toApi(AccountCreateRequest var1);

    @Mappings(value={@Mapping(source="accountKey", target="accountNumber"), @Mapping(source="billTo", target="billToContact"), @Mapping(source="soldTo", target="soldToContact"), @Mapping(source="parentAccount", target="parentId"), @Mapping(source="paymentTerms", target="paymentTerm"), @Mapping(source="description", target="notes"), @Mapping(expression="java(account.getBillCycleDay().getValue())", target="billCycleDay"), @Mapping(source="customFields", target="accountObjectCustomFields")})
    public ZAccount.Builder toApi(Account var1);

    default public POSTAccountTypeBillToContact toBillTo(ContactCreateRequest contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeBillToContact postAccountTypeBillToContact = new POSTAccountTypeBillToContact();
        postAccountTypeBillToContact.address1(contact.getAddress().getLine1());
        postAccountTypeBillToContact.address2(contact.getAddress().getLine2());
        postAccountTypeBillToContact.city(contact.getAddress().getCity());
        postAccountTypeBillToContact.state(contact.getAddress().getState());
        postAccountTypeBillToContact.country(contact.getAddress().getCountry());
        postAccountTypeBillToContact.zipCode(contact.getAddress().getPostalCode());
        postAccountTypeBillToContact.workEmail(contact.getWorkEmail());
        postAccountTypeBillToContact.firstName(contact.getFirstName());
        postAccountTypeBillToContact.lastName(contact.getLastName());
        postAccountTypeBillToContact.homePhone(contact.getPhone());
        postAccountTypeBillToContact.personalEmail(contact.getEmail());
        postAccountTypeBillToContact.contactObjectCustomFields(contact.getCustomFields());
        return postAccountTypeBillToContact;
    }

    default public POSTAccountTypeSoldToContact toSoldTo(ContactCreateRequest contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeSoldToContact postAccountTypeSoldToContact = new POSTAccountTypeSoldToContact();
        postAccountTypeSoldToContact.address1(contact.getAddress().getLine1());
        postAccountTypeSoldToContact.address2(contact.getAddress().getLine2());
        postAccountTypeSoldToContact.city(contact.getAddress().getCity());
        postAccountTypeSoldToContact.state(contact.getAddress().getState());
        postAccountTypeSoldToContact.country(contact.getAddress().getCountry());
        postAccountTypeSoldToContact.zipCode(contact.getAddress().getPostalCode());
        postAccountTypeSoldToContact.workEmail(contact.getWorkEmail());
        postAccountTypeSoldToContact.firstName(contact.getFirstName());
        postAccountTypeSoldToContact.lastName(contact.getLastName());
        postAccountTypeSoldToContact.homePhone(contact.getPhone());
        postAccountTypeSoldToContact.personalEmail(contact.getEmail());
        postAccountTypeSoldToContact.contactObjectCustomFields(contact.getCustomFields());
        return postAccountTypeSoldToContact;
    }

    default public Account toAccount(AccountsQuery.Node account2, ZuoraClient client) {
        AccountsQuery.BillTo billToRes = account2.getBillTo();
        AccountsQuery.SoldTo soldToRes = account2.getSoldTo();
        if (billToRes == null) {
            throw new IllegalStateException("Expected a billTo contact.");
        }
        if (soldToRes == null) {
            throw new IllegalStateException("Expected a soldTo contact.");
        }
        Address billToAddress = Address.builder().state(billToRes.getState()).city(billToRes.getCity()).country(billToRes.getCountry()).line1(billToRes.getAddress1()).line2(billToRes.getAddress2()).postalCode(billToRes.getPostalCode()).build();
        Contact billTo2 = Contact.builder().account(account2.getId()).firstName(billToRes.getFirstName()).lastName(billToRes.getLastName()).phone(billToRes.getHomePhone()).email(billToRes.getPersonalEmail()).address(billToAddress).workEmail(billToRes.getWorkEmail()).build();
        Address soldToAddress = Address.builder().state(soldToRes.getState()).city(soldToRes.getCity()).country(soldToRes.getCountry()).line1(soldToRes.getAddress1()).line2(soldToRes.getAddress2()).postalCode(soldToRes.getPostalCode()).build();
        Contact soldTo2 = Contact.builder().account(account2.getId()).firstName(soldToRes.getFirstName()).lastName(soldToRes.getLastName()).phone(soldToRes.getHomePhone()).email(soldToRes.getPersonalEmail()).address(soldToAddress).workEmail(soldToRes.getWorkEmail()).build();
        Account.BillCycleDay billCycleDay = Account.BillCycleDay.values()[Integer.valueOf(account2.getBillCycleDay().toString())];
        Account.AccountBuilder accountBuilder = Account.builder().id(account2.getId()).crmId(account2.getCrmId()).description(account2.getNotes()).batch(account2.getBatch()).name(account2.getName()).accountKey(account2.getAccountNumber()).currency(account2.getCurrency()).billCycleDay(billCycleDay).paymentTerms(account2.getPaymentTerm()).autoPay(account2.getAutoPay()).billTo(billTo2).soldTo(soldTo2).billingDocumentSettings(BillingDocumentSettings.builder().creditMemoTemplate(account2.getCreditMemoTemplateId()).debitMemoTemplate(account2.getDebitMemoTemplateId()).invoiceTemplate(account2.getInvoiceTemplateId()).email(account2.getInvoiceDeliveryPrefsEmail()).print(account2.getInvoiceDeliveryPrefsPrint()).build()).balance(String.valueOf(account2.getBalance())).creditBalance(String.valueOf(account2.getCreditBalance())).totalInvoiceBalance(String.valueOf(account2.getTotalInvoiceBalance())).totalDebitMemoBalance(String.valueOf(account2.getTotalDebitMemoBalance())).unappliedCreditMemoAmount(String.valueOf(account2.getUnappliedCreditMemoAmount())).client(client);
        Account acc = accountBuilder.build();
        return acc;
    }

    default public Account toAccount(ZAccount account2, ZuoraClient client) {
        GETAccountTypeBillToContact billToRes = account2.Z_BillToContact();
        GETAccountTypeSoldToContact soldToRes = account2.Z_SoldToContact();
        if (billToRes == null) {
            throw new IllegalStateException("Expected a billTo contact.");
        }
        if (soldToRes == null) {
            throw new IllegalStateException("Expected a soldTo contact.");
        }
        Address billToAddress = Address.builder().state(billToRes.state()).city(billToRes.city()).country(billToRes.country()).line1(billToRes.address1()).line2(billToRes.address2()).postalCode(billToRes.zipCode()).build();
        Contact billTo2 = Contact.builder().account(account2.id()).firstName(billToRes.firstName()).lastName(billToRes.lastName()).phone(billToRes.homePhone()).email(billToRes.personalEmail()).address(billToAddress).workEmail(billToRes.workEmail()).customFields(billToRes.contactObjectCustomFields()).build();
        Address soldToAddress = Address.builder().state(soldToRes.state()).city(soldToRes.city()).country(soldToRes.country()).line1(soldToRes.address1()).line2(soldToRes.address2()).postalCode(soldToRes.zipCode()).build();
        Contact soldTo2 = Contact.builder().account(account2.id()).firstName(soldToRes.firstName()).lastName(soldToRes.lastName()).phone(soldToRes.homePhone()).email(soldToRes.personalEmail()).address(soldToAddress).workEmail(soldToRes.workEmail()).customFields(soldToRes.contactObjectCustomFields()).build();
        Account.BillCycleDay billCycleDay = Account.BillCycleDay.values()[Integer.parseInt(account2.billingAndPayment().billCycleDay())];
        Account.AccountBuilder accountBuilder = Account.builder().enabled(AccountStatus.ACTIVE.getApiValue().equals(account2.basicInfo().status())).id(account2.id()).crmId(account2.crmId()).description(account2.notes()).batch(account2.batch()).name(account2.basicInfo().name()).accountKey(account2.basicInfo().accountNumber()).currency(account2.billingAndPayment().currency()).billCycleDay(billCycleDay).paymentTerms(account2.paymentTerm()).autoPay(account2.autoPay()).billTo(billTo2).soldTo(soldTo2).billingDocumentSettings(BillingDocumentSettings.builder().creditMemoTemplate(account2.creditMemoTemplateId()).debitMemoTemplate(account2.debitMemoTemplateId()).invoiceTemplate(account2.invoiceTemplateId()).email(account2.invoiceDeliveryPrefsEmail()).print(account2.invoiceDeliveryPrefsPrint()).build()).balance(String.valueOf(account2.balance())).contractedMrr(account2.contractedMrr()).creditBalance(String.valueOf(account2.creditBalance())).totalInvoiceBalance(String.valueOf(account2.totalInvoiceBalance())).totalDebitMemoBalance(account2.totalDebitMemoBalance()).unappliedCreditMemoAmount(account2.unappliedCreditMemoAmount()).unappliedPaymentAmount(account2.unappliedPaymentAmount()).customFields(account2.accountObjectCustomFields()).client(client);
        if (account2.taxInfo() != null) {
            accountBuilder.taxIdentifier(TaxIdentifier.builder().id(account2.taxInfo().vATId()).build()).taxCertificate(TaxCertificate.builder().id(account2.taxInfo().exemptCertificateId()).companyCode(account2.taxInfo().companyCode()).startDate(account2.taxInfo().exemptEffectiveDate()).endDate(account2.taxInfo().exemptExpirationDate()).issuingJurisdiction(account2.taxInfo().exemptIssuingJurisdiction()).state(TaxCertificateStatus.getByLabel(account2.taxInfo().exemptStatus())).build());
        }
        Account acc = accountBuilder.build();
        account2.getAssociations().forEach(acc::associate);
        return acc;
    }

    @Mappings(value={@Mapping(expression="java(contact.getAddress().getLine1())", target="address1"), @Mapping(expression="java(contact.getAddress().getLine2())", target="address2"), @Mapping(expression="java(contact.getAddress().getCity())", target="city"), @Mapping(expression="java(contact.getAddress().getState())", target="state"), @Mapping(expression="java(contact.getAddress().getCountry())", target="country"), @Mapping(expression="java(contact.getAddress().getPostalCode())", target="postalCode"), @Mapping(source="phone", target="homePhone"), @Mapping(source="email", target="personalEmail"), @Mapping(source="account", target="accountId"), @Mapping(source="customFields", target="contactObjectCustomFields")})
    public ZContact.Builder toApi(ContactCreateRequest var1);

    @Mappings(value={@Mapping(expression="java(contact.getAddress().getLine1())", target="address1"), @Mapping(expression="java(contact.getAddress().getLine2())", target="address2"), @Mapping(expression="java(contact.getAddress().getCity())", target="city"), @Mapping(expression="java(contact.getAddress().getState())", target="state"), @Mapping(expression="java(contact.getAddress().getCountry())", target="country"), @Mapping(expression="java(contact.getAddress().getPostalCode())", target="postalCode"), @Mapping(source="phone", target="homePhone"), @Mapping(source="email", target="personalEmail"), @Mapping(source="account", target="accountId"), @Mapping(source="customFields", target="contactObjectCustomFields")})
    public ZContact.Builder toApi(Contact var1);

    default public Contact toContact(ZContact zContact) {
        return Contact.builder().id(zContact.id()).account(zContact.accountId()).firstName(zContact.firstName()).lastName(zContact.lastName()).phone(zContact.homePhone()).email(zContact.personalEmail()).workEmail(zContact.workEmail()).address(Address.builder().line1(zContact.address1()).line2(zContact.address2()).city(zContact.city()).state(zContact.state()).country(zContact.country()).postalCode(zContact.postalCode()).build()).createdBy(zContact.createdById()).createTime(ZonedDateTime.parse(zContact.createdDate())).updatedBy(zContact.updatedById()).updateTime(ZonedDateTime.parse(zContact.updatedDate())).customFields(zContact.contactObjectCustomFields()).build();
    }

    @Mappings(value={@Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="sku", target="sKU"), @Mapping(source="customFields", target="productObjectCustomFields")})
    public ZProduct.Builder toApi(ProductCreateRequest var1);

    @Mappings(value={@Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="sku", target="sKU"), @Mapping(source="customFields", target="productObjectCustomFields")})
    public ZProduct.Builder toApi(Product var1);

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    public ZProductRatePlan.Builder toApi(Plan var1);

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    public ZProductRatePlan.Builder toApi(PlanCreateRequest var1);

    @Mappings(value={@Mapping(source="effectiveStartDate", target="startDate"), @Mapping(source="effectiveEndDate", target="endDate"), @Mapping(source="createdDate", target="createTime"), @Mapping(source="updatedDate", target="updateTime"), @Mapping(source="createdById", target="createdBy"), @Mapping(source="updatedById", target="updatedBy")})
    public Plan fromApi(ProductRatePlanByIdQuery.ProductrateplanById var1);

    default public Subscription fromApi(GETSubscriptionTypeWithSuccess zSubscription, ZAccount subAccount, ZuoraClient client) {
        Subscription subscription2 = Subscription.builder().key(zSubscription.subscriptionNumber()).id(zSubscription.id()).state(Subscription.State.getByLabel(zSubscription.status())).initialTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.initialTerm()).interval(zSubscription.initialTermPeriodType()).build()).currentTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.currentTerm()).interval(zSubscription.currentTermPeriodType()).startDate(LocalDate.parse(zSubscription.termStartDate())).endDate(zSubscription.termEndDate() == null ? null : LocalDate.parse(zSubscription.termEndDate())).build()).startDate(zSubscription.subscriptionStartDate() == null ? null : LocalDate.parse(zSubscription.subscriptionStartDate())).endDate(zSubscription.subscriptionEndDate() == null ? null : LocalDate.parse(zSubscription.subscriptionEndDate())).termEndDate(zSubscription.termEndDate() == null ? null : LocalDate.parse(zSubscription.termEndDate())).termStartDate(LocalDate.parse(zSubscription.termStartDate())).description(zSubscription.notes()).contractEffective(LocalDate.parse(zSubscription.contractEffectiveDate())).serviceActivation(LocalDate.parse(zSubscription.serviceActivationDate())).customerAcceptance(LocalDate.parse(zSubscription.customerAcceptanceDate())).invoiceSeparately(zSubscription.invoiceSeparately().equals("true")).invoiceAccount(this.toAccount(subAccount, client)).account(this.toAccount(subAccount, client)).mrr(zSubscription.contractedMrr()).tcv(zSubscription.totalContractedValue()).client(client).build();
        if (zSubscription.renewalSetting().equalsIgnoreCase("RENEW_WITH_SPECIFIC_TERM")) {
            subscription2 = subscription2.toBuilder().renewalTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.renewalTerm()).interval(zSubscription.renewalTermPeriodType()).build()).build();
        }
        return subscription2;
    }

    default public Subscription fromApi(ZSubscription zSubscription, ZuoraClient client) {
        Account account2 = client.accounts().get(zSubscription.accountId());
        Account invAccount = client.accounts().get(zSubscription.invoiceOwnerId());
        Subscription subscription2 = Subscription.builder().key(zSubscription.name()).id(zSubscription.id()).state(Subscription.State.getByLabel(zSubscription.status().getApiValue())).initialTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.initialTerm()).interval(zSubscription.initialTermPeriodType().name().toLowerCase()).build()).currentTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.currentTerm()).interval(zSubscription.currentTermPeriodType().name().toLowerCase()).startDate(Tools.toLocalDate((String)zSubscription.termStartDate())).endDate(Tools.toLocalDate((String)zSubscription.termEndDate())).build()).startDate(Tools.toLocalDate((String)zSubscription.subscriptionStartDate())).endDate(Tools.toLocalDate((String)zSubscription.subscriptionEndDate())).termEndDate(Tools.toLocalDate((String)zSubscription.termEndDate())).termStartDate(Tools.toLocalDate((String)zSubscription.termStartDate())).description(zSubscription.notes()).contractEffective(Tools.toLocalDate((String)zSubscription.contractEffectiveDate())).serviceActivation(Tools.toLocalDate((String)zSubscription.serviceActivationDate())).customerAcceptance(Tools.toLocalDate((String)zSubscription.contractAcceptanceDate())).invoiceSeparately(zSubscription.invoiceSeparately()).invoiceAccount(invAccount).account(account2).version(zSubscription.version()).mrr(zSubscription.contractedMrr()).tcv(zSubscription.totalContractedValue()).canceledDate(Tools.toLocalDate((String)zSubscription.cancelledDate())).createdBy(zSubscription.createdById()).createTime(ZonedDateTime.parse(zSubscription.createdDate())).updatedBy(zSubscription.updatedById()).updateTime(ZonedDateTime.parse(zSubscription.updatedDate())).autoRenew(zSubscription.autoRenew()).customFields(zSubscription.subscriptionObjectCustomFields()).client(client).build();
        if (zSubscription.renewalSetting().name().equalsIgnoreCase("RENEW_WITH_SPECIFIC_TERM")) {
            subscription2 = subscription2.toBuilder().renewalTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.renewalTerm()).interval(zSubscription.renewalTermPeriodType().name().toLowerCase()).build()).build();
        }
        return subscription2;
    }
}

