/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.AccountAPI;
import com.zuora.sdk.BillingDocumentAPI;
import com.zuora.sdk.ContactAPI;
import com.zuora.sdk.CustomObjectAPI;
import com.zuora.sdk.PaymentAPI;
import com.zuora.sdk.PaymentMethodAPI;
import com.zuora.sdk.PlanAPI;
import com.zuora.sdk.PriceAPI;
import com.zuora.sdk.ProductAPI;
import com.zuora.sdk.RefundAPI;
import com.zuora.sdk.SubscriptionAPI;
import com.zuora.sdk.TaxationItemAPI;
import com.zuora.sdk.ZuoraMetadata;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.MuranoClient;
import com.zuora.sdk.internal.pricing.PriceHelper;
import java.time.LocalDate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ZuoraClient {
    public final String ENDPOINT_US_PRODUCTION = "https://rest.zuora.com";
    public final String ENDPOINT_EU_PRODUCTION = "https://rest.eu.zuora.com";
    public final String ENDPOINT_US_API_SANDBOX = "https://rest.apisandbox.zuora.com";
    public final String ENDPOINT_US_PERFORMANCE_TEST = "https://rest.pt1.zuora.com";
    public final String ENDPOINT_US_CLOUD_PRODUCTION = "https://rest.na.zuora.com";
    public final String ENDPOINT_US_CLOUD_API_SANDBOX = "https://rest.sandbox.na.zuora.com";
    public final String ENDPOINT_US_CENTRAL_SANDBOX = "https://rest.test.zuora.com";
    public final String ENDPOINT_EU_API_SANDBOX = "https://rest.sandbox.eu.zuora.com";
    public final String ENDPOINT_EU_CENTRAL_SANDBOX = "https://rest.test.eu.zuora.com";
    private final APIContext context;
    private HawkClient hawkClient;
    private MuranoClient muranoClient;
    private ZuoraMetadata metaData;

    public ZuoraClient(String clientId, String clientSecret, String endPointBase) {
        this(clientId, clientSecret, endPointBase, false);
    }

    public ZuoraClient(String clientId, String clientSecret, String endPointBase, boolean debug) {
        this.context = APIContext.builder().endpointBase(endPointBase).clientIdAndSecret(clientId, clientSecret).enableDebug(debug).build();
    }

    private static <T> T lazyLoad(@Nullable T object, Supplier<T> objectSupplier) {
        return object != null ? object : objectSupplier.get();
    }

    public APIContext getContext() {
        return this.context;
    }

    HawkClient getHawkClient() {
        this.hawkClient = ZuoraClient.lazyLoad(this.hawkClient, () -> this.createHawkClient(this.context));
        return this.hawkClient;
    }

    MuranoClient getMuranoClient() {
        this.muranoClient = ZuoraClient.lazyLoad(this.muranoClient, () -> this.createMuranoClient(this.context));
        return this.muranoClient;
    }

    ZuoraMetadata getMetaData() {
        this.metaData = ZuoraClient.lazyLoad(this.metaData, () -> this.createMetadata(this.getHawkClient()));
        return this.metaData;
    }

    void refetchMetadata() {
        this.metaData = this.createMetadata(this.getHawkClient());
    }

    public AccountAPI accounts() {
        return new AccountAPI(this);
    }

    public ContactAPI contacts() {
        return new ContactAPI(this);
    }

    public SubscriptionAPI subscriptions() {
        return new SubscriptionAPI(this);
    }

    public ProductAPI products() {
        return new ProductAPI(this);
    }

    public PriceAPI prices() {
        return new PriceAPI(this);
    }

    public PaymentAPI payments() {
        return new PaymentAPI(this);
    }

    public BillingDocumentAPI billingDocuments() {
        return new BillingDocumentAPI(this);
    }

    public PriceHelper priceHelper() {
        return new PriceHelper(this);
    }

    public CustomObjectAPI customObjects() {
        return new CustomObjectAPI(this);
    }

    public RefundAPI refunds() {
        return new RefundAPI(this);
    }

    public PaymentMethodAPI paymentMethods() {
        return new PaymentMethodAPI(this);
    }

    public TaxationItemAPI taxationItems() {
        return new TaxationItemAPI(this);
    }

    public PlanAPI plans() {
        return new PlanAPI(this);
    }

    LocalDate today() {
        return LocalDate.now(this.getContext().getEntityProfileInfo().tenantZoneId());
    }

    protected HawkClient createHawkClient(APIContext context) {
        return new HawkClient(context);
    }

    protected MuranoClient createMuranoClient(APIContext context) {
        return new MuranoClient(context);
    }

    protected ZuoraMetadata createMetadata(HawkClient hawkClient) {
        return new ZuoraMetadata(hawkClient.getMetadata());
    }
}

