/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Address;
import com.zuora.sdk.BillingDetails;
import com.zuora.sdk.CreditCard;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.PaymentMethodCreateRequest;
import com.zuora.sdk.core.apis.data.CreatePaymentMethodCardholderInfo;
import com.zuora.sdk.core.apis.data.GETPaymentMethodResponse;
import com.zuora.sdk.core.apis.data.POSTPMMandateInfo;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.ZPaymentMethod;
import com.zuora.sdk.enums.BankAccountType;
import com.zuora.sdk.enums.MitProfileAction;
import com.zuora.sdk.enums.MitProfileType;
import com.zuora.sdk.enums.PaymentMethodState;
import com.zuora.sdk.enums.PaymentMethodType;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
interface PaymentMethodMapper {
    public static final PaymentMethodMapper Mapper = (PaymentMethodMapper)Mappers.getMapper(PaymentMethodMapper.class);

    default public PaymentMethod.PaymentMethodBuilder fromApi(GETPaymentMethodResponse rawPaymentMethod) {
        PaymentMethodType type;
        PaymentMethod.PaymentMethodBuilder builder = new PaymentMethod.PaymentMethodBuilder();
        BillingDetails.BillingDetailsBuilder billingDetails = null;
        if (rawPaymentMethod.accountHolderInfo() != null) {
            Address address = Address.builder().city(rawPaymentMethod.accountHolderInfo().city()).country(rawPaymentMethod.accountHolderInfo().country()).state(rawPaymentMethod.accountHolderInfo().state()).postalCode(rawPaymentMethod.accountHolderInfo().zipCode()).line1(rawPaymentMethod.accountHolderInfo().addressLine1()).line2(rawPaymentMethod.accountHolderInfo().addressLine2()).build();
            billingDetails = BillingDetails.builder().email(rawPaymentMethod.accountHolderInfo().email()).name(rawPaymentMethod.accountHolderInfo().accountHolderName()).phone(rawPaymentMethod.accountHolderInfo().phone());
            billingDetails.address(address);
        }
        builder.id(rawPaymentMethod.id()).accountKey(rawPaymentMethod.accountKey()).accountName(rawPaymentMethod.bankAccountName()).accountNumber(rawPaymentMethod.accountNumber()).accountType(BankAccountType.fromApi(rawPaymentMethod.bankAccountType())).identityNumber(rawPaymentMethod.identityNumber()).bankName(rawPaymentMethod.bankName()).bankCode(rawPaymentMethod.bankCode()).branchCode(rawPaymentMethod.branchCode()).type(PaymentMethodType.fromApi(rawPaymentMethod.type())).state(PaymentMethodState.fromApi(rawPaymentMethod.status())).billingDetails(billingDetails == null ? null : billingDetails.build()).email(rawPaymentMethod.email()).businessIdentificationCode(rawPaymentMethod.businessIdentificationCode()).IBAN(rawPaymentMethod.iBAN()).identityNumber(rawPaymentMethod.identityNumber()).preapprovalKey(rawPaymentMethod.preapprovalKey()).isDefault(Boolean.TRUE.equals(rawPaymentMethod.isDefault())).customFields(rawPaymentMethod.paymentMethodObjectCustomFields());
        if (rawPaymentMethod.mandateInfo() != null) {
            POSTPMMandateInfo mandateInfo = rawPaymentMethod.mandateInfo();
            builder.mitConsentAgreement(mandateInfo.mitConsentAgreementRef()).mitNetworkTransactionId(mandateInfo.mitTransactionId()).mitProfileAction(MitProfileAction.fromApi(mandateInfo.mitProfileAction())).mitProfileType(MitProfileType.fromApi(mandateInfo.mitProfileType())).mitProfileAgreementOn(mandateInfo.mitProfileAgreedOn()).mandateId(mandateInfo.mandateId()).mandateReceived(Boolean.parseBoolean(mandateInfo.mandateReceivedStatus())).existingMandate(Boolean.parseBoolean(mandateInfo.existingMandateStatus())).mandateCreatedDate(mandateInfo.mandateCreationDate()).mandateUpdateDate(mandateInfo.mandateUpdateDate()).mandateReason(mandateInfo.mandateReason()).mandateState(mandateInfo.mandateStatus());
        }
        if (PaymentMethodType.CARD.equals((Object)(type = PaymentMethodType.fromApi(rawPaymentMethod.type())))) {
            CreditCard creditCard = CreditCard.builder().number(rawPaymentMethod.cardNumber()).brand(rawPaymentMethod.cardType()).expiryMonth(rawPaymentMethod.expirationMonth()).expiryYear(rawPaymentMethod.expirationYear()).build();
            builder.card(creditCard);
        } else if (PaymentMethodType.ACH_DEBIT.equals((Object)type)) {
            builder.accountNumber(rawPaymentMethod.bankAccountNumber());
        }
        return builder;
    }

    default public ZPaymentMethod.Builder toApi(PaymentMethodCreateRequest paymentMethodCreateRequest) {
        if (!paymentMethodCreateRequest.getType().equals((Object)PaymentMethodType.CARD)) {
            throw ZuoraSdkException.builder().message("Unsupported PaymentMethod Type (only CARD is supported)").retryable(false).build();
        }
        CreatePaymentMethodCardholderInfo cardHolderInfo = new CreatePaymentMethodCardholderInfo();
        if (paymentMethodCreateRequest.getBillingDetails() != null) {
            BillingDetails billingDetails = paymentMethodCreateRequest.getBillingDetails();
            cardHolderInfo.cardHolderName(billingDetails.getName());
            cardHolderInfo.email(billingDetails.getEmail());
            cardHolderInfo.phone(billingDetails.getPhone());
            if (billingDetails.getAddress() != null) {
                Address address = billingDetails.getAddress();
                cardHolderInfo.addressLine1(address.getLine1());
                cardHolderInfo.addressLine2(address.getLine2());
                cardHolderInfo.city(address.getCity());
                cardHolderInfo.state(address.getState());
                cardHolderInfo.zipCode(address.getPostalCode());
                cardHolderInfo.country(address.getCountry());
            }
        }
        ZPaymentMethod.Builder b = new ZPaymentMethod.Builder();
        b.type(paymentMethodCreateRequest.getType().getApiValue());
        b.cardHolderInfo(cardHolderInfo);
        b.makeDefault(Boolean.valueOf(paymentMethodCreateRequest.isDefault()));
        b.mitConsentAgreementRef(paymentMethodCreateRequest.getMitConsentAgreementRef());
        b.mitNetworkTransactionId(paymentMethodCreateRequest.getMitNetworkTransactionId());
        b.mitProfileAgreedOn(paymentMethodCreateRequest.getMitProfileAgreementOn());
        b.accountKey(paymentMethodCreateRequest.getAccountKey());
        b.paymentMethodObjectCustomFields(paymentMethodCreateRequest.getCustomFields());
        if (paymentMethodCreateRequest.getMitProfileAction() != null) {
            b.mitProfileAction(paymentMethodCreateRequest.getMitProfileAction().toApi());
        }
        if (paymentMethodCreateRequest.getMitConsentAgreementSrc() != null) {
            b.mitConsentAgreementSrc(paymentMethodCreateRequest.getMitConsentAgreementSrc().toAPI());
        }
        if (paymentMethodCreateRequest.getMitProfileType() != null) {
            b.mitProfileType(paymentMethodCreateRequest.getMitProfileType().toAPI());
        }
        if (paymentMethodCreateRequest.getCard() != null) {
            CreditCard card = paymentMethodCreateRequest.getCard();
            b.cardNumber(card.getNumber());
            b.cardType(card.getBrand());
            b.expirationMonth(card.getExpiryMonth());
            b.expirationYear(card.getExpiryYear());
            b.securityCode(card.getSecurityCode());
        }
        return b;
    }
}

