/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.AccountAPI;
import com.zuora.sdk.BillingDocumentAPI;
import com.zuora.sdk.ContactAPI;
import com.zuora.sdk.CustomObjectAPI;
import com.zuora.sdk.PaymentAPI;
import com.zuora.sdk.PaymentMethodAPI;
import com.zuora.sdk.ProductAPI;
import com.zuora.sdk.RefundAPI;
import com.zuora.sdk.SubscriptionAPI;
import com.zuora.sdk.TaxationItemAPI;
import com.zuora.sdk.ZuoraMetadata;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.utils.HawkClient;
import com.zuora.sdk.utils.MuranoClient;
import com.zuora.sdk.utils.PlanItemHelper;
import java.time.LocalDate;

public class ZuoraClient {
    private final APIContext context;
    private final HawkClient hawkClient;
    private final MuranoClient muranoClient;
    private ZuoraMetadata metaData;

    public APIContext getContext() {
        return this.context;
    }

    HawkClient getHawkClient() {
        return this.hawkClient;
    }

    MuranoClient getMuranoClient() {
        return this.muranoClient;
    }

    ZuoraMetadata getMetaData() {
        return this.metaData;
    }

    public ZuoraClient(String clientId, String clientSecret, String endPointBase) {
        this(clientId, clientSecret, endPointBase, false);
    }

    public ZuoraClient(String clientId, String clientSecret, String endPointBase, boolean debug) {
        this.context = APIContext.builder().endpointBase(endPointBase).clientIdAndSecret(clientId, clientSecret).enableDebug(debug).build();
        this.hawkClient = new HawkClient(this.context);
        this.muranoClient = new MuranoClient(this.context);
        this.metaData = new ZuoraMetadata(this.hawkClient.getMetadata());
    }

    void refetchMetadata() {
        this.metaData = new ZuoraMetadata(this.hawkClient.getMetadata());
    }

    public AccountAPI accounts() {
        return new AccountAPI(this);
    }

    public ContactAPI contacts() {
        return new ContactAPI(this);
    }

    public SubscriptionAPI subscriptions() {
        return new SubscriptionAPI(this);
    }

    public ProductAPI products() {
        return new ProductAPI(this);
    }

    public PaymentAPI payments() {
        return new PaymentAPI(this);
    }

    public BillingDocumentAPI billingDocuments() {
        return new BillingDocumentAPI(this);
    }

    public PlanItemHelper planItemHelper() {
        return new PlanItemHelper(this);
    }

    public CustomObjectAPI customObjects() {
        return new CustomObjectAPI(this);
    }

    public RefundAPI refunds() {
        return new RefundAPI(this);
    }

    public PaymentMethodAPI paymentMethods() {
        return new PaymentMethodAPI(this);
    }

    public TaxationItemAPI taxationItems() {
        return new TaxationItemAPI(this);
    }

    LocalDate today() {
        return LocalDate.now(this.getContext().getEntityProfileInfo().tenantZoneId());
    }
}

