/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.codahale.metrics.Meter;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.SubscriptionCreateRequest;
import com.zuora.sdk.SubscriptionPlan;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.chargemodels.DiscountAmount;
import com.zuora.sdk.chargemodels.DiscountPercentage;
import com.zuora.sdk.chargemodels.FlatFee;
import com.zuora.sdk.chargemodels.PerUnit;
import com.zuora.sdk.chargemodels.Tiered;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.SubscriptionsAPI;
import com.zuora.sdk.core.apis.data.BillingOptions;
import com.zuora.sdk.core.apis.data.CancelSubscription;
import com.zuora.sdk.core.apis.data.ChargeTier;
import com.zuora.sdk.core.apis.data.CreateOrderChargeOverride;
import com.zuora.sdk.core.apis.data.CreateOrderChargeOverrideBilling;
import com.zuora.sdk.core.apis.data.CreateOrderChargeOverridePricing;
import com.zuora.sdk.core.apis.data.CreateOrderChargeUpdate;
import com.zuora.sdk.core.apis.data.CreateOrderCreateSubscription;
import com.zuora.sdk.core.apis.data.CreateOrderCreateSubscriptionTerms;
import com.zuora.sdk.core.apis.data.CreateOrderCreateSubscriptionTermsInitialTerm;
import com.zuora.sdk.core.apis.data.CreateOrderOrderAction;
import com.zuora.sdk.core.apis.data.CreateOrderPricingUpdate;
import com.zuora.sdk.core.apis.data.CreateOrderRatePlanOverride;
import com.zuora.sdk.core.apis.data.CreateOrderRatePlanUpdate;
import com.zuora.sdk.core.apis.data.CreateOrderTriggerParams;
import com.zuora.sdk.core.apis.data.DiscountPricingOverride;
import com.zuora.sdk.core.apis.data.DiscountPricingUpdate;
import com.zuora.sdk.core.apis.data.GETSubscriptionTypeWithSuccess;
import com.zuora.sdk.core.apis.data.OneTimeFlatFeePricingOverride;
import com.zuora.sdk.core.apis.data.OneTimePerUnitPricingOverride;
import com.zuora.sdk.core.apis.data.OneTimeTieredPricingOverride;
import com.zuora.sdk.core.apis.data.OneTimeVolumePricingOverride;
import com.zuora.sdk.core.apis.data.OrderCreateRequestSubscriptions;
import com.zuora.sdk.core.apis.data.OwnerTransfer;
import com.zuora.sdk.core.apis.data.PostOrderResponseType;
import com.zuora.sdk.core.apis.data.PostOrderResponseTypeSubscriptions;
import com.zuora.sdk.core.apis.data.ProcessingOptions;
import com.zuora.sdk.core.apis.data.RecurringFlatFeePricingOverride;
import com.zuora.sdk.core.apis.data.RecurringFlatFeePricingUpdate;
import com.zuora.sdk.core.apis.data.RecurringPerUnitPricingOverride;
import com.zuora.sdk.core.apis.data.RecurringPerUnitPricingUpdate;
import com.zuora.sdk.core.apis.data.RecurringTieredPricingOverride;
import com.zuora.sdk.core.apis.data.RecurringTieredPricingUpdate;
import com.zuora.sdk.core.apis.data.RecurringVolumePricingOverride;
import com.zuora.sdk.core.apis.data.RecurringVolumePricingUpdate;
import com.zuora.sdk.core.apis.data.RemoveProduct;
import com.zuora.sdk.core.apis.data.RenewalTerm;
import com.zuora.sdk.core.apis.data.TriggerDate;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.ZOrder;
import com.zuora.sdk.core.models.ZSubscription;
import com.zuora.sdk.planitems.PlanItem;
import com.zuora.sdk.planitems.PlanItemType;
import com.zuora.sdk.utils.ApolloClientUtil;
import com.zuora.sdk.utils.HawkClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class SubscriptionAPI<T> {
    private final APIContext context;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;

    SubscriptionAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Subscription create(SubscriptionCreateRequest subscriptionCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        SubscriptionCreateRequest subscriptionCreateRequest2 = subscriptionCreateRequest;
        try {
            ZOrder zOrder;
            PostOrderResponseType postOrderResponseType;
            void orderRatePlans;
            List currency;
            void subRequest;
            CreateOrderCreateSubscription createOrderCreateSubscription;
            Object object2;
            void terms;
            void initialTerm;
            Term term = subscriptionCreateRequest2.getInitialTerm();
            Object object3 = new CreateOrderCreateSubscriptionTerms();
            object3.autoRenew(Boolean.valueOf(initialTerm.isAutoRenew()));
            if (terms != null) {
                object3.initialTerm(new CreateOrderCreateSubscriptionTermsInitialTerm().period(terms.getIntervalCount()).periodType(terms.getInterval()).termType(terms.getType().name()));
                if (initialTerm.getRenewalTerm() != null) {
                    void renewalTerm;
                    object2 = initialTerm.getRenewalTerm();
                    if (((Term)object2).getType() == Term.TermType.EVERGREEN) {
                        renewalTerm.renewalSetting("RENEW_TO_EVERGREEN");
                    } else {
                        renewalTerm.renewalSetting("RENEW_WITH_SPECIFIC_TERM");
                        renewalTerm.renewalTerms(Arrays.asList(new RenewalTerm().period(((Term)object2).getIntervalCount()).periodType(((Term)object2).getInterval())));
                    }
                }
            }
            object2 = new ArrayList();
            Currency currency2 = Currency.getInstance(initialTerm.getAccount().getCurrency());
            if (initialTerm.getPlans() != null) {
                void plans;
                createOrderCreateSubscription = initialTerm.getPlans();
                currency = createOrderCreateSubscription.stream().map(arg_0 -> ((SubscriptionAPI)subRequest).lambda$create$0((Currency)plans, arg_0)).collect(Collectors.toList());
            }
            createOrderCreateSubscription = new CreateOrderCreateSubscription().terms((CreateOrderCreateSubscriptionTerms)orderRatePlans).notes(initialTerm.notes).subscribeToRatePlans(currency);
            List<OrderCreateRequestSubscriptions> list = Arrays.asList(new OrderCreateRequestSubscriptions().customFields(initialTerm.getCustomFields()).orderActions(Arrays.asList(new CreateOrderOrderAction().triggerDates(super.getTriggerDates(initialTerm.getContractEffectiveDate(), initialTerm.getServiceActivationDate(), initialTerm.getCustomerAcceptanceDate())).type(OrderType.CREATE_SUBSCRIPTION.getApiValue()).createSubscription(createOrderCreateSubscription))));
            ZOrder.Builder builder = (ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(initialTerm.getAccount().getAccountKey())).orderDate(LocalDate.now().toString())).subscriptions(list);
            if (initialTerm.getProcessingOption() != null) {
                builder.processingOptions(new ProcessingOptions().runBilling(Boolean.valueOf(initialTerm.getProcessingOption().isRunBilling())).billingOptions(new BillingOptions().documentDate(initialTerm.getProcessingOption().getDocumentDate()).targetDate(initialTerm.getProcessingOption().getDocumentDate())));
            }
            if (!(postOrderResponseType = (zOrder = builder.build()).createInternally(subRequest.context)).success().booleanValue()) {
                // empty if block
            }
            String string = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            subRequest.client.customObjects().saveAssociations((BaseFacade)initialTerm, string);
            object = subRequest.get(string);
            return object;
        }
        finally {
            subscriptionCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription addPlan(Subscription subscription2, Plan plan, @NotNull LocalDate localDate) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        Plan plan2 = plan;
        LocalDate localDate2 = localDate;
        try {
            void contractEffective;
            void plan3;
            void subscription4;
            object = subscription4.addPlan((Subscription)plan3, (Plan)contractEffective, localDate2, localDate2, localDate2);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription addPlan(Subscription subscription2, Plan plan, @NotNull LocalDate localDate, LocalDate localDate2, LocalDate localDate3) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        Plan plan2 = plan;
        LocalDate localDate4 = localDate;
        LocalDate localDate5 = localDate2;
        LocalDate localDate6 = localDate3;
        try {
            void contractEffective;
            void currency;
            void plan3;
            void customerAcceptance;
            void serviceActivation;
            void subscription4;
            CreateOrderOrderAction createOrderOrderAction = new CreateOrderOrderAction().type(OrderType.ADD_PRODUCT.getApiValue()).triggerDates(super.getTriggerDates((LocalDate)serviceActivation, (LocalDate)customerAcceptance, localDate6));
            Currency currency2 = Currency.getInstance(plan3.getAccount().getCurrency());
            currency.addProduct(super.getCreateOrderRatePlanOverride((Plan)contractEffective, currency2));
            object = super.getOrderCreateRequestSubscriptions((Subscription)plan3, (CreateOrderOrderAction)currency);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription updateSubscriptionPlanItem(Subscription subscription2, SubscriptionPlanItem subscriptionPlanItem, @NotNull LocalDate localDate) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionPlanItem subscriptionPlanItem2 = subscriptionPlanItem;
        LocalDate localDate2 = localDate;
        try {
            void contractEffective;
            void subscriptionPlanItem3;
            void subscription4;
            object = subscription4.updateSubscriptionPlanItem((Subscription)subscriptionPlanItem3, (SubscriptionPlanItem)contractEffective, localDate2, localDate2, localDate2);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription updateSubscriptionPlanItem(Subscription subscription2, SubscriptionPlanItem subscriptionPlanItem, @NotNull LocalDate localDate, LocalDate localDate2, LocalDate localDate3) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionPlanItem subscriptionPlanItem2 = subscriptionPlanItem;
        LocalDate localDate4 = localDate;
        LocalDate localDate5 = localDate2;
        LocalDate localDate6 = localDate3;
        try {
            void currency;
            void contractEffective;
            void subscriptionPlanItem3;
            void customerAcceptance;
            void serviceActivation;
            void subscription4;
            CreateOrderOrderAction createOrderOrderAction = new CreateOrderOrderAction().type(OrderType.UPDATE_PRODUCT.getApiValue()).triggerDates(super.getTriggerDates((LocalDate)serviceActivation, (LocalDate)customerAcceptance, localDate6));
            Currency currency2 = Currency.getInstance(subscriptionPlanItem3.getAccount().getCurrency());
            CreateOrderRatePlanUpdate createOrderRatePlanUpdate = new CreateOrderRatePlanUpdate().ratePlanId(contractEffective.getSubscriptionPlan()).chargeUpdates(Arrays.asList(new CreateOrderChargeUpdate().chargeNumber(contractEffective.getNumber()).pricing(super.getChargeUpdatePricing((SubscriptionPlanItem)contractEffective, currency2))));
            currency.updateProduct(createOrderRatePlanUpdate);
            object = super.getOrderCreateRequestSubscriptions((Subscription)subscriptionPlanItem3, (CreateOrderOrderAction)currency);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    private Subscription getOrderCreateRequestSubscriptions(Subscription subscription2, CreateOrderOrderAction orderAction) {
        OrderCreateRequestSubscriptions subscriptionChange = new OrderCreateRequestSubscriptions().subscriptionNumber(subscription2.getKey()).customFields(subscription2.getCustomFields()).orderActions(Arrays.asList(orderAction));
        ZOrder newOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(subscription2.getAccount().getAccountKey())).subscriptions(Arrays.asList(subscriptionChange))).orderDate(LocalDate.now().toString())).build();
        PostOrderResponseType orderResponseType = newOrder.createInternally(this.context);
        if (!orderResponseType.success().booleanValue()) {
            throw ZuoraSdkException.builder().message(orderResponseType.getRawResponse()).build();
        }
        String subKey = ((PostOrderResponseTypeSubscriptions)orderResponseType.subscriptions().get(0)).subscriptionId();
        return this.get(subKey);
    }

    /*
     * WARNING - void declaration
     */
    public Subscription cancel(Subscription subscription2) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        try {
            void cancelOrderAction;
            void today;
            void subscription4;
            LocalDate localDate = LocalDate.now();
            Object object2 = super.getCancelOrderAction(localDate, CancellationPolicy.SPECIFIC_DATE, super.getTriggerDates(localDate, localDate, localDate));
            Object object3 = new OrderCreateRequestSubscriptions().subscriptionNumber(today.getKey()).orderActions(Arrays.asList(object2));
            Meter meter = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(today.getAccount().getAccountKey())).subscriptions(Arrays.asList(object3))).orderDate(cancelOrderAction.toString())).build();
            PostOrderResponseType postOrderResponseType = meter.createInternally(subscription4.context);
            if (!postOrderResponseType.success().booleanValue()) {
                throw ZuoraSdkException.builder().message(postOrderResponseType.getRawResponse()).build();
            }
            String string = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            object = subscription4.get(string);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription ownerTransfer(Subscription subscription2, String string, String string2) {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        String string3 = string;
        String string4 = string2;
        try {
            void ownerTransferActions;
            void destinationAccountNumber;
            void today;
            void destinationInvoiceAccountNumber;
            void subscription4;
            LocalDate localDate = LocalDate.now();
            CreateOrderOrderAction createOrderOrderAction = super.getOwnerTransferOrderAction((String)destinationInvoiceAccountNumber, (String)today, super.getTriggerDates(localDate, localDate, localDate));
            OrderCreateRequestSubscriptions orderCreateRequestSubscriptions = new OrderCreateRequestSubscriptions().subscriptionNumber(destinationAccountNumber.getKey()).orderActions(Arrays.asList(createOrderOrderAction));
            ZOrder zOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(destinationAccountNumber.getAccount().getAccountKey())).subscriptions(Arrays.asList(orderCreateRequestSubscriptions))).orderDate(ownerTransferActions.toString())).build();
            PostOrderResponseType postOrderResponseType = zOrder.createInternally(subscription4.context);
            if (!postOrderResponseType.success().booleanValue()) {
                throw ZuoraSdkException.builder().message(postOrderResponseType.getRawResponse()).build();
            }
            String string5 = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            object = subscription4.get(string5);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription renew(String string) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        String string2 = string;
        try {
            void subscriptionKey;
            Subscription subscription2 = subscriptionKey.get(string2);
            if (subscription2 == null) {
                throw ZuoraSdkException.builder().message("Subscription does not exist").build();
            }
            object = super.renew(subscription2, null);
            return object;
        }
        finally {
            string2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription renew(String string, String string2) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        String string3 = string;
        String string4 = string2;
        try {
            void subscription2;
            void accountKey;
            void subscriptionKey;
            Subscription subscription3 = subscriptionKey.get((String)accountKey);
            if (subscription3 == null) {
                throw ZuoraSdkException.builder().message("Subscription does not exist").build();
            }
            object = super.renew(subscription3, (String)subscription2);
            return object;
        }
        finally {
            string3 = null;
        }
    }

    private Subscription renew(Subscription subscription2, String accountKey) {
        if (subscription2.getInitialTerm().getType() == Term.TermType.EVERGREEN || subscription2.getTermEndDate() == null) {
            throw ZuoraSdkException.builder().message("Evergreen Subscriptions cannot be renewed").build();
        }
        LocalDate effectiveDate = subscription2.getTermEndDate();
        accountKey = accountKey == null ? subscription2.getAccount().getAccountKey() : accountKey;
        ArrayList<CreateOrderOrderAction> orderActions = new ArrayList<CreateOrderOrderAction>();
        List<TriggerDate> triggerDates = this.getTriggerDates(effectiveDate, effectiveDate, effectiveDate);
        orderActions.add(this.getRenewOrderAction(triggerDates));
        if (accountKey != subscription2.getAccount().getAccountKey()) {
            orderActions.add(this.getOwnerTransferOrderAction(accountKey, accountKey, triggerDates));
        }
        OrderCreateRequestSubscriptions sub = new OrderCreateRequestSubscriptions().subscriptionNumber(subscription2.getKey()).orderActions(orderActions);
        ZOrder newOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(subscription2.getAccount().getAccountKey())).subscriptions(Arrays.asList(sub))).orderDate(LocalDate.now().toString())).build();
        PostOrderResponseType orderResponseType = newOrder.createInternally(this.context);
        if (!orderResponseType.success().booleanValue()) {
            throw ZuoraSdkException.builder().message(orderResponseType.getRawResponse()).build();
        }
        String subKey = ((PostOrderResponseTypeSubscriptions)orderResponseType.subscriptions().get(0)).subscriptionId();
        return this.get(subKey);
    }

    public Subscription get(String subscriptionKey) throws ZuoraSdkException {
        Subscription subscription2 = null;
        ZSubscription zSubscription = ZSubscription.getObject((APIContext)this.context, (String)subscriptionKey);
        subscription2 = ApiMapper.Mapper.fromApi(zSubscription, this.client);
        GETSubscriptionTypeWithSuccess getSubscriptionTypeWithSuccess = SubscriptionsAPI.retrieveByKey((APIContext)this.context, (String)zSubscription.id());
        if (getSubscriptionTypeWithSuccess.success().booleanValue()) {
            subscription2 = subscription2.toBuilder().mrr(getSubscriptionTypeWithSuccess.contractedMrr()).tcv(getSubscriptionTypeWithSuccess.totalContractedValue()).build();
        }
        return subscription2;
    }

    /*
     * WARNING - void declaration
     */
    public Subscription removeSubscriptionPlan(Subscription subscription2, SubscriptionPlan subscriptionPlan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionPlan subscriptionPlan2 = subscriptionPlan;
        try {
            void removeProductOrderAction;
            void subscriptionPlan3;
            void today;
            void subscription4;
            LocalDate localDate = LocalDate.now();
            Object object2 = super.getRemoveProductOrderAction(super.getTriggerDates(localDate, localDate, localDate), today.getId());
            OrderCreateRequestSubscriptions orderCreateRequestSubscriptions = new OrderCreateRequestSubscriptions().subscriptionNumber(subscriptionPlan3.getKey()).orderActions(Arrays.asList(object2));
            ZOrder zOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(subscriptionPlan3.getAccount().getAccountKey())).subscriptions(Arrays.asList(orderCreateRequestSubscriptions))).orderDate(removeProductOrderAction.toString())).build();
            PostOrderResponseType postOrderResponseType = zOrder.createInternally(subscription4.context);
            if (!postOrderResponseType.success().booleanValue()) {
                throw ZuoraSdkException.builder().message(postOrderResponseType.getRawResponse()).build();
            }
            String string = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            object = subscription4.get(string);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    public List<SubscriptionPlan> getSubscriptionPlans(String subscriptionId) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new RatePlansBySubscriptionIdQuery(subscriptionId)));
            if (response.get().getData() == null) {
                throw ZuoraSdkException.builder().build();
            }
            return ((RatePlansBySubscriptionIdQuery.Data)response.get().getData()).getRateplans().getEdges().stream().filter(plan -> !String.valueOf(plan.getNode().getAmendmentType()).equals(OrderType.REMOVE_PRODUCT.getApiValue())).map(plan -> SubscriptionPlan.builder().client(this.client).id(plan.getNode().getId()).name(plan.getNode().getName()).plan(plan.getNode().getProductRatePlanId()).subscription(plan.getNode().getSubscriptionId()).createdBy(plan.getNode().getCreatedById()).createTime(ZonedDateTime.parse(plan.getNode().getCreatedDate())).updatedBy(plan.getNode().getUpdatedDate()).updateTime(ZonedDateTime.parse(plan.getNode().getUpdatedDate())).subscriptionPlanItems(ApiMapper.Mapper.getSubscriptionPlanItems(plan.getNode().getRateplancharges().getEdges())).build()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().operationName("getSubscriptionPlans").cause((Throwable)e).build();
        }
    }

    private List<CreateOrderChargeOverride> getChargeOverride(Plan plan, Currency currency) {
        List<PlanItem> items = plan.getItems();
        return items.stream().map(item -> new CreateOrderChargeOverride().pricing(this.getChargeOverridePricing((PlanItem)item, currency)).productRatePlanChargeId(item.getId()).billing(this.getChargeOverrideBilling((PlanItem)item)).startDate(new CreateOrderTriggerParams().triggerEvent(item.getStartEvent().getValue())).description(item.getDescription())).collect(Collectors.toList());
    }

    private CreateOrderChargeOverrideBilling getChargeOverrideBilling(PlanItem item) {
        CreateOrderChargeOverrideBilling chargeOverrideBilling = new CreateOrderChargeOverrideBilling();
        if (item.getAlignment() != null) {
            chargeOverrideBilling.billingPeriodAlignment(item.getAlignment().label);
        }
        if (item.getTiming() != null) {
            chargeOverrideBilling.billingTiming(item.getTiming().name());
        }
        return chargeOverrideBilling;
    }

    private CreateOrderChargeOverridePricing getChargeOverridePricing(PlanItem item, Currency currency) {
        CreateOrderChargeOverridePricing chargeOverridePricing = new CreateOrderChargeOverridePricing();
        PlanItemType.ItemType type = item.getPlanItemType();
        ChargeModelInterface chargeModel = item.getChargeModel();
        ChargeModelInterface.Type chargeModelType = chargeModel.getType();
        if (type.equals((Object)PlanItemType.ItemType.RECURRING)) {
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.FLAT_FEE)) {
                return chargeOverridePricing.recurringFlatFee(new RecurringFlatFeePricingOverride().listPrice(((FlatFee)chargeModel).getAmounts().get(currency)).listPriceBase(((FlatFee)item.getChargeModel()).getPriceBaseInterval().getApiValue().replace(" ", "_")));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.PER_UNIT)) {
                return chargeOverridePricing.recurringPerUnit(new RecurringPerUnitPricingOverride().listPrice(((PerUnit)chargeModel).getUnitAmounts().get(currency)).listPriceBase(((PerUnit)item.getChargeModel()).getPriceBaseInterval().getApiValue().replace(" ", "_")).quantity(item.getChargeModel().getQuantity()));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.TIERED)) {
                return chargeOverridePricing.recurringTiered(new RecurringTieredPricingOverride().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.VOLUME)) {
                return chargeOverridePricing.recurringVolume(new RecurringVolumePricingOverride().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.DISCOUNT_AMOUNT)) {
                DiscountAmount discount = (DiscountAmount)chargeModel;
                return chargeOverridePricing.discount(new DiscountPricingOverride().applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discount.getApplyDiscountTo()).getApiValue()).discountAmount(discount.getAmounts().get(currency)).discountLevel(discount.getDiscountLevel().getApiValue()));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.DISCOUNT_PERCENTAGE)) {
                DiscountPercentage discount = (DiscountPercentage)chargeModel;
                return chargeOverridePricing.discount(new DiscountPricingOverride().applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discount.getApplyDiscountTo()).getApiValue()).discountPercentage(discount.getPercentages().get(currency)).discountLevel(discount.getDiscountLevel().getApiValue()));
            }
        } else if (type.equals((Object)PlanItemType.ItemType.ONE_TIME)) {
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.FLAT_FEE)) {
                return chargeOverridePricing.oneTimeFlatFee(new OneTimeFlatFeePricingOverride().listPrice(((FlatFee)chargeModel).getAmounts().get(currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.PER_UNIT)) {
                return chargeOverridePricing.oneTimePerUnit(new OneTimePerUnitPricingOverride().listPrice(((PerUnit)chargeModel).getUnitAmounts().get(currency)).quantity(item.getChargeModel().getQuantity()));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.TIERED)) {
                return chargeOverridePricing.oneTimeTiered(new OneTimeTieredPricingOverride().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.VOLUME)) {
                return chargeOverridePricing.oneTimeVolume(new OneTimeVolumePricingOverride().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
        }
        return chargeOverridePricing;
    }

    private CreateOrderPricingUpdate getChargeUpdatePricing(SubscriptionPlanItem item, Currency currency) {
        CreateOrderPricingUpdate chargeUpdatePricing = new CreateOrderPricingUpdate();
        PlanItemType.ItemType type = item.getPlanItemType();
        ChargeModelInterface chargeModel = item.getChargeModel();
        ChargeModelInterface.Type chargeModelType = chargeModel.getType();
        if (type.equals((Object)PlanItemType.ItemType.RECURRING)) {
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.FLAT_FEE)) {
                return chargeUpdatePricing.recurringFlatFee(new RecurringFlatFeePricingUpdate().listPrice(((FlatFee)chargeModel).getAmounts().get(currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.PER_UNIT)) {
                return chargeUpdatePricing.recurringPerUnit(new RecurringPerUnitPricingUpdate().listPrice(((PerUnit)chargeModel).getUnitAmounts().get(currency)).quantity(item.getChargeModel().getQuantity()));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.TIERED)) {
                return chargeUpdatePricing.recurringTiered(new RecurringTieredPricingUpdate().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.VOLUME)) {
                return chargeUpdatePricing.recurringVolume(new RecurringVolumePricingUpdate().quantity(chargeModel.getQuantity()).tiers(this.getChargeTiers(chargeModel.getTiers(), currency)));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.DISCOUNT_AMOUNT)) {
                DiscountAmount discount = (DiscountAmount)chargeModel;
                return chargeUpdatePricing.discount(new DiscountPricingUpdate().applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discount.getApplyDiscountTo()).getApiValue()).discountLevel(discount.getDiscountLevel().getApiValue()));
            }
            if (chargeModelType.equals((Object)ChargeModelInterface.Type.DISCOUNT_PERCENTAGE)) {
                DiscountPercentage discount = (DiscountPercentage)chargeModel;
                return chargeUpdatePricing.discount(new DiscountPricingUpdate().applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discount.getApplyDiscountTo()).getApiValue()).discountPercentage(discount.getPercentages().get(currency)).discountLevel(discount.getDiscountLevel().getApiValue()));
            }
        } else if (type.equals((Object)PlanItemType.ItemType.ONE_TIME)) {
            throw ZuoraSdkException.builder().operationName("update subscription plan").message("Updating one time pricing is not supported").build();
        }
        return chargeUpdatePricing;
    }

    private List<ChargeTier> getChargeTiers(List<Tiered.Tier> tiers, Currency currency) {
        return tiers.stream().map(aTier -> {
            ChargeTier chargeTier = new ChargeTier().tier(aTier.getTier());
            if (aTier.getAmounts() != null & !aTier.getAmounts().isEmpty()) {
                return chargeTier.price(aTier.getAmounts().get(currency)).priceFormat(ChargeTier.EnumpriceFormat.EpriceFormat1.label).startingUnit(aTier.getStartingUnit()).endingUnit(aTier.getUpTo());
            }
            if (aTier.getUnitAmounts() != null & !aTier.getUnitAmounts().isEmpty()) {
                return chargeTier.price(aTier.getUnitAmounts().get(currency)).priceFormat(ChargeTier.EnumpriceFormat.EpriceFormat2.label).startingUnit(aTier.getStartingUnit()).endingUnit(aTier.getUpTo());
            }
            throw ZuoraSdkException.builder().message("No pricing on tier").build();
        }).collect(Collectors.toList());
    }

    private CreateOrderOrderAction getCancelOrderAction(LocalDate cancellationDate, CancellationPolicy cancellationPolicy, List<TriggerDate> triggerDates) {
        return new CreateOrderOrderAction().type(OrderType.CANCEL_SUBSCRIPTION.getApiValue()).cancelSubscription(new CancelSubscription().cancellationEffectiveDate(cancellationDate.toString()).cancellationPolicy(cancellationPolicy.getApiValue())).triggerDates(triggerDates);
    }

    private CreateOrderOrderAction getOwnerTransferOrderAction(String accountKey, String invoiceAccountKey, List<TriggerDate> triggerDates) {
        return new CreateOrderOrderAction().type(OrderType.OWNER_TRANSFER.getApiValue()).ownerTransfer(new OwnerTransfer().destinationAccountNumber(accountKey).destinationInvoiceAccountNumber(invoiceAccountKey)).triggerDates(triggerDates);
    }

    private CreateOrderOrderAction getRenewOrderAction(List<TriggerDate> triggerDates) {
        return new CreateOrderOrderAction().type(OrderType.RENEW_SUBSCRIPTION.getApiValue()).triggerDates(triggerDates);
    }

    private CreateOrderOrderAction getRemoveProductOrderAction(List<TriggerDate> triggerDates, String ratePlanId) {
        return new CreateOrderOrderAction().type(OrderType.REMOVE_PRODUCT.getApiValue()).removeProduct(new RemoveProduct().ratePlanId(ratePlanId)).triggerDates(triggerDates);
    }

    private CreateOrderRatePlanOverride getCreateOrderRatePlanOverride(Plan plan, Currency currency) {
        return new CreateOrderRatePlanOverride().productRatePlanId(plan.getId()).chargeOverrides(this.getChargeOverride(plan, currency));
    }

    private List<TriggerDate> getTriggerDates(LocalDate contractEffective, LocalDate serviceActivation, LocalDate customerAcceptance) {
        ArrayList<TriggerDate> triggerDates = new ArrayList<TriggerDate>();
        if (contractEffective != null) {
            triggerDates.add(new TriggerDate().name(TriggerDateEnum.CONTRACT_EFFECTIVE.getApiValue()).triggerDate(contractEffective.toString()));
        }
        if (serviceActivation != null) {
            triggerDates.add(new TriggerDate().name(TriggerDateEnum.SERVICE_ACTIVATION.getApiValue()).triggerDate(serviceActivation.toString()));
        }
        if (customerAcceptance != null) {
            triggerDates.add(new TriggerDate().name(TriggerDateEnum.CUSTOMER_ACCEPTANCE.getApiValue()).triggerDate(customerAcceptance.toString()));
        }
        return triggerDates;
    }

    private /* synthetic */ CreateOrderRatePlanOverride lambda$create$0(Currency currency, Plan plan) {
        return this.getCreateOrderRatePlanOverride(plan, currency);
    }

    static enum CancellationPolicy {
        SPECIFIC_DATE("SpecificDate"),
        END_OF_CURRENT_TERM("EndOfCurrentTerm"),
        END_OF_LAST_INVOICE_PERIOD("EndOfLastInvoicePeriod");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CancellationPolicy(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }

    static enum OrderType {
        CREATE_SUBSCRIPTION("CreateSubscription"),
        CANCEL_SUBSCRIPTION("CancelSubscription"),
        RENEW_SUBSCRIPTION("RenewSubscription"),
        OWNER_TRANSFER("OwnerTransfer"),
        ADD_PRODUCT("AddProduct"),
        REMOVE_PRODUCT("RemoveProduct"),
        UPDATE_PRODUCT("UpdateProduct");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private OrderType(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }

    static enum TriggerDateEnum {
        CONTRACT_EFFECTIVE("ContractEffective"),
        SERVICE_ACTIVATION("ServiceActivation"),
        CUSTOMER_ACCEPTANCE("CustomerAcceptance");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TriggerDateEnum(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }
}

