/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class FulfillmentProcessingOption {
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;

    public FulfillmentProcessingOption documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the billing document is created or paid.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public FulfillmentProcessingOption targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target date for the order to be picked up by bill run for billing.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentProcessingOption fulfillmentProcessingOption = (FulfillmentProcessingOption)o;
        return Objects.equals(this.documentDate, fulfillmentProcessingOption.documentDate) && Objects.equals(this.targetDate, fulfillmentProcessingOption.targetDate);
    }

    public int hashCode() {
        return Objects.hash(this.documentDate, this.targetDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentProcessingOption {\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

