/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class FilesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FilesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getFilesCall(String fileId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/files/{file-id}".replace("{file-id}", this.localVarApiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"multipart/form-data", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFilesValidateBeforeCall(String fileId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (fileId == null) {
            throw new ApiException("Missing the required parameter 'fileId' when calling getFiles(Async)");
        }
        return this.getFilesCall(fileId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected File getFiles(String fileId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<File> localVarResp = this.getFilesWithHttpInfo(fileId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<File> getFilesWithHttpInfo(String fileId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getFilesValidateBeforeCall(fileId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getFilesAsync(String fileId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getFilesValidateBeforeCall(fileId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFilesApi getFilesApi(String fileId) {
        return new GetFilesApi(fileId);
    }

    public class GetFilesApi {
        private final String fileId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetFilesApi(String fileId) {
            this.fileId = fileId;
        }

        public GetFilesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetFilesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetFilesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetFilesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetFilesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetFilesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetFilesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetFilesApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FilesApi.this.getFilesCall(this.fileId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse localVarResp = FilesApi.this.getFilesWithHttpInfo(this.fileId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (File)localVarResp.getData();
        }

        private ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return FilesApi.this.getFilesWithHttpInfo(this.fileId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return FilesApi.this.getFilesAsync(this.fileId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

