/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.RunWorkflowRequest;
import org.openapitools.client.model.WorkflowRun;

public class WorkflowsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call runWorkflowCall(Integer workflowId, RunWorkflowRequest runWorkflowRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RunWorkflowRequest localVarPostBody = runWorkflowRequest;
        String localVarPath = "/workflows/{workflow_id}/run".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call runWorkflowValidateBeforeCall(Integer workflowId, RunWorkflowRequest runWorkflowRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling runWorkflow(Async)");
        }
        if (runWorkflowRequest == null) {
            throw new ApiException("Missing the required parameter 'runWorkflowRequest' when calling runWorkflow(Async)");
        }
        return this.runWorkflowCall(workflowId, runWorkflowRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<WorkflowRun> runWorkflowWithHttpInfo(Integer workflowId, RunWorkflowRequest runWorkflowRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.runWorkflowValidateBeforeCall(workflowId, runWorkflowRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<WorkflowRun>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call runWorkflowAsync(Integer workflowId, RunWorkflowRequest runWorkflowRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<WorkflowRun> _callback) throws ApiException {
        Call localVarCall = this.runWorkflowValidateBeforeCall(workflowId, runWorkflowRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<WorkflowRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RunWorkflowParams runWorkflowParams(Integer workflowId, RunWorkflowRequest runWorkflowRequest) {
        return new RunWorkflowParams(workflowId, runWorkflowRequest);
    }

    public WorkflowRun runWorkflow(Integer workflowId, RunWorkflowRequest runWorkflowRequest) throws ApiException {
        RunWorkflowParams params = new RunWorkflowParams(workflowId, runWorkflowRequest);
        return this.executeRunWorkflowAPICall(params).getData();
    }

    public WorkflowRun runWorkflow(Integer workflowId, RunWorkflowRequest runWorkflowRequest, Headers headers) throws ApiException {
        RunWorkflowParams params = new RunWorkflowParams(workflowId, runWorkflowRequest).headers(headers);
        return this.executeRunWorkflowAPICall(params).getData();
    }

    public WorkflowRun post(RunWorkflowParams params) throws ApiException {
        return this.executeRunWorkflowAPICall(params).getData();
    }

    public ApiResponse<WorkflowRun> postWithHttpInfo(RunWorkflowParams params) throws ApiException {
        return this.executeRunWorkflowAPICall(params);
    }

    ApiResponse<WorkflowRun> executeRunWorkflowAPICall(RunWorkflowParams params) throws ApiException {
        return this.runWorkflowWithHttpInfo(params.workflowId, params.runWorkflowRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class RunWorkflowParams {
        private final Integer workflowId;
        private final RunWorkflowRequest runWorkflowRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public RunWorkflowParams(Integer workflowId, RunWorkflowRequest runWorkflowRequest) {
            this.workflowId = workflowId;
            this.runWorkflowRequest = runWorkflowRequest;
        }

        public RunWorkflowParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }
}

