/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

@ApiModel(description="Processing options for the invoice or payment.")
public class OrdersProcessingOption {
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_COLLECTION_METHOD = "collection_method";
    @SerializedName(value="collection_method")
    private CollectionMethodEnum collectionMethod;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_DRAFT_INVOICE = "draft_invoice";
    @SerializedName(value="draft_invoice")
    private Boolean draftInvoice;
    public static final String SERIALIZED_NAME_REFUND_REASON_CODE = "refund_reason_code";
    @SerializedName(value="refund_reason_code")
    private String refundReasonCode;

    public OrdersProcessingOption documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date printed on billing documents.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public OrdersProcessingOption targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target date for the order to be picked up by bill run for billing.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public OrdersProcessingOption collectionMethod(CollectionMethodEnum collectionMethod) {
        this.collectionMethod = collectionMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether to just create an invoice, or to create an invoice and collect payment.")
    public CollectionMethodEnum getCollectionMethod() {
        return this.collectionMethod;
    }

    public void setCollectionMethod(CollectionMethodEnum collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    public OrdersProcessingOption paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Payment method Id used to pay billing documents.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public OrdersProcessingOption paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093d07ae636bb017ae97518762aa3", value="Identifier of the payment gateway Zuora will use to authorize the payments that are made with this payment method.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public OrdersProcessingOption draftInvoice(Boolean draftInvoice) {
        this.draftInvoice = draftInvoice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getDraftInvoice() {
        return this.draftInvoice;
    }

    public void setDraftInvoice(Boolean draftInvoice) {
        this.draftInvoice = draftInvoice;
    }

    public OrdersProcessingOption refundReasonCode(String refundReasonCode) {
        this.refundReasonCode = refundReasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getRefundReasonCode() {
        return this.refundReasonCode;
    }

    public void setRefundReasonCode(String refundReasonCode) {
        this.refundReasonCode = refundReasonCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrdersProcessingOption ordersProcessingOption = (OrdersProcessingOption)o;
        return Objects.equals(this.documentDate, ordersProcessingOption.documentDate) && Objects.equals(this.targetDate, ordersProcessingOption.targetDate) && Objects.equals((Object)this.collectionMethod, (Object)ordersProcessingOption.collectionMethod) && Objects.equals(this.paymentMethodId, ordersProcessingOption.paymentMethodId) && Objects.equals(this.paymentGatewayId, ordersProcessingOption.paymentGatewayId) && Objects.equals(this.draftInvoice, ordersProcessingOption.draftInvoice) && Objects.equals(this.refundReasonCode, ordersProcessingOption.refundReasonCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentDate, this.targetDate, this.collectionMethod, this.paymentMethodId, this.paymentGatewayId, this.draftInvoice, this.refundReasonCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrdersProcessingOption {\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    collectionMethod: ").append(this.toIndentedString((Object)this.collectionMethod)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    draftInvoice: ").append(this.toIndentedString(this.draftInvoice)).append("\n");
        sb.append("    refundReasonCode: ").append(this.toIndentedString(this.refundReasonCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CollectionMethodEnum {
        COLLECT_PAYMENT("collect_payment"),
        CREATE_INVOICE("create_invoice"),
        PROCESS_REFUND("process_refund"),
        RUN_BILLING("run_billing"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CollectionMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CollectionMethodEnum fromValue(String value) {
            for (CollectionMethodEnum b : CollectionMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CollectionMethodEnum> {
            public void write(JsonWriter jsonWriter, CollectionMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CollectionMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CollectionMethodEnum.fromValue(value);
            }
        }
    }
}

