/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.ListUsageResponse;
import org.openapitools.client.model.Usage;
import org.openapitools.client.model.UsageCreateRequest;
import org.openapitools.client.model.UsagePatchRequest;

public class UsageRecordsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UsageRecordsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageRecordsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createUsageCall(UsageCreateRequest usageCreateRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UsageCreateRequest localVarPostBody = usageCreateRequest;
        String localVarPath = "/usage_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (usageRecordFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_record.fields[]", usageRecordFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_item.fields[]", subscriptionItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUsageValidateBeforeCall(UsageCreateRequest usageCreateRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (usageCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'usageCreateRequest' when calling createUsage(Async)");
        }
        return this.createUsageCall(usageCreateRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Usage> createUsageWithHttpInfo(UsageCreateRequest usageCreateRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createUsageValidateBeforeCall(usageCreateRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Usage>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createUsageAsync(UsageCreateRequest usageCreateRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Usage> _callback) throws ApiException {
        Call localVarCall = this.createUsageValidateBeforeCall(usageCreateRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Usage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateUsageParams createUsageParams(UsageCreateRequest usageCreateRequest) {
        return new CreateUsageParams(usageCreateRequest);
    }

    public Usage createUsage(UsageCreateRequest usageCreateRequest) throws ApiException {
        CreateUsageParams params = new CreateUsageParams(usageCreateRequest);
        return this.executeCreateUsageAPICall(params).getData();
    }

    public Usage createUsage(UsageCreateRequest usageCreateRequest, List<String> expand) throws ApiException {
        CreateUsageParams params = new CreateUsageParams(usageCreateRequest);
        params.expand(expand);
        return this.executeCreateUsageAPICall(params).getData();
    }

    public Usage createUsage(UsageCreateRequest usageCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateUsageParams params = new CreateUsageParams(usageCreateRequest).expand(expand).headers(headers);
        return this.executeCreateUsageAPICall(params).getData();
    }

    public Usage create(CreateUsageParams params) throws ApiException {
        return this.executeCreateUsageAPICall(params).getData();
    }

    public ApiResponse<Usage> createWithHttpInfo(CreateUsageParams params) throws ApiException {
        return this.executeCreateUsageAPICall(params);
    }

    ApiResponse<Usage> executeCreateUsageAPICall(CreateUsageParams params) throws ApiException {
        return this.createUsageWithHttpInfo(params.usageCreateRequest, params.fields, params.usageRecordFields, params.accountFields, params.subscriptionFields, params.subscriptionItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteUsageCall(String id, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/usage_records/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUsageValidateBeforeCall(String id, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteUsage(Async)");
        }
        return this.deleteUsageCall(id, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteUsageWithHttpInfo(String id, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteUsageValidateBeforeCall(id, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteUsageAsync(String id, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUsageValidateBeforeCall(id, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteUsageParams deleteUsageParams(String id) {
        return new DeleteUsageParams(id);
    }

    public void deleteUsage(String id) throws ApiException {
        DeleteUsageParams params = new DeleteUsageParams(id);
        this.executeDeleteUsageAPICall(params);
    }

    public void deleteUsage(String id, Headers headers) throws ApiException {
        DeleteUsageParams params = new DeleteUsageParams(id).headers(headers);
        this.executeDeleteUsageAPICall(params);
    }

    public void delete(DeleteUsageParams params) throws ApiException {
        this.executeDeleteUsageAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteUsageParams params) throws ApiException {
        return this.executeDeleteUsageAPICall(params);
    }

    ApiResponse<Void> executeDeleteUsageAPICall(DeleteUsageParams params) throws ApiException {
        return this.deleteUsageWithHttpInfo(params.id, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getUsageCall(String id, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/usage_records/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (usageRecordFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_record.fields[]", usageRecordFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_item.fields[]", subscriptionItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsageValidateBeforeCall(String id, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUsage(Async)");
        }
        return this.getUsageCall(id, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Usage> getUsageWithHttpInfo(String id, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getUsageValidateBeforeCall(id, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Usage>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getUsageAsync(String id, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Usage> _callback) throws ApiException {
        Call localVarCall = this.getUsageValidateBeforeCall(id, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Usage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetUsageParams getUsageParams(String id) {
        return new GetUsageParams(id);
    }

    public Usage getUsage(String id) throws ApiException {
        GetUsageParams params = new GetUsageParams(id);
        return this.executeGetUsageAPICall(params).getData();
    }

    public Usage getUsage(String id, List<String> expand) throws ApiException {
        GetUsageParams params = new GetUsageParams(id);
        params.expand(expand);
        return this.executeGetUsageAPICall(params).getData();
    }

    public Usage getUsage(String id, List<String> expand, Headers headers) throws ApiException {
        GetUsageParams params = new GetUsageParams(id).expand(expand).headers(headers);
        return this.executeGetUsageAPICall(params).getData();
    }

    public Usage get(GetUsageParams params) throws ApiException {
        return this.executeGetUsageAPICall(params).getData();
    }

    public ApiResponse<Usage> getWithHttpInfo(GetUsageParams params) throws ApiException {
        return this.executeGetUsageAPICall(params);
    }

    ApiResponse<Usage> executeGetUsageAPICall(GetUsageParams params) throws ApiException {
        return this.getUsageWithHttpInfo(params.id, params.fields, params.usageRecordFields, params.accountFields, params.subscriptionFields, params.subscriptionItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getUsageRecordsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/usage_records";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (usageRecordFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_record.fields[]", usageRecordFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_item.fields[]", subscriptionItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsageRecordsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getUsageRecordsCall(cursor, expand, filter, sort, pageSize, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<ListUsageResponse> getUsageRecordsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getUsageRecordsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ListUsageResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getUsageRecordsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<ListUsageResponse> _callback) throws ApiException {
        Call localVarCall = this.getUsageRecordsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ListUsageResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetUsageRecordsParams getUsageRecordsParams() {
        return new GetUsageRecordsParams();
    }

    public ListUsageResponse getUsageRecords() throws ApiException {
        GetUsageRecordsParams params = new GetUsageRecordsParams();
        return this.executeGetUsageRecordsAPICall(params).getData();
    }

    public ListUsageResponse getUsageRecords(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetUsageRecordsParams params = new GetUsageRecordsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetUsageRecordsAPICall(params).getData();
    }

    public ListUsageResponse getUsageRecords(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetUsageRecordsParams params = new GetUsageRecordsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetUsageRecordsAPICall(params).getData();
    }

    public ListUsageResponse list(GetUsageRecordsParams params) throws ApiException {
        return this.executeGetUsageRecordsAPICall(params).getData();
    }

    public ApiResponse<ListUsageResponse> listWithHttpInfo(GetUsageRecordsParams params) throws ApiException {
        return this.executeGetUsageRecordsAPICall(params);
    }

    ApiResponse<ListUsageResponse> executeGetUsageRecordsAPICall(GetUsageRecordsParams params) throws ApiException {
        return this.getUsageRecordsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.usageRecordFields, params.accountFields, params.subscriptionFields, params.subscriptionItemFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateUsageCall(String id, UsagePatchRequest usagePatchRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UsagePatchRequest localVarPostBody = usagePatchRequest;
        String localVarPath = "/usage_records/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (usageRecordFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_record.fields[]", usageRecordFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_item.fields[]", subscriptionItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUsageValidateBeforeCall(String id, UsagePatchRequest usagePatchRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateUsage(Async)");
        }
        if (usagePatchRequest == null) {
            throw new ApiException("Missing the required parameter 'usagePatchRequest' when calling updateUsage(Async)");
        }
        return this.updateUsageCall(id, usagePatchRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Usage> updateUsageWithHttpInfo(String id, UsagePatchRequest usagePatchRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateUsageValidateBeforeCall(id, usagePatchRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Usage>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateUsageAsync(String id, UsagePatchRequest usagePatchRequest, List<String> fields, List<String> usageRecordFields, List<String> accountFields, List<String> subscriptionFields, List<String> subscriptionItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Usage> _callback) throws ApiException {
        Call localVarCall = this.updateUsageValidateBeforeCall(id, usagePatchRequest, fields, usageRecordFields, accountFields, subscriptionFields, subscriptionItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Usage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateUsageParams updateUsageParams(String id, UsagePatchRequest usagePatchRequest) {
        return new UpdateUsageParams(id, usagePatchRequest);
    }

    public Usage updateUsage(String id, UsagePatchRequest usagePatchRequest) throws ApiException {
        UpdateUsageParams params = new UpdateUsageParams(id, usagePatchRequest);
        return this.executeUpdateUsageAPICall(params).getData();
    }

    public Usage updateUsage(String id, UsagePatchRequest usagePatchRequest, List<String> expand) throws ApiException {
        UpdateUsageParams params = new UpdateUsageParams(id, usagePatchRequest);
        params.expand(expand);
        return this.executeUpdateUsageAPICall(params).getData();
    }

    public Usage updateUsage(String id, UsagePatchRequest usagePatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateUsageParams params = new UpdateUsageParams(id, usagePatchRequest).expand(expand).headers(headers);
        return this.executeUpdateUsageAPICall(params).getData();
    }

    public Usage update(UpdateUsageParams params) throws ApiException {
        return this.executeUpdateUsageAPICall(params).getData();
    }

    public ApiResponse<Usage> updateWithHttpInfo(UpdateUsageParams params) throws ApiException {
        return this.executeUpdateUsageAPICall(params);
    }

    ApiResponse<Usage> executeUpdateUsageAPICall(UpdateUsageParams params) throws ApiException {
        return this.updateUsageWithHttpInfo(params.id, params.usagePatchRequest, params.fields, params.usageRecordFields, params.accountFields, params.subscriptionFields, params.subscriptionItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateUsageParams {
        private final String id;
        private final UsagePatchRequest usagePatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> usageRecordFields;
        private List<String> accountFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateUsageParams(String id, UsagePatchRequest usagePatchRequest) {
            this.id = id;
            this.usagePatchRequest = usagePatchRequest;
        }

        public UpdateUsageParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateUsageParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateUsageParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateUsageParams usageRecordFields(List<String> usageRecordFields) {
            this.usageRecordFields = usageRecordFields;
            return this;
        }

        public UpdateUsageParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UpdateUsageParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public UpdateUsageParams subscriptionItemFields(List<String> subscriptionItemFields) {
            this.subscriptionItemFields = subscriptionItemFields;
            return this;
        }

        public UpdateUsageParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateUsageParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateUsageParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetUsageRecordsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> usageRecordFields;
        private List<String> accountFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetUsageRecordsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetUsageRecordsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetUsageRecordsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetUsageRecordsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetUsageRecordsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetUsageRecordsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetUsageRecordsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetUsageRecordsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetUsageRecordsParams usageRecordFields(List<String> usageRecordFields) {
            this.usageRecordFields = usageRecordFields;
            return this;
        }

        public GetUsageRecordsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetUsageRecordsParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetUsageRecordsParams subscriptionItemFields(List<String> subscriptionItemFields) {
            this.subscriptionItemFields = subscriptionItemFields;
            return this;
        }
    }

    public static class GetUsageParams {
        private final String id;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> usageRecordFields;
        private List<String> accountFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetUsageParams(String id) {
            this.id = id;
        }

        public GetUsageParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetUsageParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetUsageParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetUsageParams usageRecordFields(List<String> usageRecordFields) {
            this.usageRecordFields = usageRecordFields;
            return this;
        }

        public GetUsageParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetUsageParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetUsageParams subscriptionItemFields(List<String> subscriptionItemFields) {
            this.subscriptionItemFields = subscriptionItemFields;
            return this;
        }

        public GetUsageParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetUsageParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetUsageParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteUsageParams {
        private final String id;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteUsageParams(String id) {
            this.id = id;
        }

        public DeleteUsageParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateUsageParams {
        private final UsageCreateRequest usageCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> usageRecordFields;
        private List<String> accountFields;
        private List<String> subscriptionFields;
        private List<String> subscriptionItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateUsageParams(UsageCreateRequest usageCreateRequest) {
            this.usageCreateRequest = usageCreateRequest;
        }

        public CreateUsageParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateUsageParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateUsageParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateUsageParams usageRecordFields(List<String> usageRecordFields) {
            this.usageRecordFields = usageRecordFields;
            return this;
        }

        public CreateUsageParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateUsageParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public CreateUsageParams subscriptionItemFields(List<String> subscriptionItemFields) {
            this.subscriptionItemFields = subscriptionItemFields;
            return this;
        }

        public CreateUsageParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateUsageParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateUsageParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

