/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CustomObjectRecordBatchRequest;
import com.zuora.model.CustomObjectRecordWithAllFields;
import com.zuora.model.CustomObjectRecordWithOnlyCustomFields;
import com.zuora.model.CustomObjectRecordsBatchUpdatePartialSuccessResponse;
import com.zuora.model.PostCustomObjectRecordsRequest;
import com.zuora.model.PostCustomObjectRecordsResponse;
import com.zuora.model.QueryCustomObjectRecordsResponse;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class CustomObjectRecordsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomObjectRecordsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectRecordsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteCustomObjectRecordByIDCall(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/records/default/{object}/{id}".replace("{object}", this.localVarApiClient.escapeString(_object.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCustomObjectRecordByIDValidateBeforeCall(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling deleteCustomObjectRecordByID(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteCustomObjectRecordByID(Async)");
        }
        return this.deleteCustomObjectRecordByIDCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    protected URI deleteCustomObjectRecordByID(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        ApiResponse<URI> localVarResp = this.deleteCustomObjectRecordByIDWithHttpInfo(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<URI> deleteCustomObjectRecordByIDWithHttpInfo(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        Call localVarCall = this.deleteCustomObjectRecordByIDValidateBeforeCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<URI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCustomObjectRecordByIDAsync(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback<URI> _callback) throws ApiException {
        Call localVarCall = this.deleteCustomObjectRecordByIDValidateBeforeCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<URI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteCustomObjectRecordByIDApi deleteCustomObjectRecordByIDApi(String _object, UUID id) {
        return new DeleteCustomObjectRecordByIDApi(_object, id);
    }

    private Call getAllRecordsForCustomObjectTypeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String q, String ids, Integer page, Integer pageSize, String cursor, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/records/default/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (ids != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ids", ids));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllRecordsForCustomObjectTypeValidateBeforeCall(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String q, String ids, Integer page, Integer pageSize, String cursor, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling getAllRecordsForCustomObjectType(Async)");
        }
        return this.getAllRecordsForCustomObjectTypeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, q, ids, page, pageSize, cursor, _callback);
    }

    protected QueryCustomObjectRecordsResponse getAllRecordsForCustomObjectType(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String q, String ids, Integer page, Integer pageSize, String cursor) throws ApiException {
        ApiResponse<QueryCustomObjectRecordsResponse> localVarResp = this.getAllRecordsForCustomObjectTypeWithHttpInfo(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, q, ids, page, pageSize, cursor);
        return localVarResp.getData();
    }

    private ApiResponse<QueryCustomObjectRecordsResponse> getAllRecordsForCustomObjectTypeWithHttpInfo(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String q, String ids, Integer page, Integer pageSize, String cursor) throws ApiException {
        Call localVarCall = this.getAllRecordsForCustomObjectTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, q, ids, page, pageSize, cursor, null);
        Type localVarReturnType = new TypeToken<QueryCustomObjectRecordsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAllRecordsForCustomObjectTypeAsync(String _object, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String q, String ids, Integer page, Integer pageSize, String cursor, ApiCallback<QueryCustomObjectRecordsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAllRecordsForCustomObjectTypeValidateBeforeCall(_object, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, q, ids, page, pageSize, cursor, _callback);
        Type localVarReturnType = new TypeToken<QueryCustomObjectRecordsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAllRecordsForCustomObjectTypeApi getAllRecordsForCustomObjectTypeApi(String _object) {
        return new GetAllRecordsForCustomObjectTypeApi(_object);
    }

    private Call getCustomObjectRecordByIDCall(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/records/default/{object}/{id}".replace("{object}", this.localVarApiClient.escapeString(_object.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectRecordByIDValidateBeforeCall(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling getCustomObjectRecordByID(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCustomObjectRecordByID(Async)");
        }
        return this.getCustomObjectRecordByIDCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    protected CustomObjectRecordWithAllFields getCustomObjectRecordByID(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectRecordWithAllFields> localVarResp = this.getCustomObjectRecordByIDWithHttpInfo(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectRecordWithAllFields> getCustomObjectRecordByIDWithHttpInfo(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getCustomObjectRecordByIDValidateBeforeCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCustomObjectRecordByIDAsync(String _object, UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectRecordByIDValidateBeforeCall(_object, id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectRecordByIDApi getCustomObjectRecordByIDApi(String _object, UUID id) {
        return new GetCustomObjectRecordByIDApi(_object, id);
    }

    private Call patchPartialUpdateCustomObjectRecordCall(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomObjectRecordWithOnlyCustomFields localVarPostBody = objectRecordPatchRequest;
        String localVarPath = "/objects/records/default/{object}/{id}".replace("{object}", this.localVarApiClient.escapeString(_object.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/merge-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchPartialUpdateCustomObjectRecordValidateBeforeCall(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling patchPartialUpdateCustomObjectRecord(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchPartialUpdateCustomObjectRecord(Async)");
        }
        if (objectRecordPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'objectRecordPatchRequest' when calling patchPartialUpdateCustomObjectRecord(Async)");
        }
        return this.patchPartialUpdateCustomObjectRecordCall(_object, id, objectRecordPatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    protected CustomObjectRecordWithAllFields patchPartialUpdateCustomObjectRecord(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectRecordWithAllFields> localVarResp = this.patchPartialUpdateCustomObjectRecordWithHttpInfo(_object, id, objectRecordPatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectRecordWithAllFields> patchPartialUpdateCustomObjectRecordWithHttpInfo(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        Call localVarCall = this.patchPartialUpdateCustomObjectRecordValidateBeforeCall(_object, id, objectRecordPatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchPartialUpdateCustomObjectRecordAsync(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
        Call localVarCall = this.patchPartialUpdateCustomObjectRecordValidateBeforeCall(_object, id, objectRecordPatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchPartialUpdateCustomObjectRecordApi patchPartialUpdateCustomObjectRecordApi(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest) {
        return new PatchPartialUpdateCustomObjectRecordApi(_object, id, objectRecordPatchRequest);
    }

    private Call postCustomObjectRecordsCall(String _object, PostCustomObjectRecordsRequest customObjectsRecords, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostCustomObjectRecordsRequest localVarPostBody = customObjectsRecords;
        String localVarPath = "/objects/records/default/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCustomObjectRecordsValidateBeforeCall(String _object, PostCustomObjectRecordsRequest customObjectsRecords, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling postCustomObjectRecords(Async)");
        }
        if (customObjectsRecords == null) {
            throw new ApiException("Missing the required parameter 'customObjectsRecords' when calling postCustomObjectRecords(Async)");
        }
        return this.postCustomObjectRecordsCall(_object, customObjectsRecords, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    protected PostCustomObjectRecordsResponse postCustomObjectRecords(String _object, PostCustomObjectRecordsRequest customObjectsRecords, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        ApiResponse<PostCustomObjectRecordsResponse> localVarResp = this.postCustomObjectRecordsWithHttpInfo(_object, customObjectsRecords, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PostCustomObjectRecordsResponse> postCustomObjectRecordsWithHttpInfo(String _object, PostCustomObjectRecordsRequest customObjectsRecords, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        Call localVarCall = this.postCustomObjectRecordsValidateBeforeCall(_object, customObjectsRecords, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PostCustomObjectRecordsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postCustomObjectRecordsAsync(String _object, PostCustomObjectRecordsRequest customObjectsRecords, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback<PostCustomObjectRecordsResponse> _callback) throws ApiException {
        Call localVarCall = this.postCustomObjectRecordsValidateBeforeCall(_object, customObjectsRecords, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PostCustomObjectRecordsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCustomObjectRecordsApi postCustomObjectRecordsApi(String _object, PostCustomObjectRecordsRequest customObjectsRecords) {
        return new PostCustomObjectRecordsApi(_object, customObjectsRecords);
    }

    private Call postCustomObjectRecordsBatchUpdateOrDeleteCall(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomObjectRecordBatchRequest localVarPostBody = customObjectRecordBatchRequest;
        String localVarPath = "/objects/batch/default/{object}".replace("{object}", this.localVarApiClient.escapeString(_object.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCustomObjectRecordsBatchUpdateOrDeleteValidateBeforeCall(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling postCustomObjectRecordsBatchUpdateOrDelete(Async)");
        }
        if (customObjectRecordBatchRequest == null) {
            throw new ApiException("Missing the required parameter 'customObjectRecordBatchRequest' when calling postCustomObjectRecordsBatchUpdateOrDelete(Async)");
        }
        return this.postCustomObjectRecordsBatchUpdateOrDeleteCall(_object, customObjectRecordBatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    protected CustomObjectRecordsBatchUpdatePartialSuccessResponse postCustomObjectRecordsBatchUpdateOrDelete(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectRecordsBatchUpdatePartialSuccessResponse> localVarResp = this.postCustomObjectRecordsBatchUpdateOrDeleteWithHttpInfo(_object, customObjectRecordBatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectRecordsBatchUpdatePartialSuccessResponse> postCustomObjectRecordsBatchUpdateOrDeleteWithHttpInfo(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion) throws ApiException {
        Call localVarCall = this.postCustomObjectRecordsBatchUpdateOrDeleteValidateBeforeCall(_object, customObjectRecordBatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectRecordsBatchUpdatePartialSuccessResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postCustomObjectRecordsBatchUpdateOrDeleteAsync(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, ApiCallback<CustomObjectRecordsBatchUpdatePartialSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.postCustomObjectRecordsBatchUpdateOrDeleteValidateBeforeCall(_object, customObjectRecordBatchRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectRecordsBatchUpdatePartialSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCustomObjectRecordsBatchUpdateOrDeleteApi postCustomObjectRecordsBatchUpdateOrDeleteApi(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest) {
        return new PostCustomObjectRecordsBatchUpdateOrDeleteApi(_object, customObjectRecordBatchRequest);
    }

    private Call putCustomObjectRecordCall(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String ifMatch, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomObjectRecordWithOnlyCustomFields localVarPostBody = objectRecordRequest;
        String localVarPath = "/objects/records/default/{object}/{id}".replace("{object}", this.localVarApiClient.escapeString(_object.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putCustomObjectRecordValidateBeforeCall(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String ifMatch, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_object == null) {
            throw new ApiException("Missing the required parameter '_object' when calling putCustomObjectRecord(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling putCustomObjectRecord(Async)");
        }
        if (objectRecordRequest == null) {
            throw new ApiException("Missing the required parameter 'objectRecordRequest' when calling putCustomObjectRecord(Async)");
        }
        return this.putCustomObjectRecordCall(_object, id, objectRecordRequest, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, ifMatch, zuoraVersion, _callback);
    }

    protected CustomObjectRecordWithAllFields putCustomObjectRecord(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String ifMatch, String zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectRecordWithAllFields> localVarResp = this.putCustomObjectRecordWithHttpInfo(_object, id, objectRecordRequest, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, ifMatch, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectRecordWithAllFields> putCustomObjectRecordWithHttpInfo(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String ifMatch, String zuoraVersion) throws ApiException {
        Call localVarCall = this.putCustomObjectRecordValidateBeforeCall(_object, id, objectRecordRequest, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, ifMatch, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call putCustomObjectRecordAsync(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String ifMatch, String zuoraVersion, ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
        Call localVarCall = this.putCustomObjectRecordValidateBeforeCall(_object, id, objectRecordRequest, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, ifMatch, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectRecordWithAllFields>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PutCustomObjectRecordApi putCustomObjectRecordApi(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest) {
        return new PutCustomObjectRecordApi(_object, id, objectRecordRequest);
    }

    public class PutCustomObjectRecordApi {
        private final String _object;
        private final UUID id;
        private final CustomObjectRecordWithOnlyCustomFields objectRecordRequest;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String ifMatch;
        private String zuoraVersion;

        private PutCustomObjectRecordApi(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordRequest) {
            this._object = _object;
            this.id = id;
            this.objectRecordRequest = objectRecordRequest;
        }

        public PutCustomObjectRecordApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PutCustomObjectRecordApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PutCustomObjectRecordApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PutCustomObjectRecordApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PutCustomObjectRecordApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PutCustomObjectRecordApi ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public PutCustomObjectRecordApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.putCustomObjectRecordCall(this._object, this.id, this.objectRecordRequest, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.ifMatch, this.zuoraVersion, _callback);
        }

        public CustomObjectRecordWithAllFields execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.putCustomObjectRecordWithHttpInfo(this._object, this.id, this.objectRecordRequest, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.ifMatch, this.zuoraVersion);
            return (CustomObjectRecordWithAllFields)localVarResp.getData();
        }

        private ApiResponse<CustomObjectRecordWithAllFields> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.putCustomObjectRecordWithHttpInfo(this._object, this.id, this.objectRecordRequest, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.ifMatch, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.putCustomObjectRecordAsync(this._object, this.id, this.objectRecordRequest, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.ifMatch, this.zuoraVersion, _callback);
        }
    }

    public class PostCustomObjectRecordsBatchUpdateOrDeleteApi {
        private final String _object;
        private final CustomObjectRecordBatchRequest customObjectRecordBatchRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;

        private PostCustomObjectRecordsBatchUpdateOrDeleteApi(String _object, CustomObjectRecordBatchRequest customObjectRecordBatchRequest) {
            this._object = _object;
            this.customObjectRecordBatchRequest = customObjectRecordBatchRequest;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostCustomObjectRecordsBatchUpdateOrDeleteApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsBatchUpdateOrDeleteCall(this._object, this.customObjectRecordBatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectRecordsBatchUpdatePartialSuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.postCustomObjectRecordsBatchUpdateOrDeleteWithHttpInfo(this._object, this.customObjectRecordBatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectRecordsBatchUpdatePartialSuccessResponse)localVarResp.getData();
        }

        private ApiResponse<CustomObjectRecordsBatchUpdatePartialSuccessResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsBatchUpdateOrDeleteWithHttpInfo(this._object, this.customObjectRecordBatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectRecordsBatchUpdatePartialSuccessResponse> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsBatchUpdateOrDeleteAsync(this._object, this.customObjectRecordBatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class PostCustomObjectRecordsApi {
        private final String _object;
        private final PostCustomObjectRecordsRequest customObjectsRecords;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;

        private PostCustomObjectRecordsApi(String _object, PostCustomObjectRecordsRequest customObjectsRecords) {
            this._object = _object;
            this.customObjectsRecords = customObjectsRecords;
        }

        public PostCustomObjectRecordsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostCustomObjectRecordsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostCustomObjectRecordsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostCustomObjectRecordsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostCustomObjectRecordsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostCustomObjectRecordsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostCustomObjectRecordsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsCall(this._object, this.customObjectsRecords, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public PostCustomObjectRecordsResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.postCustomObjectRecordsWithHttpInfo(this._object, this.customObjectsRecords, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (PostCustomObjectRecordsResponse)localVarResp.getData();
        }

        private ApiResponse<PostCustomObjectRecordsResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsWithHttpInfo(this._object, this.customObjectsRecords, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PostCustomObjectRecordsResponse> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.postCustomObjectRecordsAsync(this._object, this.customObjectsRecords, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class PatchPartialUpdateCustomObjectRecordApi {
        private final String _object;
        private final UUID id;
        private final CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;

        private PatchPartialUpdateCustomObjectRecordApi(String _object, UUID id, CustomObjectRecordWithOnlyCustomFields objectRecordPatchRequest) {
            this._object = _object;
            this.id = id;
            this.objectRecordPatchRequest = objectRecordPatchRequest;
        }

        public PatchPartialUpdateCustomObjectRecordApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PatchPartialUpdateCustomObjectRecordApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.patchPartialUpdateCustomObjectRecordCall(this._object, this.id, this.objectRecordPatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectRecordWithAllFields execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.patchPartialUpdateCustomObjectRecordWithHttpInfo(this._object, this.id, this.objectRecordPatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectRecordWithAllFields)localVarResp.getData();
        }

        private ApiResponse<CustomObjectRecordWithAllFields> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.patchPartialUpdateCustomObjectRecordWithHttpInfo(this._object, this.id, this.objectRecordPatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.patchPartialUpdateCustomObjectRecordAsync(this._object, this.id, this.objectRecordPatchRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class GetCustomObjectRecordByIDApi {
        private final String _object;
        private final UUID id;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;

        private GetCustomObjectRecordByIDApi(String _object, UUID id) {
            this._object = _object;
            this.id = id;
        }

        public GetCustomObjectRecordByIDApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCustomObjectRecordByIDApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCustomObjectRecordByIDApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCustomObjectRecordByIDApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCustomObjectRecordByIDApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCustomObjectRecordByIDApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.getCustomObjectRecordByIDCall(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectRecordWithAllFields execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.getCustomObjectRecordByIDWithHttpInfo(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectRecordWithAllFields)localVarResp.getData();
        }

        private ApiResponse<CustomObjectRecordWithAllFields> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.getCustomObjectRecordByIDWithHttpInfo(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectRecordWithAllFields> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.getCustomObjectRecordByIDAsync(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class GetAllRecordsForCustomObjectTypeApi {
        private final String _object;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String q;
        private String ids;
        private Integer page;
        private Integer pageSize;
        private String cursor;

        private GetAllRecordsForCustomObjectTypeApi(String _object) {
            this._object = _object;
        }

        public GetAllRecordsForCustomObjectTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi q(String q) {
            this.q = q;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi ids(String ids) {
            this.ids = ids;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetAllRecordsForCustomObjectTypeApi cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.getAllRecordsForCustomObjectTypeCall(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.q, this.ids, this.page, this.pageSize, this.cursor, _callback);
        }

        public QueryCustomObjectRecordsResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.getAllRecordsForCustomObjectTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.q, this.ids, this.page, this.pageSize, this.cursor);
            return (QueryCustomObjectRecordsResponse)localVarResp.getData();
        }

        private ApiResponse<QueryCustomObjectRecordsResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.getAllRecordsForCustomObjectTypeWithHttpInfo(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.q, this.ids, this.page, this.pageSize, this.cursor);
        }

        public Call executeAsync(ApiCallback<QueryCustomObjectRecordsResponse> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.getAllRecordsForCustomObjectTypeAsync(this._object, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.q, this.ids, this.page, this.pageSize, this.cursor, _callback);
        }
    }

    public class DeleteCustomObjectRecordByIDApi {
        private final String _object;
        private final UUID id;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;

        private DeleteCustomObjectRecordByIDApi(String _object, UUID id) {
            this._object = _object;
            this.id = id;
        }

        public DeleteCustomObjectRecordByIDApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteCustomObjectRecordByIDApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteCustomObjectRecordByIDApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteCustomObjectRecordByIDApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteCustomObjectRecordByIDApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteCustomObjectRecordByIDApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectRecordsApi.this.deleteCustomObjectRecordByIDCall(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public URI execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectRecordsApi.this.deleteCustomObjectRecordByIDWithHttpInfo(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (URI)localVarResp.getData();
        }

        private ApiResponse<URI> executeWithHttpInfo() throws ApiException {
            return CustomObjectRecordsApi.this.deleteCustomObjectRecordByIDWithHttpInfo(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<URI> _callback) throws ApiException {
            return CustomObjectRecordsApi.this.deleteCustomObjectRecordByIDAsync(this._object, this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }
}

