/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.TaxMode;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"percentage", "amount", "roundedAmount", "taxCode", "taxMode"})
public class SurchargePricing {
    public static final String JSON_PROPERTY_PERCENTAGE = "percentage";
    private Double percentage;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Double amount;
    public static final String JSON_PROPERTY_ROUNDED_AMOUNT = "roundedAmount";
    private String roundedAmount;
    public static final String JSON_PROPERTY_TAX_CODE = "taxCode";
    private String taxCode;
    public static final String JSON_PROPERTY_TAX_MODE = "taxMode";
    private TaxMode taxMode = TaxMode.TAX_EXCLUSIVE;

    public SurchargePricing() {
    }

    public SurchargePricing percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPercentage() {
        return this.percentage;
    }

    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public SurchargePricing amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public SurchargePricing roundedAmount(String roundedAmount) {
        this.roundedAmount = roundedAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="roundedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoundedAmount() {
        return this.roundedAmount;
    }

    @JsonProperty(value="roundedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoundedAmount(String roundedAmount) {
        this.roundedAmount = roundedAmount;
    }

    public SurchargePricing taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="taxCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxCode() {
        return this.taxCode;
    }

    @JsonProperty(value="taxCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public SurchargePricing taxMode(TaxMode taxMode) {
        this.taxMode = taxMode;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="taxMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TaxMode getTaxMode() {
        return this.taxMode;
    }

    @JsonProperty(value="taxMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxMode(TaxMode taxMode) {
        this.taxMode = taxMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SurchargePricing surchargePricing = (SurchargePricing)o;
        return Objects.equals(this.percentage, surchargePricing.percentage) && Objects.equals(this.amount, surchargePricing.amount) && Objects.equals(this.roundedAmount, surchargePricing.roundedAmount) && Objects.equals(this.taxCode, surchargePricing.taxCode) && Objects.equals((Object)this.taxMode, (Object)surchargePricing.taxMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.percentage, this.amount, this.roundedAmount, this.taxCode, this.taxMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SurchargePricing {\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    roundedAmount: ").append(this.toIndentedString(this.roundedAmount)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxMode: ").append(this.toIndentedString((Object)this.taxMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SurchargePricingBuilder builder() {
        return new SurchargePricingBuilder();
    }

    public SurchargePricing(Double percentage, Double amount, String roundedAmount, String taxCode, TaxMode taxMode) {
        this.percentage = percentage;
        this.amount = amount;
        this.roundedAmount = roundedAmount;
        this.taxCode = taxCode;
        this.taxMode = taxMode;
    }

    public static class SurchargePricingBuilder {
        private Double percentage;
        private Double amount;
        private String roundedAmount;
        private String taxCode;
        private TaxMode taxMode;

        SurchargePricingBuilder() {
        }

        public SurchargePricingBuilder percentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public SurchargePricingBuilder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public SurchargePricingBuilder roundedAmount(String roundedAmount) {
            this.roundedAmount = roundedAmount;
            return this;
        }

        public SurchargePricingBuilder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public SurchargePricingBuilder taxMode(TaxMode taxMode) {
            this.taxMode = taxMode;
            return this;
        }

        public SurchargePricing build() {
            return new SurchargePricing(this.percentage, this.amount, this.roundedAmount, this.taxCode, this.taxMode);
        }

        public String toString() {
            return "SurchargePricing.SurchargePricingBuilder(percentage=" + this.percentage + ", amount=" + this.amount + ", roundedAmount=" + this.roundedAmount + ", taxCode=" + this.taxCode + ", taxMode=" + this.taxMode + ")";
        }
    }
}

