/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.AttributeValue;
import com.zuora.zevolve.api.model.ChargeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"attributes", "chargeDefinitions"})
public class AttributeCombination {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private List<@Valid AttributeValue> attributes = new ArrayList<AttributeValue>();
    public static final String JSON_PROPERTY_CHARGE_DEFINITIONS = "chargeDefinitions";
    private List<@Valid ChargeDefinition> chargeDefinitions = new ArrayList<ChargeDefinition>();

    public AttributeCombination() {
    }

    public AttributeCombination attributes(List<@Valid AttributeValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public AttributeCombination addAttributesItem(AttributeValue attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<AttributeValue>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid AttributeValue> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(List<@Valid AttributeValue> attributes) {
        this.attributes = attributes;
    }

    public AttributeCombination chargeDefinitions(List<@Valid ChargeDefinition> chargeDefinitions) {
        this.chargeDefinitions = chargeDefinitions;
        return this;
    }

    public AttributeCombination addChargeDefinitionsItem(ChargeDefinition chargeDefinitionsItem) {
        if (this.chargeDefinitions == null) {
            this.chargeDefinitions = new ArrayList<ChargeDefinition>();
        }
        this.chargeDefinitions.add(chargeDefinitionsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="chargeDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid ChargeDefinition> getChargeDefinitions() {
        return this.chargeDefinitions;
    }

    @JsonProperty(value="chargeDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeDefinitions(List<@Valid ChargeDefinition> chargeDefinitions) {
        this.chargeDefinitions = chargeDefinitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeCombination attributeCombination = (AttributeCombination)o;
        return Objects.equals(this.attributes, attributeCombination.attributes) && Objects.equals(this.chargeDefinitions, attributeCombination.chargeDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.chargeDefinitions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttributeCombination {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    chargeDefinitions: ").append(this.toIndentedString(this.chargeDefinitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AttributeCombinationBuilder builder() {
        return new AttributeCombinationBuilder();
    }

    public AttributeCombination(List<@Valid AttributeValue> attributes, List<@Valid ChargeDefinition> chargeDefinitions) {
        this.attributes = attributes;
        this.chargeDefinitions = chargeDefinitions;
    }

    public static class AttributeCombinationBuilder {
        private List<@Valid AttributeValue> attributes;
        private List<@Valid ChargeDefinition> chargeDefinitions;

        AttributeCombinationBuilder() {
        }

        public AttributeCombinationBuilder attributes(List<@Valid AttributeValue> attributes) {
            this.attributes = attributes;
            return this;
        }

        public AttributeCombinationBuilder chargeDefinitions(List<@Valid ChargeDefinition> chargeDefinitions) {
            this.chargeDefinitions = chargeDefinitions;
            return this;
        }

        public AttributeCombination build() {
            return new AttributeCombination(this.attributes, this.chargeDefinitions);
        }

        public String toString() {
            return "AttributeCombination.AttributeCombinationBuilder(attributes=" + this.attributes + ", chargeDefinitions=" + this.chargeDefinitions + ")";
        }
    }
}

