/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.plan;

import com.zuora.sdk.catalog.plan.ProductRatePlanNumber;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.common.NullHelper;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.values.IsoDate;
import com.zuora.zevolve.api.model.RatePlanNetsuite;
import com.zuora.zevolve.api.model.UpdateProductRatePlanRequest;
import com.zuora.zevolve.api.model.Value;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class UpdatedPlan
implements ApiObject<UpdateProductRatePlanRequest> {
    private String id;
    private String name;
    private String description;
    private String startDate;
    private String endDate;
    private String productId;
    private Set<String> activeCurrencies;
    private ProductRatePlanNumber productRatePlanNumber;
    private List<String> externalRateplanIds;
    private String externalIdSourceSystem;
    private Map<String, Value> customFields;
    private RatePlanNetsuite netsuite;
    private Integer grade;

    private UpdatedPlan(String id, ProductRatePlanNumber ratePlanNumber) {
        this.id = id;
        this.productRatePlanNumber = ratePlanNumber;
    }

    public static UpdatedPlan withId(String id) {
        return new UpdatedPlan(id, null);
    }

    public static UpdatedPlan withRatePlanNumber(ProductRatePlanNumber ratePlanNumber) {
        return new UpdatedPlan(null, ratePlanNumber);
    }

    public UpdatedPlan withName(String name) {
        this.name = name;
        return this;
    }

    public UpdatedPlan withDescription(String description) {
        this.description = description;
        return this;
    }

    public UpdatedPlan withStartDate(IsoDate startDate) {
        this.startDate = ((LocalDate)startDate.value()).toString();
        return this;
    }

    public UpdatedPlan withEndDate(IsoDate endDate) {
        this.endDate = ((LocalDate)endDate.value()).toString();
        return this;
    }

    public UpdatedPlan withProductId(String productId) {
        this.productId = productId;
        return this;
    }

    public UpdatedPlan withActiveCurrencies(Set<String> activeCurrencies) {
        this.activeCurrencies = activeCurrencies;
        return this;
    }

    public UpdatedPlan withExternalRatePlanIds(List<String> externalRateplanIds) {
        this.externalRateplanIds = externalRateplanIds;
        return this;
    }

    public UpdatedPlan withExternalIdSourceSystem(String externalIdSourceSystem) {
        this.externalIdSourceSystem = externalIdSourceSystem;
        return this;
    }

    public UpdatedPlan withCustomFields(Map<String, Value> customFields) {
        this.customFields = customFields;
        return this;
    }

    public UpdatedPlan withNetsuite(RatePlanNetsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    public UpdatedPlan withGrade(Integer grade) {
        this.grade = grade;
        return this;
    }

    public UpdateProductRatePlanRequest toApi() {
        Validations.require((this.id != null || this.productRatePlanNumber != null ? 1 : 0) != 0, (String)"id or productRatePlanNumber is required");
        UpdateProductRatePlanRequest.UpdateProductRatePlanRequestBuilder builder = UpdateProductRatePlanRequest.builder();
        NullHelper.ifNotNull((Object)this.id, builder::id);
        NullHelper.ifNotNull((Object)this.name, builder::name);
        NullHelper.ifNotNull((Object)this.description, builder::description);
        NullHelper.ifNotNull((Object)this.startDate, builder::startDate);
        NullHelper.ifNotNull((Object)this.endDate, builder::endDate);
        NullHelper.ifNotNull((Object)this.productId, builder::productId);
        NullHelper.ifNotNull(this.activeCurrencies, set -> builder.activeCurrencies(new ArrayList<String>((Collection<String>)set)));
        NullHelper.ifNotNull((Object)((Object)this.productRatePlanNumber), number -> builder.productRatePlanNumber((String)number.value()));
        NullHelper.ifNotNull(this.externalRateplanIds, builder::externalRateplanId);
        NullHelper.ifNotNull((Object)this.externalIdSourceSystem, builder::externalIdSourceSystem);
        NullHelper.ifNotNull(this.customFields, builder::customFields);
        return builder.build();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getProductId() {
        return this.productId;
    }

    public Set<String> getActiveCurrencies() {
        return this.activeCurrencies;
    }

    public ProductRatePlanNumber getProductRatePlanNumber() {
        return this.productRatePlanNumber;
    }

    public List<String> getExternalRateplanIds() {
        return this.externalRateplanIds;
    }

    public String getExternalIdSourceSystem() {
        return this.externalIdSourceSystem;
    }

    public Map<String, Value> getCustomFields() {
        return this.customFields;
    }

    public RatePlanNetsuite getNetsuite() {
        return this.netsuite;
    }

    public Integer getGrade() {
        return this.grade;
    }
}

