/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.onetime;

import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.Charge;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.Tier;
import com.zuora.sdk.catalog.charge.Uom;
import com.zuora.sdk.error.ErrorCode;
import com.zuora.sdk.error.ErrorType;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class TieredCharge
extends Charge {
    private final List<Tier> tiers = new ArrayList<Tier>();
    private BigDecimal defaultQuantity = BigDecimal.ZERO;
    private Uom uom;

    private TieredCharge() {
    }

    static TieredCharge newInstance() {
        return new TieredCharge();
    }

    public TieredCharge withName(String name) {
        this.name = name;
        return this;
    }

    public TieredCharge with(Billing billing) {
        throw new SdkException(SdkError.error((ErrorType)ErrorType.bad_request, (ErrorCode)ErrorCode.invalid_request, (String)"One-time charges do not support billing options"));
    }

    public TieredCharge with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected TieredCharge with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public TieredCharge with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public TieredCharge with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public TieredCharge with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected TieredCharge with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    protected TieredCharge with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public TieredCharge with(Tier tier) {
        this.tiers.add(tier);
        return this;
    }

    public TieredCharge with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public TieredCharge with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public TieredCharge uom(Uom uom) {
        this.uom = uom;
        return this;
    }

    public TieredCharge withDefaultQuantity(BigDecimal defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
        return this;
    }

    public TieredCharge withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.ONE_TIME).chargeModel(ChargeModel.TIERED).unitOfMeasure((String)this.uom.value()).pricing(Pricing.builder().tiers(this.tiers.stream().map(Tier::toApi).collect(Collectors.toList())).build()).defaultQuantity(this.defaultQuantity != null ? Double.valueOf(this.defaultQuantity.doubleValue()) : null).build();
    }
}

