/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge;

import com.zuora.zevolve.api.model.PriceChangeOption;

public class SubscriptionRenewalOptions {
    private PriceChangeOption priceChangeOption;
    private Double priceIncreasePercentage;
    private Boolean useTenantDefaultForPriceChange;

    public static SubscriptionRenewalOptionsBuilder builder() {
        return new SubscriptionRenewalOptionsBuilder();
    }

    public PriceChangeOption getPriceChangeOption() {
        return this.priceChangeOption;
    }

    public Double getPriceIncreasePercentage() {
        return this.priceIncreasePercentage;
    }

    public Boolean getUseTenantDefaultForPriceChange() {
        return this.useTenantDefaultForPriceChange;
    }

    public SubscriptionRenewalOptions(PriceChangeOption priceChangeOption, Double priceIncreasePercentage, Boolean useTenantDefaultForPriceChange) {
        this.priceChangeOption = priceChangeOption;
        this.priceIncreasePercentage = priceIncreasePercentage;
        this.useTenantDefaultForPriceChange = useTenantDefaultForPriceChange;
    }

    public static class SubscriptionRenewalOptionsBuilder {
        private PriceChangeOption priceChangeOption;
        private Double priceIncreasePercentage;
        private Boolean useTenantDefaultForPriceChange;

        SubscriptionRenewalOptionsBuilder() {
        }

        public SubscriptionRenewalOptionsBuilder priceChangeOption(PriceChangeOption priceChangeOption) {
            this.priceChangeOption = priceChangeOption;
            return this;
        }

        public SubscriptionRenewalOptionsBuilder priceIncreasePercentage(Double priceIncreasePercentage) {
            this.priceIncreasePercentage = priceIncreasePercentage;
            return this;
        }

        public SubscriptionRenewalOptionsBuilder useTenantDefaultForPriceChange(Boolean useTenantDefaultForPriceChange) {
            this.useTenantDefaultForPriceChange = useTenantDefaultForPriceChange;
            return this;
        }

        public SubscriptionRenewalOptions build() {
            return new SubscriptionRenewalOptions(this.priceChangeOption, this.priceIncreasePercentage, this.useTenantDefaultForPriceChange);
        }

        public String toString() {
            return "SubscriptionRenewalOptions.SubscriptionRenewalOptionsBuilder(priceChangeOption=" + this.priceChangeOption + ", priceIncreasePercentage=" + this.priceIncreasePercentage + ", useTenantDefaultForPriceChange=" + this.useTenantDefaultForPriceChange + ")";
        }
    }
}

