/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.zevolve.api.model.CreateDiscountRequest;
import com.zuora.zevolve.api.model.Discount;
import com.zuora.zevolve.api.model.DiscountRequest;
import com.zuora.zevolve.api.model.UpdateDiscountRequest;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscountsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscountsService.class);
    private final HttpSupport httpSupport;

    public DiscountsService(HttpSupport httpSupport) {
        this.httpSupport = httpSupport;
    }

    public Discount getDiscount(String discountKey) throws SdkException {
        Validations.requireNotEmpty((String)discountKey, (String)"discount key is required");
        return (Discount)this.httpSupport.call(HttpMethod.GET, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/discounts/%s"), (String[])new String[]{discountKey.trim()}), Optional.empty(), (TypeReference)new TypeReference<Discount>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Discount createDiscount(DiscountRequest discount) {
        Validations.requireNonNull((Object)discount, (String)"discount is required");
        return (Discount)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/discounts", Optional.of(CreateDiscountRequest.builder().discount(discount).build()), (TypeReference)new TypeReference<Discount>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Discount updateDiscount(String id, DiscountRequest updatedDiscount) throws SdkException {
        Validations.requireNonNull((Object)id, (String)"id is required");
        return (Discount)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/discounts", Optional.of(UpdateDiscountRequest.builder().id(id).discount(updatedDiscount).build()), (TypeReference)new TypeReference<Discount>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Boolean deleteDiscount(String discountKey) throws SdkException {
        Validations.requireNotEmpty((String)discountKey, (String)"Discount key is required");
        String path = HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/discounts/%s"), (String[])new String[]{discountKey.trim()});
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, path, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }
}

