/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.Mapping;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"name", "mapping", "type"})
public class Attribute {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_MAPPING = "mapping";
    private Mapping mapping;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public Attribute() {
    }

    public Attribute name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Attribute mapping(Mapping mapping) {
        this.mapping = mapping;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="mapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Mapping getMapping() {
        return this.mapping;
    }

    @JsonProperty(value="mapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public Attribute type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name) && Objects.equals(this.mapping, attribute.mapping) && Objects.equals(this.type, attribute.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mapping, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    mapping: ").append(this.toIndentedString(this.mapping)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AttributeBuilder builder() {
        return new AttributeBuilder();
    }

    public Attribute(String name, Mapping mapping, String type) {
        this.name = name;
        this.mapping = mapping;
        this.type = type;
    }

    public static class AttributeBuilder {
        private String name;
        private Mapping mapping;
        private String type;

        AttributeBuilder() {
        }

        public AttributeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AttributeBuilder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public AttributeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public Attribute build() {
            return new Attribute(this.name, this.mapping, this.type);
        }

        public String toString() {
            return "Attribute.AttributeBuilder(name=" + this.name + ", mapping=" + this.mapping + ", type=" + this.type + ")";
        }
    }
}

