/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.product;

import com.zuora.sdk.catalog.product.ProductNumber;
import com.zuora.sdk.catalog.product.Sku;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.common.NullHelper;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.values.IsoDate;
import com.zuora.sdk.values.WrappedValue;
import com.zuora.zevolve.api.model.Category;
import com.zuora.zevolve.api.model.ProductNetsuite;
import com.zuora.zevolve.api.model.UpdateProductRequest;
import com.zuora.zevolve.api.model.Value;
import java.time.LocalDate;
import java.util.Map;

public final class UpdatedProduct
implements ApiObject<UpdateProductRequest> {
    private String id;
    private String name;
    private String description;
    private ProductNumber productNumber;
    private Sku sku;
    private IsoDate startDate;
    private IsoDate endDate;
    private Category category;
    private Map<String, Value> customFields;
    private ProductNetsuite netsuite;

    private UpdatedProduct(String id, ProductNumber productNumber, Sku sku) {
        this.id = id;
        this.productNumber = productNumber;
        this.sku = sku;
    }

    public static UpdatedProduct withId(String id) {
        return new UpdatedProduct(id, null, null);
    }

    public static UpdatedProduct withSku(Sku sku) {
        return new UpdatedProduct(null, null, sku);
    }

    public static UpdatedProduct withProductNumber(ProductNumber productNumber) {
        return new UpdatedProduct(null, productNumber, null);
    }

    public UpdatedProduct withName(String name) {
        this.name = name;
        return this;
    }

    public UpdatedProduct withDescription(String description) {
        this.description = description;
        return this;
    }

    public UpdatedProduct withStartDate(IsoDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public UpdatedProduct withEndDate(IsoDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public UpdatedProduct withCategory(Category category) {
        this.category = category;
        return this;
    }

    public UpdatedProduct withCustomFields(Map<String, Value> customFields) {
        this.customFields = customFields;
        return this;
    }

    public UpdatedProduct withNetsuite(ProductNetsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    public UpdateProductRequest toApi() {
        Validations.requireNonNull((Object)this.id, (String)"id is required for product update");
        return UpdateProductRequest.builder().id(this.id).name(this.name).description(this.description).category(this.category).sku((String)NullHelper.getIfNotNull((Object)((Object)this.sku), WrappedValue::value)).productNumber((String)NullHelper.getIfNotNull((Object)((Object)this.productNumber), WrappedValue::value)).startDate((String)NullHelper.getIfNotNull((Object)this.startDate, date -> ((LocalDate)date.value()).toString())).endDate((String)NullHelper.getIfNotNull((Object)this.endDate, date -> ((LocalDate)date.value()).toString())).customFields(this.customFields).netsuite(this.netsuite).build();
    }
}

