/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.product;

import com.zuora.sdk.catalog.plan.NewPlan;
import com.zuora.sdk.catalog.product.ProductNumber;
import com.zuora.sdk.catalog.product.Sku;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.common.NullHelper;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.values.IsoDate;
import com.zuora.sdk.values.WrappedValue;
import com.zuora.zevolve.api.model.AggregateProductRequest;
import com.zuora.zevolve.api.model.Category;
import com.zuora.zevolve.api.model.ProductNetsuite;
import com.zuora.zevolve.api.model.Value;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class NewProduct
implements ApiObject<AggregateProductRequest> {
    private final List<NewPlan> plans = new ArrayList<NewPlan>();
    private final String name;
    private String description;
    private IsoDate startDate;
    private IsoDate endDate;
    private ProductNumber productNumber;
    private Sku sku;
    private Category category;
    private Boolean allowFeatureChanges;
    private ProductNetsuite netsuite;
    private Map<String, Value> customFields = new HashMap<String, Value>();

    private NewProduct(String name) {
        this.name = name;
    }

    public static NewProduct withName(String name) {
        return new NewProduct(name);
    }

    public NewProduct withDescription(String description) {
        this.description = description;
        return this;
    }

    public NewProduct with(NewPlan plan) {
        if (plan != null) {
            this.plans.add(plan);
        }
        return this;
    }

    public NewProduct with(ProductNumber number) {
        this.productNumber = number;
        return this;
    }

    public NewProduct with(Sku sku) {
        this.sku = sku;
        return this;
    }

    public NewProduct effectiveBetween(IsoDate startDate, IsoDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        return this;
    }

    public NewProduct withCategory(Category category) {
        this.category = category;
        return this;
    }

    public NewProduct withFeatureChangesAllowed(Boolean value) {
        this.allowFeatureChanges = value;
        return this;
    }

    public NewProduct withNetsuite(ProductNetsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    public NewProduct withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    public AggregateProductRequest toApi() {
        Validations.requireNonNull((Object)this.name, (String)"product name is required");
        Validations.require((this.name.length() <= 255 ? 1 : 0) != 0, (String)"product name must be 255 characters or less");
        Validations.require((this.description == null || this.description.length() <= 500 ? 1 : 0) != 0, (String)"product description must be 500 characters or less");
        return AggregateProductRequest.builder().name(this.name).category(this.category).allowFeatureChanges((Boolean)NullHelper.ifNull((Object)this.allowFeatureChanges, (Object)false)).productNumber((String)NullHelper.getIfNotNull((Object)((Object)this.productNumber), WrappedValue::value)).sku((String)NullHelper.getIfNotNull((Object)((Object)this.sku), WrappedValue::value)).startDate((String)NullHelper.getIfNotNull((Object)this.startDate, date -> ((LocalDate)date.value()).toString())).endDate((String)NullHelper.getIfNotNull((Object)this.endDate, date -> ((LocalDate)date.value()).toString())).plans(this.plans.stream().map(NewPlan::toApi).collect(Collectors.toList())).netsuite(this.netsuite).customFields(this.customFields).build();
    }
}

