/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge;

import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.onetime.OneTime;
import com.zuora.sdk.catalog.charge.recurring.Recurring;
import com.zuora.sdk.catalog.charge.usage.Usage;
import com.zuora.sdk.common.ApiObject;
import com.zuora.sdk.common.NullHelper;
import com.zuora.sdk.error.ErrorCode;
import com.zuora.sdk.error.ErrorType;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.PriceChangeOption;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.Value;
import java.util.HashMap;
import java.util.Map;

public abstract class Charge
implements ApiObject<ProductRatePlanChargeRequest> {
    public static final OneTime ONE_TIME = new OneTime(){};
    public static final Recurring RECURRING = new Recurring(){};
    public static final Usage USAGE = new Usage(){};
    protected Netsuite netsuite;
    protected String name;
    protected TriggerEvent triggerEvent;
    protected Billing billing;
    protected Accounting accounting;
    protected Revenue revenue;
    protected Taxation taxation;
    protected SubscriptionRenewalOptions renewalOptions = SubscriptionRenewalOptions.builder().build();
    protected DeliverySchedule deliverySchedule;
    protected Prepayment prepayment;
    protected Drawdown drawdown;
    protected Map<String, Value> customFields = new HashMap<String, Value>();

    protected abstract <T extends Charge> T withName(String var1);

    protected abstract <T extends Charge> T with(Billing var1);

    protected abstract <T extends Charge> T with(TriggerEvent var1);

    protected abstract <T extends Charge> T with(Accounting var1);

    protected abstract <T extends Charge> T with(Revenue var1);

    protected abstract <T extends Charge> T with(Taxation var1);

    protected abstract <T extends Charge> T with(Netsuite var1);

    protected abstract <T extends Charge> T with(SubscriptionRenewalOptions var1);

    protected abstract <T extends Charge> T with(DeliverySchedule var1);

    protected abstract <T extends Charge> T with(Prepayment var1);

    protected abstract <T extends Charge> T with(Drawdown var1);

    protected abstract <T extends Charge> T withCustomField(String var1, Value var2);

    public final ProductRatePlanChargeRequest toApi() {
        return this.toApi(this.builder());
    }

    public abstract ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder var1);

    protected ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder() {
        Validations.requireNotEmpty((String)this.name, (String)"charge name is required");
        Validations.requireNonNull((Object)((Object)this.triggerEvent), (String)"triggerEvent is required");
        if (this.prepayment != null && this.drawdown != null) {
            throw new SdkException(SdkError.error((ErrorType)ErrorType.bad_request, (ErrorCode)ErrorCode.invalid_request, (String)"prepayment and drawdown cannot be set at the same time"));
        }
        ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder = ProductRatePlanChargeRequest.builder().name(this.name != null ? this.name : null).triggerEvent(this.triggerEvent).billCycle(this.billing != null ? this.billing.toApi() : null).customFields(this.customFields).accounting(this.accounting).revenue(this.revenue).priceChangeOption((PriceChangeOption)((Object)NullHelper.ifNull((Object)((Object)this.renewalOptions.getPriceChangeOption()), (Object)((Object)PriceChangeOption.NO_CHANGE)))).priceIncreasePercentage(this.renewalOptions.getPriceIncreasePercentage()).useTenantDefaultForPriceChange(this.renewalOptions.getUseTenantDefaultForPriceChange()).prepayment(this.prepayment).drawdown(this.drawdown).prepaid(this.prepayment != null).deliverySchedule(this.deliverySchedule).netsuite(this.netsuite);
        if (this.taxation != null) {
            builder.taxMode(this.taxation.getTaxMode());
            builder.taxCode(this.taxation.getTaxCode());
        }
        return builder;
    }
}

