/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.zevolve.api.model.CreateFeatureRequest;
import com.zuora.zevolve.api.model.Feature;
import com.zuora.zevolve.api.model.UpdateFeatureRequest;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesService.class);
    private final HttpSupport httpSupport;

    public FeaturesService(HttpSupport httpSupport) {
        this.httpSupport = httpSupport;
    }

    public Feature getFeature(String featureKey) throws SdkException {
        Validations.requireNotEmpty((String)featureKey, (String)"feature key is required");
        return (Feature)this.httpSupport.call(HttpMethod.GET, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/features/%s"), (String[])new String[]{featureKey.trim()}), Optional.empty(), (TypeReference)new TypeReference<Feature>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Feature createFeature(CreateFeatureRequest request) throws SdkException {
        Validations.requireNonNull((Object)request, (String)"request is required");
        return (Feature)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/features", Optional.of(request), (TypeReference)new TypeReference<Feature>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Feature updateFeature(UpdateFeatureRequest request) throws SdkException {
        return (Feature)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/features", Optional.of(request), (TypeReference)new TypeReference<Feature>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Boolean deleteFeature(String featureKey) throws SdkException {
        Validations.requireNotEmpty((String)featureKey, (String)"Feature key is required");
        String path = HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/features/%s"), (String[])new String[]{featureKey.trim()});
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, path, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }
}

