/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.IConnectionFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectionFactory
implements IConnectionFactory {
    private ConnectionFactory() {
    }

    public static HttpConfig createHttpRequest(String url) {
        return new HttpConfig().url(url);
    }

    public static HttpURLConnection createConnection(HttpConfig config) throws IOException {
        String userAgent;
        Map<String, String> cookieMap;
        HttpURLConnection conn = (HttpURLConnection)(config.proxy == null ? config.url().openConnection() : config.url().openConnection(config.proxy));
        conn.setRequestMethod(config.method().name());
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(config.connectTimeout());
        conn.setReadTimeout(config.readTimeout());
        if (conn instanceof HttpsURLConnection) {
            SSLSocketFactory socketFactory = config.sslSocketFactory();
            if (socketFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(socketFactory);
            } else if (config.allowAllSSL()) {
                ConnectionFactory.initUnSecureTSL(config);
                ((HttpsURLConnection)conn).setSSLSocketFactory(config.sslSocketFactory());
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                });
            }
        }
        if (config.method().hasBody()) {
            conn.setDoOutput(true);
        }
        if (config.cookieJar != null && (cookieMap = config.cookieJar.loadCookies(config.url)) != null) {
            for (Map.Entry<String, String> entry : cookieMap.entrySet()) {
                if (config.hasCookie(entry.getKey())) continue;
                config.cookie(entry.getKey(), entry.getValue());
            }
        }
        if (config.cookies().size() > 0) {
            conn.addRequestProperty("Cookie", config.cookieStr());
        }
        if (!TextUtils.isEmpty((CharSequence)(userAgent = config.userAgent))) {
            conn.addRequestProperty("User-Agent", userAgent);
        }
        for (Map.Entry<String, String> header : config.headers().entrySet()) {
            conn.addRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static synchronized void initUnSecureTSL(HttpConfig config) throws IOException {
        if (config.sslSocketFactory() == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                config.sslSocketFactory(sslContext.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Can't create unsecure trust manager");
            }
        }
    }
}

