/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.IHttp;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

public class ObservableTask<T> {
    private Observable<T> observable;
    private Disposable disposable;
    private Scheduler subscribeScheduler;
    private Scheduler observeScheduler;
    private IHttp.OnSubscribeListener onSubscribeListener;
    private IHttp.OnSuccessListener<T> onSuccessListener;
    private IHttp.OnErrorListener onErrorListener;
    private IHttp.OnCompleteListener onCompleteListener;

    public ObservableTask(ObservableOnSubscribe<T> observableOnSubscribe) {
        this(Observable.create(observableOnSubscribe));
    }

    public ObservableTask(Observable<T> observable) {
        this.observable = observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public ObservableTask<T> subscribeOn(Scheduler scheduler) {
        this.subscribeScheduler = scheduler;
        return this;
    }

    public ObservableTask<T> observeOn(Scheduler scheduler) {
        this.observeScheduler = scheduler;
        return this;
    }

    public ObservableTask<T> onSubscribe(IHttp.OnSubscribeListener listener) {
        this.onSubscribeListener = listener;
        return this;
    }

    public final ObservableTask<T> onError(IHttp.OnErrorListener listener) {
        this.onErrorListener = listener;
        return this;
    }

    public final ObservableTask<T> onSuccess(IHttp.OnSuccessListener<T> listener) {
        this.onSuccessListener = listener;
        return this;
    }

    public ObservableTask<T> onComplete(IHttp.OnCompleteListener listener) {
        this.onCompleteListener = listener;
        return this;
    }

    public final <R> ObservableTask<R> onNext(final OnNextListener<T, R> listener) {
        this.initScheduler();
        Observable o = this.observable.flatMap(new Function<T, ObservableSource<R>>(){

            public ObservableSource<R> apply(T t) throws Exception {
                ObservableTask httpObservable;
                if (listener != null && (httpObservable = listener.onNext(t)) != null) {
                    return httpObservable.observable;
                }
                return Observable.empty();
            }
        });
        return new ObservableTask<T>(o).subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler);
    }

    public final <R> ObservableTask<R> flatMap(final OnFlatMapListener<T, R> listener) {
        this.initScheduler();
        Observable o = this.observable.flatMap(new Function<T, ObservableSource<R>>(){

            public ObservableSource<R> apply(final T t) throws Exception {
                return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<R>(){

                    public void subscribe(ObservableEmitter<R> emitter) throws Exception {
                        if (listener != null) {
                            listener.onNext(t, emitter);
                        }
                        emitter.onComplete();
                    }
                }).subscribeOn(ObservableTask.this.subscribeScheduler).observeOn(ObservableTask.this.observeScheduler);
            }
        });
        return new ObservableTask<T>(o).subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler);
    }

    public Disposable subscribe() {
        this.initScheduler();
        if (this.disposable != null) {
            return this.disposable;
        }
        this.disposable = this.observable.subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler).subscribe(new Consumer<T>(){

            public void accept(T t) throws Exception {
                if (ObservableTask.this.onSuccessListener != null) {
                    ObservableTask.this.onSuccessListener.onSuccess(t);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                throwable.printStackTrace();
                if (ObservableTask.this.onErrorListener != null) {
                    ObservableTask.this.onErrorListener.onError(throwable);
                }
            }
        }, new Action(){

            public void run() throws Exception {
                if (ObservableTask.this.onCompleteListener != null) {
                    ObservableTask.this.onCompleteListener.onComplete();
                }
            }
        }, (Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                if (ObservableTask.this.onSubscribeListener != null) {
                    ObservableTask.this.onSubscribeListener.onSubscribe(disposable);
                }
            }
        });
        return this.disposable;
    }

    private void initScheduler() {
        if (this.subscribeScheduler == null) {
            this.subscribeScheduler = Schedulers.io();
        }
        if (this.observeScheduler == null) {
            this.observeScheduler = AndroidSchedulers.mainThread();
        }
    }

    public void cancel() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        this.disposable = null;
    }

    public static interface OnNextListener<T, R> {
        public ObservableTask<R> onNext(T var1) throws Exception;
    }

    public static interface OnFlatMapListener<T, R> {
        public void onNext(T var1, ObservableEmitter<R> var2) throws Exception;
    }
}

