/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.util.Log;
import com.zpj.http.core.Connection;
import com.zpj.http.core.HttpBase;
import com.zpj.http.core.HttpRequest;
import com.zpj.http.exception.HttpStatusException;
import com.zpj.http.exception.UncheckedIOException;
import com.zpj.http.exception.UnsupportedMimeTypeException;
import com.zpj.http.io.ConstrainableInputStream;
import com.zpj.http.parser.html.Parser;
import com.zpj.http.parser.html.TokenQueue;
import com.zpj.http.parser.html.nodes.Document;
import com.zpj.http.utils.DataUtil;
import com.zpj.http.utils.StringUtil;
import com.zpj.http.utils.UrlUtil;
import com.zpj.http.utils.Validate;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpResponse
extends HttpBase<Connection.Response>
implements Connection.Response {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final int HTTP_TEMP_REDIR = 307;
    private static final String DefaultUploadType = "application/octet-stream";
    private static final int MAX_REDIRECTS = 20;
    private static SSLSocketFactory sslSocketFactory;
    private int statusCode;
    private String statusMessage;
    private ByteBuffer byteData;
    private InputStream bodyStream;
    private HttpURLConnection conn;
    private String charset;
    private String contentType;
    private boolean executed = false;
    private boolean inputStreamRead = false;
    private int numRedirects = 0;
    private Connection.Request req;
    private static final Pattern xmlContentTypeRxp;

    HttpResponse() {
    }

    private HttpResponse(HttpResponse previousResponse) throws IOException {
        if (previousResponse != null) {
            this.numRedirects = previousResponse.numRedirects + 1;
            if (this.numRedirects >= 20) {
                throw new IOException(String.format("Too many redirects occurred trying to load URL %s", previousResponse.url()));
            }
        }
    }

    static HttpResponse execute(Connection.Request req) throws IOException {
        return HttpResponse.execute(req, null);
    }

    private static HttpResponse execute(Connection.Request req, HttpResponse previousResponse) throws IOException {
        HttpResponse res;
        boolean hasRequestBody;
        Validate.notNull(req, "Request must not be null");
        Validate.notNull(req.url(), "URL must be specified to connect");
        String protocol = req.url().getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new MalformedURLException("Only http & https protocols supported");
        }
        boolean methodHasBody = req.method().hasBody();
        boolean bl = hasRequestBody = req.requestBody() != null;
        if (!methodHasBody) {
            Validate.isFalse(hasRequestBody, "Cannot set a request body for HTTP method " + (Object)((Object)req.method()));
        }
        String mimeBoundary = null;
        if (req.data().size() > 0 && (!methodHasBody || hasRequestBody)) {
            UrlUtil.serialiseRequestUrl(req);
        } else if (methodHasBody) {
            mimeBoundary = HttpResponse.setOutputContentType(req);
        }
        long startTime = System.nanoTime();
        HttpURLConnection conn = HttpResponse.createConnection(req);
        try {
            long time1 = System.currentTimeMillis();
            Log.d((String)"HttpResponse", (String)("time1=" + time1));
            if (conn.getDoOutput()) {
                conn.setUseCaches(false);
                HttpResponse.writePost2(req, conn, mimeBoundary);
                long time2 = System.currentTimeMillis();
                Log.d((String)"HttpResponse", (String)("delta=" + (time2 - time1)));
            } else {
                conn.connect();
            }
            int status = conn.getResponseCode();
            long time2 = System.currentTimeMillis();
            Log.d((String)"HttpResponse", (String)("delta1=" + (time2 - time1)));
            res = new HttpResponse(previousResponse);
            res.setupFromConnection(conn, previousResponse);
            res.req = req;
            long time3 = System.currentTimeMillis();
            Log.d((String)"HttpResponse", (String)("delta2=" + (time3 - time2)));
            if (res.hasHeader("Location")) {
                String location = res.header("Location");
                if (location.startsWith("http:/") && location.charAt(6) != '/') {
                    location = location.substring(6);
                }
                if (req.getOnRedirectListener() == null || req.getOnRedirectListener().onRedirect(location)) {
                    if (status != 307) {
                        req.method(Connection.Method.GET);
                        req.data().clear();
                        req.requestBody(null);
                        req.removeHeader("Content-Type");
                    }
                    URL redir = StringUtil.resolve(req.url(), location);
                    req.url(UrlUtil.encodeUrl(redir));
                    for (Map.Entry cookie : res.cookies.entrySet()) {
                        req.cookie((String)cookie.getKey(), (String)cookie.getValue());
                    }
                    return HttpResponse.execute(req, res);
                }
            }
            if (!(status >= 200 && status < 400 || req.ignoreHttpErrors())) {
                throw new HttpStatusException("HTTP error fetching URL", status, req.url().toString());
            }
            String contentType = res.contentType();
            if (!(contentType == null || req.ignoreContentType() || contentType.startsWith("text/") || contentType.contains("application/json") || xmlContentTypeRxp.matcher(contentType).matches())) {
                throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, application/xhtml+xml or application/json", contentType, req.url().toString());
            }
            if (contentType != null && xmlContentTypeRxp.matcher(contentType).matches() && req instanceof HttpRequest && !((HttpRequest)req).isParserDefined()) {
                req.parser(Parser.xmlParser());
            }
            res.charset = DataUtil.getCharsetFromContentType(res.contentType);
            if (conn.getContentLength() != 0 && req.method() != Connection.Method.HEAD) {
                res.bodyStream = null;
                InputStream inputStream = res.bodyStream = conn.getErrorStream() != null ? conn.getErrorStream() : conn.getInputStream();
                if (res.hasHeaderWithValue("Content-Encoding", "gzip")) {
                    res.bodyStream = new GZIPInputStream(res.bodyStream);
                } else if (res.hasHeaderWithValue("Content-Encoding", "deflate")) {
                    res.bodyStream = new InflaterInputStream(res.bodyStream, new Inflater(true));
                }
                res.bodyStream = ConstrainableInputStream.wrap(res.bodyStream, 524288, req.maxBodySize()).timeout(startTime, req.timeout());
            } else {
                res.byteData = DataUtil.emptyByteBuffer();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            conn.disconnect();
            throw e;
        }
        res.executed = true;
        return res;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public HttpResponse charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public Document parse() throws IOException {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
        if (this.byteData != null) {
            this.bodyStream = new ByteArrayInputStream(this.byteData.array());
            this.inputStreamRead = false;
        }
        Validate.isFalse(this.inputStreamRead, "Input stream already read and parsed, cannot re-read.");
        Document doc = DataUtil.parseInputStream(this.bodyStream, this.charset, this.url.toExternalForm(), this.req.parser());
        this.charset = doc.outputSettings().charset().name();
        this.inputStreamRead = true;
        this.safeClose();
        return doc;
    }

    private void prepareByteData() {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.byteData == null) {
            Validate.isFalse(this.inputStreamRead, "Request has already been read (with .parse())");
            try {
                this.byteData = DataUtil.readToByteBuffer(this.bodyStream, this.req.maxBodySize());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.inputStreamRead = true;
                this.safeClose();
            }
        }
    }

    @Override
    public String body() {
        this.prepareByteData();
        String body = this.charset == null ? Charset.forName("UTF-8").decode(this.byteData).toString() : Charset.forName(this.charset).decode(this.byteData).toString();
        ((Buffer)this.byteData).rewind();
        return body;
    }

    @Override
    public byte[] bodyAsBytes() {
        this.prepareByteData();
        return this.byteData.array();
    }

    @Override
    public Connection.Response bufferUp() {
        this.prepareByteData();
        return this;
    }

    @Override
    public BufferedInputStream bodyStream() {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        Validate.isFalse(this.inputStreamRead, "Request has already been read");
        this.inputStreamRead = true;
        return ConstrainableInputStream.wrap(this.bodyStream, 524288, this.req.maxBodySize());
    }

    private static HttpURLConnection createConnection(Connection.Request req) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)(req.proxy() == null ? req.url().openConnection() : req.url().openConnection(req.proxy()));
        conn.setRequestMethod(req.method().name());
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(req.timeout());
        conn.setReadTimeout(req.timeout() / 2);
        if (conn instanceof HttpsURLConnection) {
            SSLSocketFactory socketFactory = req.sslSocketFactory();
            if (socketFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(socketFactory);
            } else if (!req.validateTLSCertificates()) {
                HttpResponse.initUnSecureTSL();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
                ((HttpsURLConnection)conn).setHostnameVerifier(HttpResponse.getInsecureVerifier());
            }
        }
        if (req.method().hasBody()) {
            conn.setDoOutput(true);
        }
        if (req.cookies().size() > 0) {
            conn.addRequestProperty("Cookie", req.cookieStr());
        }
        for (Map.Entry<String, List<String>> header : req.multiHeaders().entrySet()) {
            for (String value : header.getValue()) {
                conn.addRequestProperty(header.getKey(), value);
            }
        }
        return conn;
    }

    private static synchronized void initUnSecureTSL() throws IOException {
        if (sslSocketFactory == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Can't create unsecure trust manager");
            }
        }
    }

    private static HostnameVerifier getInsecureVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    private void safeClose() {
        if (this.bodyStream != null) {
            try {
                this.bodyStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bodyStream = null;
            }
        }
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    private void setupFromConnection(HttpURLConnection conn, HttpResponse previousResponse) throws IOException {
        this.conn = conn;
        this.method = Connection.Method.valueOf(conn.getRequestMethod());
        this.url = conn.getURL();
        this.statusCode = conn.getResponseCode();
        this.statusMessage = conn.getResponseMessage();
        this.contentType = conn.getContentType();
        LinkedHashMap<String, List<String>> resHeaders = HttpResponse.createHeaderMap(conn);
        this.processResponseHeaders(resHeaders);
        if (previousResponse != null) {
            for (Map.Entry<String, String> prevCookie : previousResponse.cookies().entrySet()) {
                if (this.hasCookie(prevCookie.getKey())) continue;
                this.cookie(prevCookie.getKey(), prevCookie.getValue());
            }
            previousResponse.safeClose();
        }
    }

    private static LinkedHashMap<String, List<String>> createHeaderMap(HttpURLConnection conn) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        int i = 0;
        while (true) {
            String key = conn.getHeaderFieldKey(i);
            String val = conn.getHeaderField(i);
            if (key == null && val == null) break;
            ++i;
            if (key == null || val == null) continue;
            if (headers.containsKey(key)) {
                headers.get(key).add(val);
                continue;
            }
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(val);
            headers.put(key, vals);
        }
        return headers;
    }

    private void processResponseHeaders(Map<String, List<String>> resHeaders) {
        for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            List<String> values = entry.getValue();
            if (name.equalsIgnoreCase("Set-Cookie")) {
                for (String value : values) {
                    if (value == null) continue;
                    TokenQueue cd = new TokenQueue(value);
                    String cookieName = cd.chompTo("=").trim();
                    String cookieVal = cd.consumeTo(";").trim();
                    if (cookieName.length() <= 0) continue;
                    this.cookie(cookieName, cookieVal);
                }
            }
            for (String value : values) {
                this.addHeader(name, value);
            }
        }
    }

    private static String setOutputContentType(Connection.Request req) {
        String bound = null;
        if (req.hasHeader("Content-Type")) {
            if (req.header("Content-Type").contains(MULTIPART_FORM_DATA) && !req.header("Content-Type").contains("boundary")) {
                bound = DataUtil.mimeBoundary();
                req.header("Content-Type", "multipart/form-data; boundary=" + bound);
            }
        } else if (HttpResponse.needsMultipart(req)) {
            bound = DataUtil.mimeBoundary();
            req.header("Content-Type", "multipart/form-data; boundary=" + bound);
        } else {
            req.header("Content-Type", "application/x-www-form-urlencoded; charset=" + req.postDataCharset());
        }
        return bound;
    }

    private static long getTotalBytes(Connection.Request req, String bound) throws IOException {
        String charset = req.postDataCharset();
        byte[] boundaryBytes = ("--" + bound + "\r\n").getBytes(charset);
        byte[] trailerBytes = ("--" + bound + "--").getBytes(charset);
        long total = 0L;
        for (Connection.KeyVal keyVal : req.data()) {
            total += (long)boundaryBytes.length;
            String multipartHeader = "Content-Disposition: form-data; name=\"" + HttpResponse.encodeMimeName(keyVal.key()) + "\"";
            if (keyVal.hasInputStream()) {
                multipartHeader = multipartHeader + "; filename=\"" + HttpResponse.encodeMimeName(keyVal.value()) + "\"\r\nContent-Type: ";
                multipartHeader = multipartHeader + (keyVal.contentType() != null ? keyVal.contentType() : DefaultUploadType);
                multipartHeader = multipartHeader + "\r\n\r\n";
                total += (long)multipartHeader.getBytes(charset).length;
                if (keyVal.inputStream() instanceof FileInputStream) {
                    total += ((FileInputStream)keyVal.inputStream()).getChannel().size();
                } else {
                    int available = keyVal.inputStream().available();
                    if (available < Integer.MAX_VALUE) {
                        total += (long)available;
                    } else {
                        int len;
                        byte[] buf = new byte[524288];
                        while ((len = keyVal.inputStream().read(buf)) > 0) {
                            total += (long)len;
                        }
                    }
                }
            } else {
                multipartHeader = multipartHeader + "\r\n\r\n" + keyVal.value();
                total += (long)multipartHeader.getBytes(charset).length;
            }
            total += (long)"\r\n".getBytes(charset).length;
        }
        Log.d((String)"HttpResponse", (String)("total=" + (total += (long)trailerBytes.length)));
        return total;
    }

    private static void writePost2(Connection.Request req, HttpURLConnection conn, String bound) throws IOException {
        OutputStream w;
        Collection<Connection.KeyVal> data = req.data();
        String charset = req.postDataCharset();
        if (bound != null) {
            conn.setFixedLengthStreamingMode(HttpResponse.getTotalBytes(req, bound));
            Log.d((String)"HttpResponse", (String)"setFixedLengthStreamingMode finished");
            w = conn.getOutputStream();
            byte[] boundaryBytes = ("--" + bound + "\r\n").getBytes(charset);
            byte[] trailerBytes = ("--" + bound + "--").getBytes(charset);
            for (Connection.KeyVal keyVal : data) {
                w.write(boundaryBytes);
                String multipartHeader = "Content-Disposition: form-data; name=\"" + HttpResponse.encodeMimeName(keyVal.key()) + "\"";
                if (keyVal.hasInputStream()) {
                    multipartHeader = multipartHeader + "; filename=\"" + HttpResponse.encodeMimeName(keyVal.value()) + "\"\r\nContent-Type: ";
                    multipartHeader = multipartHeader + (keyVal.contentType() != null ? keyVal.contentType() : DefaultUploadType);
                    multipartHeader = multipartHeader + "\r\n\r\n";
                    w.write(multipartHeader.getBytes(charset));
                    Log.d((String)"HttpResponse", (String)"crossStreams");
                    DataUtil.crossStreams(keyVal.inputStream(), w, keyVal.getListener());
                    w.flush();
                } else {
                    multipartHeader = multipartHeader + "\r\n\r\n" + keyVal.value();
                    w.write(multipartHeader.getBytes(charset));
                }
                w.write("\r\n".getBytes(charset));
            }
            w.write(trailerBytes);
        } else if (req.requestBody() != null) {
            w = conn.getOutputStream();
            w.write(req.requestBody().getBytes(charset));
        } else {
            w = conn.getOutputStream();
            boolean first = true;
            for (Connection.KeyVal keyVal : data) {
                if (!first) {
                    w.write("&".getBytes(charset));
                } else {
                    first = false;
                }
                w.write(URLEncoder.encode(keyVal.key(), req.postDataCharset()).getBytes(charset));
                w.write("=".getBytes(charset));
                w.write(URLEncoder.encode(keyVal.value(), req.postDataCharset()).getBytes(charset));
            }
        }
        w.close();
    }

    private static String encodeMimeName(String val) {
        if (val == null) {
            return null;
        }
        return val.replaceAll("\"", "%22");
    }

    private static boolean needsMultipart(Connection.Request req) {
        for (Connection.KeyVal keyVal : req.data()) {
            if (!keyVal.hasInputStream()) continue;
            return true;
        }
        return false;
    }

    static {
        xmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?xml.*");
    }
}

