/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.core.Connection;
import com.zpj.http.utils.Normalizer;
import com.zpj.http.utils.StringUtil;
import com.zpj.http.utils.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class HttpBase<T extends Connection.Base>
implements Connection.Base<T> {
    protected URL url;
    protected Connection.Method method;
    protected final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    protected final Map<String, String> cookies = new LinkedHashMap<String, String>();

    @Override
    public URL url() {
        return this.url;
    }

    @Override
    public T url(URL url) {
        Validate.notNull(url, "URL must not be null");
        this.url = url;
        return (T)this;
    }

    @Override
    public Connection.Method method() {
        return this.method;
    }

    @Override
    public T method(Connection.Method method) {
        Validate.notNull((Object)method, "Method must not be null");
        this.method = method;
        return (T)this;
    }

    @Override
    public String header(String name) {
        List<String> vals = this.getHeadersCaseInsensitive(name);
        if (vals.size() > 0) {
            return StringUtil.join(vals, ", ");
        }
        return null;
    }

    @Override
    public T addHeader(String name, String value) {
        Validate.notEmpty(name);
        value = value == null ? "" : value;
        List<String> values = this.headers(name);
        if (values.isEmpty()) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(HttpBase.fixHeaderEncoding(value));
        return (T)this;
    }

    @Override
    public List<String> headers(String name) {
        return this.getHeadersCaseInsensitive(name);
    }

    private static String fixHeaderEncoding(String val) {
        try {
            byte[] bytes = val.getBytes("ISO-8859-1");
            if (!HttpBase.looksLikeUtf8(bytes)) {
                return val;
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return val;
        }
    }

    private static boolean looksLikeUtf8(byte[] input) {
        int i = 0;
        if (input.length >= 3 && (input[0] & 0xFF) == 239 && (input[1] & 0xFF) == 187 & (input[2] & 0xFF) == 191) {
            i = 3;
        }
        int j = input.length;
        while (i < j) {
            byte o = input[i];
            if ((o & 0x80) != 0) {
                int end;
                if ((o & 0xE0) == 192) {
                    end = i + 1;
                } else if ((o & 0xF0) == 224) {
                    end = i + 2;
                } else if ((o & 0xF8) == 240) {
                    end = i + 3;
                } else {
                    return false;
                }
                if (end >= input.length) {
                    return false;
                }
                while (i < end) {
                    if (((o = input[++i]) & 0xC0) == 128) continue;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public T header(String name, String value) {
        Validate.notEmpty(name, "Header name must not be empty");
        this.removeHeader(name);
        this.addHeader(name, value);
        return (T)this;
    }

    @Override
    public boolean hasHeader(String name) {
        return !this.getHeadersCaseInsensitive(name).isEmpty();
    }

    @Override
    public boolean hasHeaderWithValue(String name, String value) {
        Validate.notEmpty(name);
        Validate.notEmpty(value);
        List<String> values = this.headers(name);
        for (String candidate : values) {
            if (!value.equalsIgnoreCase(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T removeHeader(String name) {
        Validate.notEmpty(name, "Header name must not be empty");
        Map.Entry<String, List<String>> entry = this.scanHeaders(name);
        if (entry != null) {
            this.headers.remove(entry.getKey());
        }
        return (T)this;
    }

    @Override
    public Map<String, String> headers() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String header = entry.getKey();
            List<String> values = entry.getValue();
            if (values.size() <= 0) continue;
            map.put(header, values.get(0));
        }
        return map;
    }

    @Override
    public Map<String, List<String>> multiHeaders() {
        return this.headers;
    }

    private List<String> getHeadersCaseInsensitive(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return Collections.emptyList();
        }
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    private Map.Entry<String, List<String>> scanHeaders(String name) {
        String lc = Normalizer.lowerCase(name);
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (!Normalizer.lowerCase(entry.getKey()).equals(lc)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String cookie(String name) {
        Validate.notEmpty(name, "Cookie name must not be empty");
        return this.cookies.get(name);
    }

    @Override
    public T cookie(String name, String value) {
        Validate.notEmpty(name, "Cookie name must not be empty");
        Validate.notNull(value, "Cookie value must not be null");
        this.cookies.put(name, value);
        return (T)this;
    }

    @Override
    public boolean hasCookie(String name) {
        Validate.notEmpty(name, "Cookie name must not be empty");
        return this.cookies.containsKey(name);
    }

    @Override
    public T removeCookie(String name) {
        Validate.notEmpty(name, "Cookie name must not be empty");
        this.cookies.remove(name);
        return (T)this;
    }

    @Override
    public Map<String, String> cookies() {
        return this.cookies;
    }

    @Override
    public String cookieStr() {
        StringBuilder sb = StringUtil.borrowBuilder();
        boolean first = true;
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            if (!first) {
                sb.append("; ");
            } else {
                first = false;
            }
            sb.append(cookie.getKey()).append('=').append(cookie.getValue());
        }
        return StringUtil.releaseBuilder(sb);
    }
}

