/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.IHttp;
import com.zpj.http.core.ObservableTask;
import com.zpj.http.parser.html.Parser;
import com.zpj.http.parser.html.nodes.Document;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface Connection {
    public Connection url(URL var1);

    public Connection url(String var1);

    public Connection proxy(Proxy var1);

    public Connection proxy(String var1, int var2);

    public Connection userAgent(String var1);

    public Connection timeout(int var1);

    public Connection maxBodySize(int var1);

    public Connection referer(String var1);

    public Connection contentType(String var1);

    public Connection acceptLanguage(String var1);

    public Connection host(String var1);

    public Connection accept(String var1);

    public Connection acceptEncoding(String var1);

    public Connection connection(String var1);

    public Connection range(String var1);

    public Connection contentLength(String var1);

    public Connection contentMD5(String var1);

    public Connection from(String var1);

    public Connection xRequestedWith(String var1);

    public Connection acceptCharset(String var1);

    public Connection method(Method var1);

    public Connection ignoreHttpErrors(boolean var1);

    public Connection ignoreContentType(boolean var1);

    public Connection validateTLSCertificates(boolean var1);

    public Connection sslSocketFactory(SSLSocketFactory var1);

    public Connection data(String var1, String var2);

    public Connection data(String var1, String var2, InputStream var3);

    public Connection data(String var1, String var2, InputStream var3, IHttp.OnStreamWriteListener var4);

    public Connection data(String var1, String var2, InputStream var3, String var4);

    public Connection data(Collection<KeyVal> var1);

    public Connection data(Map<String, String> var1);

    public Connection data(String ... var1);

    public KeyVal data(String var1);

    public Connection requestBody(String var1);

    public Connection header(String var1, String var2);

    public Connection headers(Map<String, String> var1);

    public Connection cookie(String var1);

    public Connection cookie(String var1, String var2);

    public Connection cookies(Map<String, String> var1);

    public Connection parser(Parser var1);

    public Connection postDataCharset(String var1);

    public Response syncExecute() throws IOException;

    public String syncToStr() throws IOException;

    public Document syncToHtml() throws IOException;

    public JSONObject syncToJsonObject() throws IOException, JSONException;

    public JSONArray syncToJsonArray() throws IOException, JSONException;

    public Document syncToXml() throws IOException;

    public ObservableTask<Response> execute();

    public ObservableTask<String> toStr();

    public ObservableTask<Document> toHtml();

    public ObservableTask<JSONObject> toJsonObject();

    public ObservableTask<JSONArray> toJsonArray();

    public ObservableTask<Document> toXml();

    public Connection onRedirect(IHttp.OnRedirectListener var1);

    public Request request();

    public Response response();

    public static interface KeyVal {
        public KeyVal key(String var1);

        public String key();

        public KeyVal value(String var1);

        public String value();

        public KeyVal inputStream(InputStream var1);

        public InputStream inputStream();

        public boolean hasInputStream();

        public KeyVal contentType(String var1);

        public String contentType();

        public KeyVal setListener(IHttp.OnStreamWriteListener var1);

        public IHttp.OnStreamWriteListener getListener();
    }

    public static interface Response
    extends Base<Response> {
        public int statusCode();

        public String statusMessage();

        public String charset();

        public Response charset(String var1);

        public String contentType();

        public Document parse() throws IOException;

        public String body();

        public byte[] bodyAsBytes();

        public Response bufferUp();

        public BufferedInputStream bodyStream();
    }

    public static interface Request
    extends Base<Request> {
        public Proxy proxy();

        public Request proxy(Proxy var1);

        public Request proxy(String var1, int var2);

        public int timeout();

        public Request timeout(int var1);

        public int maxBodySize();

        public Request maxBodySize(int var1);

        public boolean ignoreHttpErrors();

        public Request ignoreHttpErrors(boolean var1);

        public boolean ignoreContentType();

        public Request ignoreContentType(boolean var1);

        public boolean validateTLSCertificates();

        public void validateTLSCertificates(boolean var1);

        public SSLSocketFactory sslSocketFactory();

        public void sslSocketFactory(SSLSocketFactory var1);

        public Request data(KeyVal var1);

        public Collection<KeyVal> data();

        public Request requestBody(String var1);

        public String requestBody();

        public Request parser(Parser var1);

        public Parser parser();

        public Request postDataCharset(String var1);

        public String postDataCharset();

        public Request onRedirect(IHttp.OnRedirectListener var1);

        public IHttp.OnRedirectListener getOnRedirectListener();
    }

    public static interface Base<T extends Base> {
        public URL url();

        public T url(URL var1);

        public Method method();

        public T method(Method var1);

        public String header(String var1);

        public List<String> headers(String var1);

        public T header(String var1, String var2);

        public T addHeader(String var1, String var2);

        public boolean hasHeader(String var1);

        public boolean hasHeaderWithValue(String var1, String var2);

        public T removeHeader(String var1);

        public Map<String, String> headers();

        public Map<String, List<String>> multiHeaders();

        public String cookie(String var1);

        public T cookie(String var1, String var2);

        public boolean hasCookie(String var1);

        public T removeCookie(String var1);

        public Map<String, String> cookies();

        public String cookieStr();
    }

    public static enum Method {
        GET(false),
        POST(true),
        PUT(true),
        DELETE(false),
        PATCH(true),
        HEAD(false),
        OPTIONS(false),
        TRACE(false);

        private final boolean hasBody;

        private Method(boolean hasBody) {
            this.hasBody = hasBody;
        }

        public final boolean hasBody() {
            return this.hasBody;
        }
    }
}

