/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.observers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.observers.AssertableSubscriber;
import com.zoyi.rx.observers.TestSubscriber;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertableSubscriberObservable<T>
extends Subscriber<T>
implements AssertableSubscriber<T> {
    private final TestSubscriber<T> ts;

    public AssertableSubscriberObservable(TestSubscriber<T> ts) {
        this.ts = ts;
    }

    public static <T> AssertableSubscriberObservable<T> create(long initialRequest) {
        TestSubscriber t1 = new TestSubscriber(initialRequest);
        AssertableSubscriberObservable t2 = new AssertableSubscriberObservable(t1);
        t2.add(t1);
        return t2;
    }

    @Override
    public void onStart() {
        this.ts.onStart();
    }

    @Override
    public void onCompleted() {
        this.ts.onCompleted();
    }

    @Override
    public void setProducer(Producer p) {
        this.ts.setProducer(p);
    }

    @Override
    public final int getCompletions() {
        return this.ts.getCompletions();
    }

    @Override
    public void onError(Throwable e) {
        this.ts.onError(e);
    }

    @Override
    public List<Throwable> getOnErrorEvents() {
        return this.ts.getOnErrorEvents();
    }

    @Override
    public void onNext(T t) {
        this.ts.onNext(t);
    }

    @Override
    public final int getValueCount() {
        return this.ts.getValueCount();
    }

    @Override
    public AssertableSubscriber<T> requestMore(long n) {
        this.ts.requestMore(n);
        return this;
    }

    @Override
    public List<T> getOnNextEvents() {
        return this.ts.getOnNextEvents();
    }

    @Override
    public AssertableSubscriber<T> assertReceivedOnNext(List<T> items) {
        this.ts.assertReceivedOnNext(items);
        return this;
    }

    @Override
    public final AssertableSubscriber<T> awaitValueCount(int expected, long timeout, TimeUnit unit) {
        if (!this.ts.awaitValueCount(expected, timeout, unit)) {
            throw new AssertionError((Object)("Did not receive enough values in time. Expected: " + expected + ", Actual: " + this.ts.getValueCount()));
        }
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertTerminalEvent() {
        this.ts.assertTerminalEvent();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertUnsubscribed() {
        this.ts.assertUnsubscribed();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertNoErrors() {
        this.ts.assertNoErrors();
        return this;
    }

    @Override
    public AssertableSubscriber<T> awaitTerminalEvent() {
        this.ts.awaitTerminalEvent();
        return this;
    }

    @Override
    public AssertableSubscriber<T> awaitTerminalEvent(long timeout, TimeUnit unit) {
        this.ts.awaitTerminalEvent(timeout, unit);
        return this;
    }

    @Override
    public AssertableSubscriber<T> awaitTerminalEventAndUnsubscribeOnTimeout(long timeout, TimeUnit unit) {
        this.ts.awaitTerminalEventAndUnsubscribeOnTimeout(timeout, unit);
        return this;
    }

    @Override
    public Thread getLastSeenThread() {
        return this.ts.getLastSeenThread();
    }

    @Override
    public AssertableSubscriber<T> assertCompleted() {
        this.ts.assertCompleted();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertNotCompleted() {
        this.ts.assertNotCompleted();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertError(Class<? extends Throwable> clazz) {
        this.ts.assertError(clazz);
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertError(Throwable throwable) {
        this.ts.assertError(throwable);
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertNoTerminalEvent() {
        this.ts.assertNoTerminalEvent();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertNoValues() {
        this.ts.assertNoValues();
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertValueCount(int count) {
        this.ts.assertValueCount(count);
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertValues(T ... values) {
        this.ts.assertValues(values);
        return this;
    }

    @Override
    public AssertableSubscriber<T> assertValue(T value) {
        this.ts.assertValue(value);
        return this;
    }

    @Override
    public final AssertableSubscriber<T> assertValuesAndClear(T expectedFirstValue, T ... expectedRestValues) {
        this.ts.assertValuesAndClear(expectedFirstValue, expectedRestValues);
        return this;
    }

    @Override
    public final AssertableSubscriber<T> perform(Action0 action) {
        action.call();
        return this;
    }

    public String toString() {
        return this.ts.toString();
    }

    @Override
    public final AssertableSubscriber<T> assertResult(T ... values) {
        this.ts.assertValues(values);
        this.ts.assertNoErrors();
        this.ts.assertCompleted();
        return this;
    }

    @Override
    public final AssertableSubscriber<T> assertFailure(Class<? extends Throwable> errorClass, T ... values) {
        this.ts.assertValues(values);
        this.ts.assertError(errorClass);
        this.ts.assertNotCompleted();
        return this;
    }

    @Override
    public final AssertableSubscriber<T> assertFailureAndMessage(Class<? extends Throwable> errorClass, String message, T ... values) {
        this.ts.assertValues(values);
        this.ts.assertError(errorClass);
        this.ts.assertNotCompleted();
        String actualMessage = this.ts.getOnErrorEvents().get(0).getMessage();
        if (!(actualMessage == message || message != null && message.equals(actualMessage))) {
            throw new AssertionError((Object)("Error message differs. Expected: '" + message + "', Received: '" + actualMessage + "'"));
        }
        return this;
    }
}

