/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.BaseProfileBotInputView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.DatetimeDialog;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.functions.Action1;

public class ProfileBotInputDateView
extends BaseProfileBotInputView {
    private View button;
    private TextView textView;
    private View progress;
    private View dropdown;
    @Nullable
    private DatetimeDialog dialog;
    @Nullable
    private Long timestamp;

    public ProfileBotInputDateView(@NonNull Context context) {
        super(context);
    }

    public ProfileBotInputDateView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ProfileBotInputDateView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @Initializer
    public void initView(View root) {
        this.button = root.findViewById(R.id.ch_buttonProfileBotInputDate);
        this.textView = (TextView)root.findViewById(R.id.ch_textProfileBotInputDate);
        this.progress = root.findViewById(R.id.ch_progressProfileBotInputDate);
        this.dropdown = root.findViewById(R.id.ch_imageProfileBotInputDateDropdown);
        this.button.setOnClickListener(v -> {
            this.dialog = new DatetimeDialog(this.getContext());
            this.dialog.show(this.timestamp, (Action1<Long>)((Action1)this::submit));
        });
    }

    @Override
    @Nullable
    public Object getValue() {
        return null;
    }

    @Override
    public void restore(@Nullable Object value, FetchState fetchState) {
        this.timestamp = ParseUtils.parseLong(value);
        this.textView.setText((CharSequence)Optional.ofNullable((Object)this.timestamp).map(TimeUtils::formatDatetime).orElse(null));
        Views.setVisibility(this.progress, fetchState == FetchState.LOADING);
        Views.setVisibility(this.dropdown, fetchState != FetchState.LOADING);
    }

    @Override
    public void focus() {
    }

    @Override
    public void onRecycled() {
        super.onRecycled();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.ch_view_profile_bot_input_date;
    }
}

