package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import com.zoyi.channel.plugin.android.ChannelIO;

import java.util.Random;

/**
 * Created by mika on 2016. 4. 19..
 */
public class Utils {

  public static int addBlackMask(int color) {
    float[] hsv = new float[3];
    Color.colorToHSV(color, hsv);
    hsv[2] = Math.max(0, hsv[2] - 0.2f);
    return Color.HSVToColor(hsv);
  }

  public static Point resizeImage(Context context, Point imageArea, boolean isWebPage) {

    // 115.0dp is width that message holder's etc view size
    Point windowSize = Utils.getWindowSize(context);

    if (isWebPage) {
      int width = (int) (windowSize.x - Utils.dpToPx(context, 120));
      int height = (int) (width * 0.52);

      return new Point(width, height);
    } else {

      double ratioWidth = 1.0;
      double ratioHeight = 1.0;

      int targetWidth = imageArea.x;
      int targetHeight = imageArea.y;

      if (windowSize.x == 0 || windowSize.y == 0) {
        return new Point(targetWidth, targetHeight);
      }

      double minWidth = windowSize.x * 6.0 / 10;
      double maxWidth = windowSize.x - Utils.dpToPx(context, 120);
      double minHeight = windowSize.y * 2.5 / 10;
      double maxHeight = windowSize.y * 5.5 / 10;

      if (targetWidth > maxWidth) {
        ratioWidth = maxWidth / targetWidth;
      } else if (targetWidth < minWidth) {
        ratioWidth = minWidth / targetWidth;
      }

      if (targetHeight > maxHeight) {
        ratioHeight = maxHeight / targetHeight;
      } else if (targetHeight < minHeight) {
        ratioHeight = minHeight / targetHeight;
      }

      if (ratioWidth > 1.0 && ratioHeight < 1.0) {
        return new Point((int) minWidth, (int) maxHeight);
      }
      if (ratioWidth < 1.0 && ratioHeight > 1.0) {
        return new Point((int) maxWidth, (int) minHeight);
      }

      if (ratioWidth < 1.0 || ratioHeight < 1.0) {
        double ratioMin = Math.min(ratioWidth, ratioHeight);
        targetWidth = Math.max((int) minWidth, (int) (targetWidth * ratioMin));
        targetHeight = Math.max((int) minHeight, (int) (targetHeight * ratioMin));
      } else if (ratioWidth > 1.0 || ratioHeight > 1.0) {
        double ratioMax = Math.max(ratioWidth, ratioHeight);
        targetWidth = Math.min((int) maxWidth, (int) (targetWidth * ratioMax));
        targetHeight = Math.min((int) maxHeight, (int) (targetHeight * ratioMax));
      }

      return new Point(targetWidth, targetHeight);
    }
  }

  public static Point resizeImageForGrid(Context context, int size) {
    // 115.0dp is width that message holder's etc view size
    Point windowSize = Utils.getWindowSize(context);

    double ratioSize = 1.0;

    int targetSize = size;

    if (windowSize.x == 0 || windowSize.y == 0) {
      return new Point(targetSize, targetSize);
    }

    double minSize = dpToPx(56);
    double maxSize = (windowSize.x - Utils.dpToPx(context, 121)) / 2;

    if (targetSize > maxSize) {
      ratioSize = maxSize / targetSize;
    }

    if (ratioSize < 1.0) { // maxSize < targetSize
      targetSize = Math.max((int) minSize, (int) maxSize);
    } else if (ratioSize > 1.0) { // maxSize > targetSize
      targetSize = Math.max((int) minSize, targetSize);
    }

    return new Point(targetSize, targetSize);
  }

  public static Point getWindowSize(Context context) {
    Point windowSize = new Point();
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    wm.getDefaultDisplay().getSize(windowSize);
    return windowSize;
  }

  public static float dpToPx(Context context, float dp) {
    Resources resources = context.getResources();
    DisplayMetrics metrics = resources.getDisplayMetrics();
    return dp * ((float) metrics.densityDpi / DisplayMetrics.DENSITY_DEFAULT);
  }

  public static float dpToPx(float dp) {
    return dpToPx(ChannelIO.getAppContext(), dp);
  }

  public static String getCount(int count, boolean emptyIfZero) {
    return getCount((long) count, emptyIfZero);
  }

  public static String getCount(long count, boolean emptyIfZero) {
    if (count <= 0 && emptyIfZero) {
      return "";
    }
    return count >= 100 ? "99+" : String.valueOf(count);
  }

  public static Spanned getHtmlFormattedText(String text) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
      return Html.fromHtml(text, Html.FROM_HTML_MODE_LEGACY);
    }
    return Html.fromHtml(text);
  }

  public static boolean hasPermissionInManifest(Context context, String permissionName) {
    final String packageName = context.getPackageName();
    try {
      final PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, PackageManager.GET_PERMISSIONS);
      final String[] declaredPermisisons = packageInfo.requestedPermissions;
      if (declaredPermisisons != null && declaredPermisisons.length > 0) {
        for (String p : declaredPermisisons) {
          if (p.equals(permissionName)) {
            return true;
          }
        }
      }
    } catch (PackageManager.NameNotFoundException e) {
    }
    return false;
  }

  public static String getRandomString(int length) {
    Random random = new Random();
    StringBuilder stringBuilder = new StringBuilder(length);
    String ALLOWED_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyz";

    for (int i = 0; i < length; i++) {
      stringBuilder.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
    }
    return stringBuilder.toString();
  }
}
