/*
 * Decompiled with CFR 0.152.
 */
package com.zintow.dingding;

import com.zintow.dingding.DingdingService;
import com.zintow.dingding.DingdingServiceImpl;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DingdingNotifier
extends Notifier
implements SimpleBuildStep {
    private String accessToken;
    private String jsonFilePath;

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getJsonFilePath() {
        return this.jsonFilePath;
    }

    @DataBoundConstructor
    public DingdingNotifier(String accessToken, String jsonFilePath) {
        this.accessToken = accessToken;
        this.jsonFilePath = jsonFilePath;
    }

    public DingdingService newDingdingService(FilePath workspace, TaskListener listener) {
        return new DingdingServiceImpl(this.accessToken, this.jsonFilePath, listener, workspace);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Result result = run.getResult();
        if (null != result && result.equals(Result.SUCCESS)) {
            this.newDingdingService(workspace, listener).success();
        }
    }

    public DingdingNotifierDescriptor getDescriptor() {
        return (DingdingNotifierDescriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"dingding"})
    public static class DingdingNotifierDescriptor
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Dingding Json Pusher";
        }
    }
}

