/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.IncapableCause;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.SelectedItemCollection;
import com.zhihu.matisse.internal.ui.PreviewItemFragment;
import com.zhihu.matisse.internal.ui.adapter.PreviewPagerAdapter;
import com.zhihu.matisse.internal.ui.widget.CheckRadioView;
import com.zhihu.matisse.internal.ui.widget.CheckView;
import com.zhihu.matisse.internal.ui.widget.IncapableDialog;
import com.zhihu.matisse.internal.utils.PhotoMetadataUtils;
import com.zhihu.matisse.internal.utils.Platform;

public abstract class BasePreviewActivity
extends AppCompatActivity
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    public static final String EXTRA_DEFAULT_BUNDLE = "extra_default_bundle";
    public static final String EXTRA_RESULT_BUNDLE = "extra_result_bundle";
    public static final String EXTRA_RESULT_APPLY = "extra_result_apply";
    public static final String EXTRA_RESULT_ORIGINAL_ENABLE = "extra_result_original_enable";
    public static final String CHECK_STATE = "checkState";
    protected final SelectedItemCollection mSelectedCollection = new SelectedItemCollection((Context)this);
    protected SelectionSpec mSpec;
    protected ViewPager mPager;
    protected PreviewPagerAdapter mAdapter;
    protected CheckView mCheckView;
    protected TextView mButtonBack;
    protected TextView mButtonApply;
    protected TextView mSize;
    protected int mPreviousPos = -1;
    private LinearLayout mOriginalLayout;
    private CheckRadioView mOriginal;
    protected boolean mOriginalEnable;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(SelectionSpec.getInstance().themeId);
        super.onCreate(savedInstanceState);
        if (!SelectionSpec.getInstance().hasInited) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.setContentView(R.layout.activity_media_preview);
        if (Platform.hasKitKat()) {
            this.getWindow().addFlags(0x4000000);
        }
        this.mSpec = SelectionSpec.getInstance();
        if (this.mSpec.needOrientationRestriction()) {
            this.setRequestedOrientation(this.mSpec.orientation);
        }
        if (savedInstanceState == null) {
            this.mSelectedCollection.onCreate(this.getIntent().getBundleExtra(EXTRA_DEFAULT_BUNDLE));
            this.mOriginalEnable = this.getIntent().getBooleanExtra(EXTRA_RESULT_ORIGINAL_ENABLE, false);
        } else {
            this.mSelectedCollection.onCreate(savedInstanceState);
            this.mOriginalEnable = savedInstanceState.getBoolean(CHECK_STATE);
        }
        this.mButtonBack = (TextView)this.findViewById(R.id.button_back);
        this.mButtonApply = (TextView)this.findViewById(R.id.button_apply);
        this.mSize = (TextView)this.findViewById(R.id.size);
        this.mButtonBack.setOnClickListener((View.OnClickListener)this);
        this.mButtonApply.setOnClickListener((View.OnClickListener)this);
        this.mPager = (ViewPager)this.findViewById(R.id.pager);
        this.mPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mAdapter = new PreviewPagerAdapter(this.getSupportFragmentManager(), null);
        this.mPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mCheckView = (CheckView)this.findViewById(R.id.check_view);
        this.mCheckView.setCountable(this.mSpec.countable);
        this.mCheckView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Item item = BasePreviewActivity.this.mAdapter.getMediaItem(BasePreviewActivity.this.mPager.getCurrentItem());
                if (BasePreviewActivity.this.mSelectedCollection.isSelected(item)) {
                    BasePreviewActivity.this.mSelectedCollection.remove(item);
                    if (BasePreviewActivity.this.mSpec.countable) {
                        BasePreviewActivity.this.mCheckView.setCheckedNum(Integer.MIN_VALUE);
                    } else {
                        BasePreviewActivity.this.mCheckView.setChecked(false);
                    }
                } else if (BasePreviewActivity.this.assertAddSelection(item)) {
                    BasePreviewActivity.this.mSelectedCollection.add(item);
                    if (BasePreviewActivity.this.mSpec.countable) {
                        BasePreviewActivity.this.mCheckView.setCheckedNum(BasePreviewActivity.this.mSelectedCollection.checkedNumOf(item));
                    } else {
                        BasePreviewActivity.this.mCheckView.setChecked(true);
                    }
                }
                BasePreviewActivity.this.updateApplyButton();
                if (BasePreviewActivity.this.mSpec.onSelectedListener != null) {
                    BasePreviewActivity.this.mSpec.onSelectedListener.onSelected(BasePreviewActivity.this.mSelectedCollection.asListOfUri(), BasePreviewActivity.this.mSelectedCollection.asListOfString());
                }
            }
        });
        this.mOriginalLayout = (LinearLayout)this.findViewById(R.id.originalLayout);
        this.mOriginal = (CheckRadioView)this.findViewById(R.id.original);
        this.mOriginalLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int count = BasePreviewActivity.this.countOverMaxSize();
                if (count > 0) {
                    IncapableDialog incapableDialog = IncapableDialog.newInstance("", BasePreviewActivity.this.getString(R.string.error_over_original_count, new Object[]{count, BasePreviewActivity.this.mSpec.originalMaxSize}));
                    incapableDialog.show(BasePreviewActivity.this.getSupportFragmentManager(), IncapableDialog.class.getName());
                    return;
                }
                BasePreviewActivity.this.mOriginalEnable = !BasePreviewActivity.this.mOriginalEnable;
                BasePreviewActivity.this.mOriginal.setChecked(BasePreviewActivity.this.mOriginalEnable);
                if (!BasePreviewActivity.this.mOriginalEnable) {
                    BasePreviewActivity.this.mOriginal.setColor(-1);
                }
                if (BasePreviewActivity.this.mSpec.onCheckedListener != null) {
                    BasePreviewActivity.this.mSpec.onCheckedListener.onCheck(BasePreviewActivity.this.mOriginalEnable);
                }
            }
        });
        this.updateApplyButton();
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.mSelectedCollection.onSaveInstanceState(outState);
        outState.putBoolean(CHECK_STATE, this.mOriginalEnable);
        super.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        this.sendBackResult(false);
        super.onBackPressed();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.button_back) {
            this.onBackPressed();
        } else if (v.getId() == R.id.button_apply) {
            this.sendBackResult(true);
            this.finish();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        PreviewPagerAdapter adapter = (PreviewPagerAdapter)this.mPager.getAdapter();
        if (this.mPreviousPos != -1 && this.mPreviousPos != position) {
            ((PreviewItemFragment)((Object)adapter.instantiateItem((ViewGroup)this.mPager, this.mPreviousPos))).resetView();
            Item item = adapter.getMediaItem(position);
            if (this.mSpec.countable) {
                int checkedNum = this.mSelectedCollection.checkedNumOf(item);
                this.mCheckView.setCheckedNum(checkedNum);
                if (checkedNum > 0) {
                    this.mCheckView.setEnabled(true);
                } else {
                    this.mCheckView.setEnabled(!this.mSelectedCollection.maxSelectableReached());
                }
            } else {
                boolean checked = this.mSelectedCollection.isSelected(item);
                this.mCheckView.setChecked(checked);
                if (checked) {
                    this.mCheckView.setEnabled(true);
                } else {
                    this.mCheckView.setEnabled(!this.mSelectedCollection.maxSelectableReached());
                }
            }
            this.updateSize(item);
        }
        this.mPreviousPos = position;
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void updateApplyButton() {
        int selectedCount = this.mSelectedCollection.count();
        if (selectedCount == 0) {
            this.mButtonApply.setText(R.string.button_sure_default);
            this.mButtonApply.setEnabled(false);
        } else if (selectedCount == 1 && this.mSpec.singleSelectionModeEnabled()) {
            this.mButtonApply.setText(R.string.button_sure_default);
            this.mButtonApply.setEnabled(true);
        } else {
            this.mButtonApply.setEnabled(true);
            this.mButtonApply.setText((CharSequence)this.getString(R.string.button_sure, new Object[]{selectedCount}));
        }
        if (this.mSpec.originalable) {
            this.mOriginalLayout.setVisibility(0);
            this.updateOriginalState();
        } else {
            this.mOriginalLayout.setVisibility(8);
        }
    }

    private void updateOriginalState() {
        this.mOriginal.setChecked(this.mOriginalEnable);
        if (!this.mOriginalEnable) {
            this.mOriginal.setColor(-1);
        }
        if (this.countOverMaxSize() > 0 && this.mOriginalEnable) {
            IncapableDialog incapableDialog = IncapableDialog.newInstance("", this.getString(R.string.error_over_original_size, new Object[]{this.mSpec.originalMaxSize}));
            incapableDialog.show(this.getSupportFragmentManager(), IncapableDialog.class.getName());
            this.mOriginal.setChecked(false);
            this.mOriginal.setColor(-1);
            this.mOriginalEnable = false;
        }
    }

    private int countOverMaxSize() {
        int count = 0;
        int selectedCount = this.mSelectedCollection.count();
        for (int i = 0; i < selectedCount; ++i) {
            float size;
            Item item = this.mSelectedCollection.asList().get(i);
            if (!item.isImage() || !((size = PhotoMetadataUtils.getSizeInMB(item.size)) > (float)this.mSpec.originalMaxSize)) continue;
            ++count;
        }
        return count;
    }

    protected void updateSize(Item item) {
        if (item.isGif()) {
            this.mSize.setVisibility(0);
            this.mSize.setText((CharSequence)(PhotoMetadataUtils.getSizeInMB(item.size) + "M"));
        } else {
            this.mSize.setVisibility(8);
        }
        if (item.isVideo()) {
            this.mOriginalLayout.setVisibility(8);
        } else if (this.mSpec.originalable) {
            this.mOriginalLayout.setVisibility(0);
        }
    }

    protected void sendBackResult(boolean apply) {
        Intent intent = new Intent();
        intent.putExtra(EXTRA_RESULT_BUNDLE, this.mSelectedCollection.getDataWithBundle());
        intent.putExtra(EXTRA_RESULT_APPLY, apply);
        intent.putExtra(EXTRA_RESULT_ORIGINAL_ENABLE, this.mOriginalEnable);
        this.setResult(-1, intent);
    }

    private boolean assertAddSelection(Item item) {
        IncapableCause cause = this.mSelectedCollection.isAcceptable(item);
        IncapableCause.handleCause((Context)this, cause);
        return cause == null;
    }
}

